<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Blog {
	// CLASS FUNCTIONS
	// Blog
	// getBlog
	// updateBlog
	// insertBlog
	// selBlogs
	// deleteBlogs
	// getBlogCount
	

	// Blog --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th December 2004
	//
	function Blog($db, $rsp_item_type_id, $date, $file = null) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		$this->date = $date;

		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Blog



	// getBlog --------------------------------------------------------------------
	// gets a single record from the DB
	// tom calthrop - 22nd May 2004
	//
	function getBlog() {
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			b.user_id, b.file_id, b.blog_body, b.group_id,
			b.blog_allow_comments, b.blog_edit_datetime 
			FROM " . $this->db->prefix . "_blog b
			where "
		;
		
		if (isset($this->blog_id)) {
		    $query .= "b.blog_id=" . $this->db->qstr($this->blog_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (!empty($this->user_id)) {
		    $query .= "b.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->group_id) && $this->group_id == 0) {
		    $query .= "b.group_id is null AND ";
		}
		elseif (isset($this->group_id)) {
		    $query .= "b.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		$query .= "1=1 ";
		
		$query .= "order by b.blog_create_datetime desc";
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows

		if (isset($result->fields)) {

			$temp = $result->fields;
			$this->blog_id = $temp['blog_id'];

			if (!empty($temp['blog_create_datetime'])) {
				$temp['blog_create_datetime'] = $this->date->formatDate($temp['blog_create_datetime'], 1);
			}
			if (!empty($temp['blog_edit_datetime'])) {
			    $temp['blog_edit_datetime'] = $this->date->formatDate($temp['blog_edit_datetime'], 1);
			}

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=getBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getBlog



	// updateBlog --------------------------------------------------------------------
	// updates a single blog record in DB
	// tom calthrop - 22nd May 2004
	//
	function updateBlog($data, $user_id = null) {

		if(empty($data['blog_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['blog_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(21, null, null);
		}

		if(empty($data['blog_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {

			if (empty($data['blog_allow_comments'])) {
			    $data['blog_allow_comments'] = "null";
			}

			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_blog 
				WHERE 
				blog_id=" . $this->db->qstr($data['blog_id'],get_magic_quotes_gpc())
			;

			if(isset($this->group_id)) {
			  $query .= ' AND group_id=' . $this->db->qstr($this->group_id,get_magic_quotes_gpc());
			}
			if(!is_null($user_id)) {
			  $query .= ' AND user_id=' . $this->db->qstr($user_id,get_magic_quotes_gpc());
			}

			$result = $this->db->Execute($query);
			if($result->EOF) {
			  return -1;
			}

			$rec = array();
			$rec['blog_title'] = $data['blog_title'];
			$rec['blog_synopsis'] = $data['blog_synopsis'];
			$rec['blog_body'] = $data['blog_body'];
			$rec['language_id'] = $data['language_id'];
			$rec['file_id'] = $data['file_id'];
			$rec['blog_allow_comments'] = $data['blog_allow_comments'];
			$rec['blog_edit_datetime'] = time();
			
			$table = $this->db->prefix . "_blog";
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$this->blog_id = $data['blog_id'];
			
			if (empty($result)) {
				$error_info = "function=updateBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}

	} //EO updateBlog



	// insertBlog --------------------------------------------------------------------
	// inserts a single blog in the DB
	// tom calthrop - 22nd May 2004
	//
	function insertBlog($data) {

		if(empty($data['blog_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['blog_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(21, null, null);
		}

		if(empty($data['blog_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}

			if (empty($data['language_id'])) {
			    $data['language_id'] = "null";
			}

			if (empty($data['blog_allow_comments'])) {
			    $data['blog_allow_comments'] = "null";
			}
			
			if (isset($this->group_id)) {
			    $group_id = $this->group_id;
			}
			else {
				$group_id = "null";
			}
			
			$rec = array();
			$rec['group_id'] = $group_id;
			$rec['blog_title'] = $data['blog_title'];
			$rec['blog_synopsis'] = $data['blog_synopsis'];
			$rec['blog_body'] = $data['blog_body'];
			$rec['language_id'] = $data['language_id'];
			$rec['file_id'] = $data['file_id'];
			$rec['blog_create_datetime'] = time();
			$rec['user_id'] = $this->user_id;
			$rec['blog_allow_comments'] = $data['blog_allow_comments'];
			
			$table = $this->db->prefix . "_blog";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->blog_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertBlog class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertBlog



	// selBlogs --------------------------------------------------------------------
	// returns multiple rows of blogs from DB
	// tom calthrop - 22nd May 2004
	//
	function selBlogs($search=null) {
		$query = "
			SELECT DISTINCT b.blog_id, b.blog_title, b.blog_synopsis, b.blog_create_datetime,
			b.user_id, b.file_id, b.blog_body, b.group_id, b.blog_allow_comments "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", p.profile_create_datetime, p.profile_nic, p.profile_hometown, rsp.rsp_sticky ";
		}
			
		$query .= "FROM " . $this->db->prefix . "_blog b ";
		
		if (isset($this->tag)) {
			$query .= ", " . $this->db->prefix . "_tag t  ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", " . $this->db->prefix . "_rsp rsp, 
			" . $this->db->prefix . "_user_profile p ";
		}
		
		$query .= "WHERE ";
		
		if (isset($this->tag)) {
			$query .= "
				b.blog_id=t.item_id AND 
				t.user_id=" . $this->db->qstr($this->me['user_id'],get_magic_quotes_gpc()) . " AND 
				t.rsp_item_type_id=" . $this->db->qstr($this->item_types['blog'],get_magic_quotes_gpc()) . " AND
				t.tag_body like " . $this->db->qstr("%" . $this->tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "
				rsp.item_id=b.blog_id AND
				b.user_id=p.user_id AND p.profile_default=1 AND
				rsp.level_id=" . $this->db->qstr($this->rsp_level_id,get_magic_quotes_gpc()) . " AND 
				rsp.rsp_item_type_id=" . $this->db->qstr($this->rsp_item_type_id,get_magic_quotes_gpc()) . " AND "
			;
			
			if (isset($this->rsp_status_id)) {
				$query .= "rsp.status_id=" . $this->db->qstr($this->rsp_status_id,get_magic_quotes_gpc()) . " AND ";
			}
			
			if (isset($this->degree_id)) {
				$query .= "(rsp.degree_id IS NULL OR rsp.degree_id>=" . $this->db->qstr($this->degree_id,get_magic_quotes_gpc()) . ") AND ";
			}
		}

		if (isset($search)) {
			$query .= "(
				b.blog_title like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR 
				b.blog_body like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . ") AND "
			;
		}
		
		if (isset($this->user_id)) {
		    $query .= "b.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}

		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="b.user_id in (" . $user_ids . ") and ";
		}
		
		if (isset($this->group_id) && !empty($this->group_id)) {
		    $query .= "b.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
		} elseif (isset($this->group_id) && empty($this->group_id)) {
			$query .= "b.group_id is null AND ";
		}
		
		if (isset($this->blog_ids)) { //used for bookmarks
			$blog_ids = "";
			foreach($this->blog_ids as $key => $i):
				$blog_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->blog_ids) > $key+1) {
					$blog_ids .=",";
				}
			endforeach;
			$query .= "b.blog_id in (" . $blog_ids . ") AND ";
		}

		if (isset($this->before_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->before_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "b.blog_create_datetime <= " . $datetime . " AND ";
		}

		if (isset($this->after_timestamp)) {
			$datetime = date("Y-m-d H:i:s", $this->after_timestamp);
			$datetime = $this->db->DBDate($datetime);
			$query .= "b.blog_create_datetime >= " . $datetime . " AND ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by b." . $this->order_by;
		}
		else {
			$query .= "order by b.blog_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;
				$temp1['blog_create_timestamp'] = $this->date->formatDate($temp1['blog_create_datetime'], 3);
				$temp1['blog_create_datetime'] = $this->date->formatDate($temp1['blog_create_datetime'], 1);

				if (isset($this->file)) {
					if ($temp1['group_id'] > 0) {
						$this->file->path = $this->file->config_ids['image']['path']['group'];
					}
					else {
					    $this->file->path = $this->file->config_ids['image']['path']['user'];
					}
					
					if (isset($temp1['file_id'])) {
	 					$this->file->file_id = $temp1['file_id'];
	 					$temp1['image'] = $this->file->getFileRecord();
	 				}
	 				else {
	 					$temp1['image']['file_id'] = "";
	 					$temp1['image']['file'] = $this->file->noimage;
	 				}
				}

				//format search results
				if (isset($search)) {
					$temp1['blog_synopsis'] = searchTextFormat($search, $temp1['blog_synopsis']);
					$temp1['blog_title'] = searchTextFormat($search, $temp1['blog_title']);
				}

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selBlogs class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selBlogs()



	// deleteBlogs --------------------------------------------------------------------
	// deletes multiple rows of blogs from DB
	// tom calthrop - 22nd May 2004
	//
	function deleteBlogs($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_blog
				WHERE
				blog_id = " . $this->db->qstr($del_arr[$i],get_magic_quotes_gpc())
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$GLOBALS['am_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
			}
		}
	}//EO deleteBlogs




	// getBlogCount --------------------------------------------------------------------
	// will get the coutn of unique page names
	// tom calthrop - 27th December 2004
	//
	function getBlogCount($user_id = null) {
		$query = "
			SELECT count(b.blog_id) as total
			FROM " . $this->db->prefix . "_blog b 
			WHERE "
		;
		
		if (isset($this->group_id)) {
		    $query .= "b.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
		}

		if (isset($this->user_id)) {
			$query .= "b.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getBlogCount class=Blog.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getBlogCount
}

?>
