<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


class Channel {
	// CLASS FUNCTIONS
	// Channel
	// insertChannel
	// selChannels
	// selChannel
	// deleteChannel
	// updateChannel



	// Channel -------------------------------------------------------------
	// the constuctor
	// tom calthrop - 11th June 2005
	//
	function Channel($db) {
		$this->db = $db;
	}//EO Channel



	// insertChannel --------------------------------------------------------------------
	// inserts a single item in the Channel table
	// tom calthrop - 11th June 2005
	//
	function insertChannel($data) {
		
		if(empty($data['channel_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if(empty($data['channel_url'])) {
			$GLOBALS['am_error_log'][] = array(44, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			
			if(empty($data['group_id'])) {
				$data['group_id'] = "null";
			}
			
			if(empty($data['channel_synopsis'])) {
				$data['channel_synopsis'] = "null";
			}
			
			$rec = array();
			$rec['channel_url'] = $data['channel_url'];
			$rec['group_id'] = $data['group_id'];
			$rec['channel_title'] = $data['channel_title'];
			$rec['channel_synopsis'] = $data['channel_synopsis'];
			$rec['user_id'] = $this->user_id;
			$rec['language_id'] = $this->language_id;
			
			$table = $this->db->prefix . "_channel";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->channel_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertChannel class=Channel.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, null, $error_info);
			}
		}
	} //EO insertChannel
	
	
	
	// selChannels --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// tom calthrop - 11th June 2005
	//
	function selChannels($search=null) {
		$query = "
			SELECT c.channel_id, c.channel_title, c.channel_url, 
			c.group_id, c.user_id, c.channel_synopsis 
			FROM " . $this->db->prefix . "_channel c "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", " . $this->db->prefix . "_rsp rsp ";
		}
		
		$query .="WHERE ";
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "
				rsp.item_id=c.channel_id AND
				rsp.level_id=" . $this->db->qstr($this->rsp_level_id,get_magic_quotes_gpc()) . " AND 
				rsp.rsp_item_type_id=" . $this->db->qstr($this->rsp_item_type_id,get_magic_quotes_gpc()) . " AND "
			;
			
			if (isset($this->rsp_status_id)) {
				$query .= "rsp.status_id=" . $this->db->qstr($this->rsp_status_id,get_magic_quotes_gpc()) . " AND ";
			}
		}
		
		if (isset($this->language_ids)) {
			$language_ids = "";
			foreach($this->language_ids as $key => $i):
				$language_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->language_ids) > $key+1) {
					$language_ids .=",";
				}
			endforeach;
			$query .= "c.language_id in (" . $language_ids . ") AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "c.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->group_id)) {
			if ($this->group_id > 0) {
				$query .= "c.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
			}
			else {
				$query .= "c.group_id is null AND ";
			}
		}
		
		if (isset($search)) {
			$searchStr = "%". $search . "%";
			
			$query .= "(
				c.channel_title like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . " OR 
				c.channel_synopsis like " . $this->db->qstr($searchStr, get_magic_quotes_gpc()) . ") AND "
			;
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by c.channel_title";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				$temp1 = $result->fields;
				//format search results
				if (isset($search)) {
					$temp1['channel_title'] = searchTextFormat($search, $temp1['channel_title']);
					$temp1['channel_synopsis'] = searchTextFormat($search, $temp1['channel_synopsis']);
				}
				
				array_push($temp, $temp1);
				
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=selChannels class=Channel.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selChannels()
	
	
	
	// selChannel --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// tom calthrop - 11th June 2005
	//
	function selChannel($channel_id) {
		$query = "
			SELECT c.channel_id, c.channel_title, c.channel_url, 
			c.group_id, c.user_id, c.channel_synopsis 
			FROM " . $this->db->prefix . "_channel c  
			WHERE 
			c.channel_id=" . $this->db->qstr($channel_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->SelectLimit($query, 1);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			return $temp;
		}
		else {
			$error_info = "function=selChannel class=Channel.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selChannel()



	// deleteChannel --------------------------------------------------------------------
	// delete item from channle table
	// tom calthrop - 11th June 2005
	//
	function deleteChannel($del_id) {
		$query = "
			DELETE from " . $this->db->prefix . "_channel
			WHERE
			channel_id = " . $this->db->qstr($del_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteChannel class=Channel.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteChannel
	
	
	
	// updateChannel --------------------------------------------------------------------
	// updates a channel
	// tom calthrop - 11th June 2005
	//
	function updateChannel($data) {
		if(empty($data['channel_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if(empty($data['channel_url'])) {
			$GLOBALS['am_error_log'][] = array(44, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			
			if(empty($data['group_id'])) {
				$data['group_id'] = "null";
			}
			
			if(empty($data['channel_synopsis'])) {
				$data['channel_synopsis'] = "null";
			}
				
			$query = "
				SELECT * FROM " . $this->db->prefix . "_channel 
				WHERE channel_id = " . $this->db->qstr($data['channel_id'],get_magic_quotes_gpc())
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['channel_url'] = $data['channel_url'];
			$rec['channel_title'] = $data['channel_title'];
			$rec['channel_synopsis'] = $data['channel_synopsis'];
			$rec['language_id'] = $this->language_id;
				
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			if(empty($query)) {
				return ;
			}
			$result = $this->db->Execute($query);

			if (!isset($result->fields)) {
				$error_info = "function=updateChannel class=Channel.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, null, $error_info);
			}
		}
	
	} //EO updateChannel();
}

?>
