<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Forum {
	// CLASS FUNCTIONS
	// Forum
	// getTopics
	// selSubjects
	// getSubjectMovement
	// getSubject
	// insertSubject
	// updateSubject
	// insertTopic
	// getTopic
	// updateTopic
	// getSubjectCount
	// deleteSubject
	// deleteTopic
	// SelTopicRoles
	// insertTopicRoles



	// Forum --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 21st Feb 2004
	//
	function Forum($db, $rsp_item_type_id, $date, $file = null) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		$this->date = $date;

		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Forum



	// getSectionTopics --------------------------------------------------------------------
	// returns one section row and associated topis from the Db
	// tom calthrop - 21st Feb 2004
	//
	function getTopics($include_subjects = null, $search = null) {
		$query = "
			SELECT t.topic_id, t.topic_title, t.topic_synopsis, t.topic_hidden, 
			t.topic_order 
			FROM " . $this->db->prefix . "_forum_topic t 
			where "
		;
		
		if (isset($this->user_id)) {
		    $query .= "t.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->group_id)) {
		    $query .= "t.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (!isset($this->include_hidden)) {
		    $query .= "t.topic_hidden is null and ";
		}

		if (isset($this->topic_ids)) {
			$topic_ids = "";
			foreach($this->topic_ids as $key => $i):
				$topic_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->topic_ids) > $key+1) {
				    $topic_ids .=",";
				}
			endforeach;
			$query .="t.topic_id in (" . $topic_ids . ") AND ";
		}

		$query .= "1=1 order by t.topic_order, t.topic_title";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if (isset($include_subjects)) {
				    $this->topic_id = $temp1['topic_id'];
					$temp1['subjects'] = $this->selSubjects($search);
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getSectionTopics class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSectionTopics



	// selSubjects --------------------------------------------------------------------
	// returns multiple rows from DB
	// tom calthrop - 21st Feb 2004
	//
	function selSubjects($search = null) {
		$query = "
			SELECT s.subject_id, s.group_id, s.topic_id, s.subject_title, s.file_id,
			s.user_id, s.subject_hidden, s.subject_body, s.subject_create_datetime,
			s.subject_locked, s.subject_sticky "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", p.profile_create_datetime, p.profile_nic, p.profile_hometown, rsp.rsp_sticky ";
		}
			
		$query .= "FROM " . $this->db->prefix . "_forum_subject s ";
		
		if (isset($this->tag)) {
			$query .= ", " . $this->db->prefix . "_tag t  ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= ", " . $this->db->prefix . "_rsp rsp ,
			" . $this->db->prefix . "_user_profile p ";
		}
		
		$query .= "WHERE ";
		
		if (isset($this->tag)) {
			$query .= "
				s.subject_id=t.item_id AND 
				t.user_id=" . $this->db->qstr($this->me['user_id'],get_magic_quotes_gpc()) . " AND 
				t.rsp_item_type_id=" . $this->db->qstr($this->item_types['forum'],get_magic_quotes_gpc()) . " AND
				t.tag_body like " . $this->db->qstr("%" . $this->tag . "%", get_magic_quotes_gpc()) . " AND "
			;
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "
				rsp.item_id=s.subject_id AND
				p.user_id=s.user_id AND p.profile_default=1 AND 
				rsp.level_id=" . $this->db->qstr($this->rsp_level_id,get_magic_quotes_gpc()) . " AND 
				rsp.rsp_item_type_id=" . $this->db->qstr($this->rsp_item_type_id,get_magic_quotes_gpc()) . " AND "
			;
			
			if (isset($this->rsp_status_id)) {
				$query .= "rsp.status_id=" . $this->db->qstr($this->rsp_status_id,get_magic_quotes_gpc()) . " AND ";
			}
			
			if (isset($this->degree_id)) {
				$query .= "rsp.degree_id>=" . $this->db->qstr($this->degree_id,get_magic_quotes_gpc()) . " AND ";
			}
		}

		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->group_id)) {
		    $query .= "s.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
		}

		if (!isset($this->include_hidden)) {
		    $query .= "subject_hidden is null and ";
		}
		
		if (isset($search)) {
		    $query .= "
				(s.subject_title like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR 
				s.subject_body like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . ") AND "
			;
		}

		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="s.user_id in (" . $user_ids . ") and ";
		}

		if (isset($this->topic_id)) {
		    $query .= "s.topic_id=" . $this->db->qstr($this->topic_id,get_magic_quotes_gpc()) . " and ";
		}

		if (isset($this->subject_ids)) { //used for bookmarks
			$subject_ids = "";
			foreach($this->subject_ids as $key => $i):
				$subject_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->subject_ids) > $key+1) {
					$subject_ids .=",";
				}
			endforeach;
			$query .= "s.subject_id in (" . $subject_ids . ") AND ";
		}

		$query .="1=1 ";
		
		if (isset($this->order)) {
			$query .= "order by " . $this->order;
		} else {
			$query .= "order by s.subject_sticky desc, s.subject_create_datetime desc";
		}

		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if (isset($search)) { //format search results
					$temp1['subject_title'] = searchTextFormat($search, $temp1['subject_title']);
					$temp1['subject_body'] = searchTextFormat($search, $temp1['subject_body']);
				}

				if (isset($this->file)) {
					if ($temp1['group_id'] > 0) {
						$this->file->path = $this->file->config_ids['image']['path']['group'];
					}
					else {
					    $this->file->path = $this->file->config_ids['image']['path']['user'];
					}
					
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}

				$temp1['subject_create_timestamp'] = $this->date->formatDate($temp1['subject_create_datetime'],3);
				$temp1['subject_create_datetime'] = $this->date->formatDate($temp1['subject_create_datetime']);

				$temp1['subject_body'] = nl2br($temp1['subject_body']);

				//get the bookmarks and last view datetime
				if (isset($this->bookmark)) {
					$temp1['movement'] = $this->getSubjectMovement($temp1['subject_id']);
				}

				if (isset($this->comment)) {
					$temp1['comment_total'] = $this->comment->getCommentCount($temp1['subject_id']);
					$this->comment->limit = 1;
					$temp1['last_comment'] = $this->comment->getComment($temp1['subject_id'], 1);
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selSubjects class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selSubjects



	// getSubjectMovement --------------------------------------------------------------------
	// We get the movement of the subject from when we last looked to now.
	// tom calthrop - 23rd November 2004
	//
	function getSubjectMovement($subject_id) {
		//get the last view date
		$this->bookmark->bookmark_item_id = $subject_id;
		$lastviewdate = $this->bookmark->getBookmarkLastViewDate($subject_id);

		//select the movement
		if (!empty($lastviewdate)) {
			$temp = array();
			$temp['lastview_datetime'] = $this->date->formatDate($lastviewdate);

			$temp['movement'] = $this->comment->getCommentCount(null, $lastviewdate);

			if ($temp['movement'] < 1) {
				$temp['movement'] = 0;
			}
			return $temp;
		}
	}//EO getSubjectMovement



	// getSubject --------------------------------------------------------------------
	// returns a row from DB
	// tom calthrop - 21st Feb 2004
	//
	function getSubject() {
		$query = "
			SELECT s.subject_id, s.topic_id, s.subject_title, s.file_id, s.user_id, s.subject_hidden,
			s.subject_body, s.subject_create_datetime, s.subject_locked, s.subject_sticky,
			s.group_id 
			FROM " . $this->db->prefix . "_forum_subject s 
			where 
			s.subject_id=" . $this->db->qstr($this->subject_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
		   if(!empty($result->fields)) {
			$temp = $result->fields;
			$temp['subject_create_datetime'] = $this->date->formatDate($temp['subject_create_datetime']);
			$temp['display_subject_body'] = nl2br($temp['subject_body']);
			$result->Close();

			return $temp;
		   } else {
		     return null;
		   }
		}
		else {
			$error_info = "function=getSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSubject



	// insertSubject --------------------------------------------------------------------
	// updates a total number of replies into subject row into DB
	// tom calthrop - 8th Jan 2004
	//
	function insertSubject($data) {
		if (empty($data['subject_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if (empty($data['subject_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['subject_hidden'])) {
			    $data['subject_hidden'] = "null";
			}

			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}

			if (empty($data['subject_sticky'])) {
			    $data['subject_sticky'] = "null";
			}

			if (empty($data['subject_locked'])) {
			    $data['subject_locked'] = "null";
			}
			
			if (isset($this->group_id)) {
			    $group_id = $this->group_id;
			}
			else {
				$group_id = "null";
			}
			
			$rec = array();
			$rec['group_id'] = $group_id;
			$rec['topic_id'] = $data['topic_id'];
			$rec['subject_title'] = $data['subject_title'];
			$rec['subject_body'] = $data['subject_body'];
			$rec['subject_create_datetime'] = time();
			$rec['user_id'] = $this->user_id;
			$rec['file_id'] = $data['file_id'];
			$rec['subject_sticky'] = $data['subject_sticky'];
			$rec['subject_locked'] = $data['subject_locked'];
			$rec['subject_hidden'] = $data['subject_hidden'];
			
			$table = $this->db->prefix . "_forum_subject";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->subject_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO insertSubject



	// updateSubject --------------------------------------------------------------------
	// updates subject row into DB
	// tom calthrop - 8th Jan 2004
	//
	function updateSubject($data) {
		
		if (empty($data['subject_hidden'])) {
		    $data['subject_hidden'] = "null";
		}

		if (empty($data['subject_sticky'])) {
	    	$data['subject_sticky'] = "null";
		}

		if (empty($data['subject_locked'])) {
		    $data['subject_locked'] = "null";
		}

		if (empty($data['file_id'])) {
		    $data['file_id'] = "null";
		}
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_forum_subject
			WHERE 
			subject_id =" . $this->db->qstr($this->subject_id,get_magic_quotes_gpc()) . " AND 
			group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);
		if($result->EOF) {
		  return -1;
		}

		$rec = array();
		$rec['topic_id'] = $data['topic_id'];
		$rec['subject_title'] = $data['subject_title'];
		$rec['subject_body'] = $data['subject_body'];
		$rec['subject_sticky'] = $data['subject_sticky'];
		$rec['subject_edit_datetime'] = time();
		$rec['subject_locked'] = $data['subject_locked'];
		$rec['subject_hidden'] = $data['subject_hidden'];
		$rec['file_id'] = $data['file_id'];
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return true;
		}
		else {
			$error_info = "function=updateSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO updateSubject



	// insertTopic --------------------------------------------------------------------
	// inserts a topic
	// tom calthrop - 8th Jan 2004
	//
	function insertTopic($data) {
		if (empty($data['topic_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['topic_synopsis'])) {
			    $data['topic_synopsis'] = "null";
			}

			if (empty($data['topic_hidden'])) {
			    $data['topic_hidden'] = "null";
			}
			
			if (isset($this->group_id)) {
			    $group_id = $this->group_id;
			}
			else {
				$group_id = "null";
			}
			
			$rec = array();
			$rec['group_id'] = $group_id;
			$rec['topic_title'] = $data['topic_title'];
			$rec['topic_synopsis'] = $data['topic_synopsis'];
			$rec['topic_hidden'] = $data['topic_hidden'];
			$rec['topic_create_datetime'] = time();
			$rec['user_id'] = $this->user_id;
			$rec['topic_order'] = 99;
			
			$table = $this->db->prefix . "_forum_topic";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result)) {
				$this->topic_id = $this->db->Insert_ID();
			}
			
			if (empty($result)) {
				$error_info = "function=insertTopic class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO insertTopic



	// getTopic --------------------------------------------------------------------
	// returns a row from DB
	// tom calthrop - 21st December 2004
	//
	function getTopic() {
		$query = "
			SELECT t.topic_id, t.group_id, t.topic_title,
			t.topic_synopsis, t.topic_create_datetime, t.user_id, 
			t.topic_hidden, t.topic_order 
			FROM " . $this->db->prefix . "_forum_topic t 
			where
			t.topic_id=" . $this->db->qstr($this->topic_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = $result->fields;
			$temp['topic_create_datetime'] = $this->date->formatDate($temp['topic_create_datetime']);

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=getTopic class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTopic



	// updateTopic --------------------------------------------------------------------
	// updates a row from DB
	// tom calthrop - 21st December 2004
	//
	function updateTopic($data) {

		if (empty($data['topic_synopsis'])) {
		    $data['topic_synopsis'] = "null";
		}

		if (empty($data['topic_hidden'])) {
		    $data['topic_hidden'] = "null";
		}
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_forum_topic 
			WHERE 
			topic_id=" . $this->db->qstr($data['topic_id'],get_magic_quotes_gpc()) . " AND 
			group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);
		if($result->EOF) {
		  return -1;
		}

		$rec = array();
		$rec['topic_title'] = $data['topic_title'];
		$rec['topic_synopsis'] = $data['topic_synopsis'];
		$rec['topic_hidden'] = $data['topic_hidden'];
		$rec['topic_order'] = $data['topic_order'];
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	}//EO updateTopic



	// getSubjectCount --------------------------------------------------------------------
	// get the total subjects
	// tom calthrop - 23rd November 2004
	//
	function getSubjectCount($user_id = null) {

		$query = "
			SELECT count(s.subject_id) as total
			FROM " . $this->db->prefix . "_forum_subject s 
			WHERE "
		;
			
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->group_id)) {
		    $query .= "s.group_id=" . $this->db->qstr($this->group_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		if (isset($this->topic_id)) {
		    $query .= "s.topic_id=" . $this->db->qstr($this->topic_id,get_magic_quotes_gpc()) . " and ";
		}
		
		$query .= "1=1 ";

		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getSubjectCount class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getSubjectCount



	// deleteSubject --------------------------------------------------------------------
	// deletes subject row from DB
	// tom calthrop - 28th December 2004
	//
	function deleteSubject($subject_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_subject
			WHERE
			subject_id =" . $this->db->qstr($subject_id,get_magic_quotes_gpc());
		;

		$result = $this->db->Execute($query);

		if (empty($result->fields)) {
			$error_info = "function=updateSubject class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteSubject



	// deleteTopic --------------------------------------------------------------------
	// deletes topic row from DB
	// tom calthrop - 28th December 2004
	//
	function deleteTopic($topic_id) {
		if(isset($this->topic_id)) {
		  $temp_topic_id = $this->topic_id;
		}
		$this->topic_id = $topic_id;

		$subject_count = $this->getSubjectCount();
		if(isset($temp_topic_id)) {
		  $this->topic_id = $temp_topic_id;
		} else {
		  unset($this->topic_id);
		}
		
		if(!empty($subject_count)) {
		  return null;
		}

		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_topic 
			WHERE
			topic_id =" . $this->db->qstr($topic_id,get_magic_quotes_gpc()) . " AND 
			group_id =" . $this->db->qstr($this->group_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteTopic class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteTopic
	
	
	
	// SelTopicRoles --------------------------------------------------------------------
	// returns multiple rows from DB
	// tom calthrop - 21st Feb 2004
	//
	function SelTopicRoles($role_id = null) {
		$query = "
			SELECT tr.role_id, tr.topic_id, r.role_name 
			FROM " . $this->db->prefix . "_forum_topic_role tr, " . $this->db->prefix . "_acs_group_role r 
			WHERE 
			tr.role_id=r.role_id AND "
		;
		
		if (isset($role_id)) {
			$query .= "tr.role_id=" . $this->db->qstr($role_id,get_magic_quotes_gpc());
		}
		else {
			$query .= "tr.topic_id=" . $this->db->qstr($this->topic_id,get_magic_quotes_gpc());
		}
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=SelTopicRoles class=Forum.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO SelTopicRoles



	// insertTopicRoles --------------------------------------------------------------------
	// deletes a  bookmark
	// tom calthrop - 11th December 2004
	//
	function insertTopicRoles($in_arr = null) {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_forum_topic_role
			WHERE topic_id=" . $this->db->qstr($this->topic_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		$rownums = count($in_arr);

		for ($i=0; $i < $rownums; $i++) {
		    $rec = array();
			$rec['role_id'] = $in_arr[$i];
			$rec['topic_id'] = $this->topic_id;
			
			$table = $this->db->prefix . "_forum_topic_role";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
		}
	} //EO insertTopicRoles

}
?>
