<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class User {
	// CLASS FUNCTIONS
	// User
	// checkLogin
	// loginUser
	// setLocale
	// authUser
	// getStatus
	// getUser
	// emailVerification
	// getLanguages
	// getProfile
	// getTemplates
	// getTemplate
	// deleteLanguages
	// getProfiles
	// updateUser
	// insertLanguages
	// createPassword
	// insertProfile
	// updateProfile
	// deleteProfile
	// updateDefaultProfile
	// getDegreeProfiles
	// updateDegreeProfiles
	// createFeedPassword
	// selUserPreferences
	// selUserPreference
	// insertUserPreference
	// deleteUserPreference



	// User --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 19th April 2004
	//
	function User($db, $date) {
		$this->db = $db;
		$this->date = $date;
	}//EO User



	// checkLogin --------------------------------------------------------------------
	// checks if the person can log in
	// tom calthrop - 19th April 2004
	//
	function checkLogin($email, $password){
		if(empty($email))
			$GLOBALS['am_error_log'][] = array(2, null, null);
		else{
			$query = "
				SELECT user_id FROM " . $this->db->prefix . "_user
				WHERE user_email=" . $this->db->qstr($email, get_magic_quotes_gpc())
			;

			$result = $this->db->Execute($query);

			if(empty($result->fields['user_id']))
				$GLOBALS['am_error_log'][] = array(24, null, null);
		}

		// Check whether the password is in the database and correct
		if(empty($password))
			$GLOBALS['am_error_log'][] = array(25, null, null);
		else{
			if(empty($GLOBALS['am_error_log']))
			{
				$query = "
					SELECT user_id, status_id
					FROM " . $this->db->prefix . "_user
					WHERE
					user_email=" . $this->db->qstr($email, get_magic_quotes_gpc()) . " AND
					user_password=" . $this->db->qstr(MD5($password), get_magic_quotes_gpc())
				;

				
				
				$result = $this->db->Execute($query);

				if(empty($result->fields['user_id'])) {
					$GLOBALS['am_error_log'][] = array(19, null, null);
				}

				if($result->fields['status_id'] != $this->status_ids['active']) {
					$GLOBALS['am_error_log'][] = array(26, null, null);
				}
			}
		}

	}//EO checkLogin



	// loginUser --------------------------------------------------------------------
	// logs in the user
	// tom calthrop - 19th April 2004
	//
	function loginUser($email, $password, $node_id) {

		$query = "SELECT
			u.user_id, u.role_id, u.user_email, u.user_firstname, u.user_surname,
			u.user_homepage, t.template_title, u.language_id,
			MD5(UNIX_TIMESTAMP() + user_id + RAND(UNIX_TIMESTAMP())) AS session_id
			FROM " . $this->db->prefix . "_user u, " . $this->db->prefix . "_template t
			WHERE u.template_id = t.template_id AND
			user_email=" . $this->db->qstr($email, get_magic_quotes_gpc()) . " AND
			user_password=" . $this->db->qstr(MD5($password), get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields['user_id'])){
			// Starts a session
			if (empty($_SESSION)) {
			    session_start();
			}
			
			$this->user_id = $result->fields['user_id'];

			// Sets the sessionvariables
			$_SESSION['s_user_id'] = 		$result->fields['user_id'];
			$_SESSION['s_email'] = 			$result->fields['user_email'];
			$_SESSION['s_firstname'] = 		$result->fields['user_firstname'];
			$_SESSION['s_surname'] = 		$result->fields['user_surname'];
			$_SESSION['s_role_id'] = 		$result->fields['role_id'];
			$_SESSION['s_md5'] = 			md5($result->fields['session_id']);
			$_SESSION['s_language_id'] = 	$result->fields['language_id'];
			$_SESSION['s_homepage'] = 		$result->fields['user_homepage'];
			$_SESSION['s_user_template'] = 	$result->fields['template_title'];
			$_SESSION['s_breadcrumb'] = 	array();
			$_SESSION['s_language_ids'] = 	$this->getLanguages();
			
			$rec = array();
			$rec['session_md5'] = $_SESSION['s_md5'];
			$rec['session_firstused'] = mktime();
			$rec['session_lastused'] = mktime();
			$rec['session_ip'] = $_SERVER['REMOTE_ADDR'];
			$rec['user_id'] = $this->user_id;
			
			$table = $this->db->prefix . "_user_session";

			//delete all sessions of login user
			$query = "DELETE FROM " . $this->db->prefix . "_user_session " .
						"WHERE user_id = " . $this->db->qstr($this->user_id,get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result)) {
				//get friends and aquintances
				$this->sn->user_id = $this->user_id;
				$_SESSION['s_social_network'] = $this->sn->createNetwork();
				$this->sn->updateSnStatistics();

				//set total logins statistic
				$this->statistic->user_id = $this->user_id;
				$this->statistic->statistic_type_id = $this->total_login_stat_id;
				$total_logins = $this->statistic->getStatistic();
				if (empty($total_logins)) {
				    $total_logins = 0;
				}
				$total_logins++;
				$this->statistic->setStatistic($total_logins);
				
				//set locale
				if (isset($_SESSION['s_language_id'])) {
				    $this->setLocale($_SESSION['s_language_id']);
				}

				//did we refer from a local page?
				if (!empty($this->http_referer)) {
					return header("Location: " . $this->http_referer);
					exit;
				}
				else {
					return header("Location: " . $_SESSION['s_homepage']."?".SID);
					exit;
				}
			}
			else {
				$GLOBALS['am_error_log'][] = array(1, 1, $this->db->ErrorMsg());
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(19, null, null);
		}
	}//EO loginUser



	// setLocale --------------------------------------------------------------------
	// setup local language for date setting etc
	// tom calthrop - 19th April 2004
	//
	function setLocale($language_id = null) {

		if (isset($language_id) && isset($this->language_arr['pack'][$language_id][0])) {
		    setlocale(LC_ALL,$this->language_arr['pack'][$language_id][0]);
		}
		else { //We default to English
		    setlocale(LC_ALL,"eng");
		}
	}


	function logoffUser () {
		if (!isset($_SESSION)) {
		    session_start();
		}

		$_SESSION = array();
		session_destroy();
	}//EO setLocale



	// authUser --------------------------------------------------------------------
	// check that the user is authorised for entry into system
	// tom calthrop - 19th April 2004
	//
	function authUser () {
		session_start();

		// Check for a session-variable containing the session-id, if none go to login page
		if(empty($_SESSION['s_md5'])) {
			header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']). "&" . SID);
			exit;
		}

		// Authenticate user
		$query = "
			SELECT session_md5
			FROM " . $this->db->prefix . "_user_session
			WHERE user_id = " . $this->db->qstr($_SESSION['s_user_id'],get_magic_quotes_gpc()) . "
			order by session_id desc"
		;

		$result = $this->db->SelectLimit($query, 1);

		// Checks if the session-id in the database and in the session-variables agree
		if($result->fields['session_md5'] != $_SESSION['s_md5']) {
			$this->logoffUser();
			header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . SID);
			exit;
		}


		// Check if user is locked
		$query = "
			SELECT status_id FROM " . $this->db->prefix . "_user
			WHERE
			user_id = " . $this->db->qstr($_SESSION['s_user_id'],get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		// If user is not active...
		if($result->fields['status_id'] != $this->status_ids['active']) {
			header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . SID);
			exit;
		}
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user_session 
			WHERE 
			session_md5=" . $this->db->qstr($_SESSION['s_md5'], get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		
		$rec = array();
		$rec['session_lastused'] = mktime();
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user 
			WHERE 
			user_id=". $this->db->qstr($_SESSION['s_user_id'],get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['active_time'] = mktime();
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		
		// Logging out people who have not been active for 12 hours - they wil be directed
		// to the login-page as their session-id will not match the database session-id
		$logout_timestamp = mktime()-(720*60);

		$query = "
			SELECT user_id
			FROM " . $this->db->prefix . "_user
			WHERE " . $logout_timestamp . " > active_time"
		;

		$result = $this->db->Execute($query);  // Logout if not active for 720 minutes

		// Going through the list and changing the sessions-ids,
		// which forces "really" inactive users to log on again....
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$user_id = $result->fields['user_id'];
				
				$query = "
					SELECT * FROM " . $this->db->prefix . "_user_session 
					WHERE 
					user_id=" . $this->db->qstr($user_id,get_magic_quotes_gpc())
				;
				
				$result2 = $this->db->Execute($query);
				
				$rec = array();
				$rec['session_md5'] = "null";
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result2 = $this->db->Execute($query);
				
				$result->MoveNext();
		  	}
		}

		//set locale
		if (isset($_SESSION['s_language_id'])) {
		    $this->setLocale($_SESSION['s_language_id']);
		}

	}//EO authUser



	// getStatus --------------------------------------------------------------------
	// gets the current status of the user
	// tom calthrop - 19th April 2004
	//
	function getStatus($active_time = null){

		$status = 4; //offline

		$time[1] = 0; //online
		$time[2] = 15; //idle
		$time[3] = 20; // sleeping
		$time[4] = 30; //offline
		
		foreach($time as $key => $t):
			$timedif = $this->db->UserTimeStamp(mktime()-(60*$t), "YmdHis");

			if($active_time <= $timedif) {
				$status = $key;
			}

		endforeach;

		return $status;
	}//EO getStatus



	// getStatus --------------------------------------------------------------------
	// change the user's status... NOT YET FULLY WORKING!
	// tom calthrop - 19th April 2004
	//
	function setStatus($status){
		$time[2] = 15;
		$time[4] = 20;
		$time[6] = 30;
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user 
			WHERE 
			user_id=". $this->db->qstr($_SESSION['s_user_id'],get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		$active_time = "UNIX_TIMESTAMP()-60*" . $time[$status];
		
		$rec = array();
		$rec['active_time'] = $active_time;
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO getStatus




	// getUser --------------------------------------------------------------------
	// retrieves single DB row for user
	// tom calthrop - 19th April 2004
	//
	function getUser($user_id = null) {
		if (empty($user_id) && isset($this->user_id)) {
			$user_id = $this->user_id;
		}

		$query = "
			SELECT u.user_id, u.user_hometown, u.role_id, u.user_create_datetime,
			u.language_id, u.template_id, u.user_firstname, u.user_feed_password,
			u.user_surname, u.user_email, u.user_dob, u.user_gender, u.user_number,
			u.active_time, u.status_id, u.user_file_allocation, u.user_homepage
			FROM " . $this->db->prefix . "_user u
			WHERE "
		;

		if (isset($user_id)) {
		    $query .= "u.user_id=" . $this->db->qstr($user_id,get_magic_quotes_gpc()) . " and ";
		}

		if (isset($this->user_email)) {
		    $query .= "u.user_email=" . $this->db->qstr($this->user_email, get_magic_quotes_gpc()) . " AND ";
		}
		
		$query .= "1=1";

		$result = $this->db->Execute($query);

		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;
			$temp['display_user_create_datetime'] = $this->date->formatDate($temp['user_create_datetime']);

			$this->user_id = $temp['user_id'];

			$result->Close();
			return $temp;
		}
		else {
			header("Location: sn_network.php?" . SID);
			exit;
		}
	}//EO getUser



	// emailVerification --------------------------------------------------------------------
	// sends user an email with the password
	// tom calthrop - 19th April 2004
	//
	function emailVerification($password, $email, $firstname, $language_id, $txt_template){
		//pick up the language file
		$body_file_txt = readTxtFile("language/" . $language_id . "/" . $this->language_dir . "/texts/" . $txt_template);

		//create URL
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname ($_SERVER['PHP_SELF']);
		//sometimes the server adds / as the last characture - we need to check.
		if (substr($url, -1, 1) != "/") {
		    $url .= "/";
		}

		$url .= "setup.php?em=" . $email . "&language_id=" . $language_id;

		if (isset($user->invitee_id)) {
		    $url .= "invitee=" . $this->user_id;
		}
		
		
		$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
		if(!isset($this->txt_message)) {
			$this->txt_message = null;
		}
		$body_file_txt = am_str_replace(array('USERNAME' => $firstname,
											  'URL' => $url,
											  'PASSWORD' => $password,
											  'MESSAGE' => $this->txt_message),
										$body_file_txt);

		//send email to barnraiser
		$this->mail->Body = $body_file_txt;
		$this->mail->AddAddress($email, $firstname);

		if(!$this->mail->Send()) {
			$error_info = "function=emailVerification class=User.class.php - Mailer Error: " . $this->mail->ErrorInfo;
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO emailVerification



	// getLanguages --------------------------------------------------------------------
	// get the languages that the user can read
	// tom calthrop - 18th Nov 2004
	//
	function getLanguages() {
		$query = "
			SELECT language_id FROM " . $this->db->prefix . "_user_language
			WHERE
			user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields['language_id']);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getLanguages class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getLanguages



	// getProfile --------------------------------------------------------------------
	// gets the user profile
	// tom calthrop - 19th December 2004
	//
	function getProfile($profile_id = null) {
		if (empty($profile_id) && isset($this->profile_id)) {
		    $profile_id = $this->profile_id;
		}

		$query = "
			SELECT p.profile_id, p.profile_name, p.profile_summary, p.profile_nic,
			p.profile_text1, p.profile_text2, p.profile_text3, p.profile_text4,
			p.profile_text5, p.profile_text6, p.profile_text7, p.profile_text8,
			p.profile_text9, p.profile_text10,
			p.file_id, p.profile_hometown, p.user_id, u.language_id, 
			p.profile_create_datetime, p.profile_default,
			u.active_time, p.profile_gender, p.profile_allow_msg
			FROM " . $this->db->prefix . "_user_profile p, " . $this->db->prefix . "_user u
			WHERE
			p.user_id=u.user_id AND "
		;

		if (isset($profile_id)) {
		    $query .= "p.profile_id=" . $this->db->qstr($profile_id,get_magic_quotes_gpc()) . " AND ";
		}

		if (empty($profile_id)) {
		    $query .= "
				p.profile_default=1 AND
				p.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND "
			;
		}

		$query .= "1=1";
		//echo $query;
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = $result->fields;

			$temp['display_profile_create_datetime'] = $this->date->formatDate($temp['profile_create_datetime'], 1);

			//if the user is me we set to "online", else we find the status
			if (isset($_SESSION['s_user_id']) && $_SESSION['s_user_id'] == $temp['user_id']) {
			    $temp['online_status'] = 1;
			}
			else {
				$temp['online_status'] = $this->getStatus($temp['active_time']);
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getProfile class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getProfile



	// getTemplates --------------------------------------------------------------------
	// gets the available templates
	// tom calthrop - 17th April 2004
	//
	function getTemplates() {
		$query = "
			SELECT t.template_id, t.template_title
			FROM " . $this->db->prefix . "_template t
			order by t.template_title"
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTemplates class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTemplates



	// getTemplate --------------------------------------------------------------------
	// gets the available templates
	// tom calthrop - 17th April 2004
	//
	function getTemplate($template_id) {
		$query = "
			SELECT t.template_title
			FROM " . $this->db->prefix . "_template t
			WHERE
			t.template_id =" . $this->db->qstr($template_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTemplate class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTemplate



	// deleteLanguages --------------------------------------------------------------------
	// deletes languages that a user can read
	// tom calthrop - 18th Nov 2004
	//
	function deleteLanguages() {

		$query = "
			DELETE FROM " . $this->db->prefix . "_user_language
			WHERE
			user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (isset($result)) {
			return true;
		}
		else {
			$GLOBALS['am_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
		}
	}//EO deleteLanguages



	// getProfiles --------------------------------------------------------------------
	// gets the available profile
	// tom calthrop - 17th April 2004
	//
	function getProfiles() {
		$query = "
			SELECT p.profile_id, p.profile_name, p.profile_nic, p.profile_default,
			p.file_id, p.profile_create_datetime, p.profile_hometown, p.user_id,
			p.profile_allow_msg, u.active_time
			FROM " . $this->db->prefix . "_user_profile p, " . $this->db->prefix . "_user u
			WHERE
			p.user_id=u.user_id AND "
		;

		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $this->db->qstr($i,get_magic_quotes_gpc());
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="p.user_id in (" . $user_ids . ") AND
			p.profile_default=1 AND ";
		}
		else {
			$query .= "p.user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}

		$query .= "1=1 ";

		if (isset($this->orderby)) {
		    $query .= "order by " . $this->orderby;
		}
		else {
			$query .= "order by p.profile_name";
		}
		//echo $query;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if (isset($this->file)) {

					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}

				$temp1['profile_create_datetime'] = $this->date->formatDate($temp1['profile_create_datetime'], 1);

				//if the user is me we set to "online", else we find the status
				if (isset($_SESSION['s_user_id']) && $_SESSION['s_user_id'] == $temp1['user_id']) {
				    $temp1['online_status'] = 1;
				}
				else {
					$temp1['online_status'] = $this->getStatus($temp1['active_time']);
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getProfiles class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getProfiles



	// updateUser --------------------------------------------------------------------
	// update non administration columns in user
	// tom calthrop - 19th December 2004
	//
	function updateUser($data) {
		if(empty($data['user_hometown'])) {
		$GLOBALS['am_error_log'][] = array(10, null, null);
		}

		if (empty($data['language_ids'])) {
			$GLOBALS['am_error_log'][] = array(28, null, null);
		}

		if(empty($data['user_firstname'])) {
			$GLOBALS['am_error_log'][] = array(5, null, null);
		}

		if(empty($data['user_homepage'])) {
			$GLOBALS['am_error_log'][] = array(33, null, null);
		}

		// Check the password
		if(!empty($data['user_password1']) || !empty($data['user_password2'])) {

			if(empty($data['user_password1']) != empty($data['user_password2'])) {
				$GLOBALS['am_error_log'][] = array(15, null, null);
			}

			if(strlen($data['user_password1']) < 5) {
				$GLOBALS['am_error_log'][] = array(16, null, null);
			}
		}

		if (empty($GLOBALS['am_error_log'])) {

			$data['user_dob'] = $this->db->DBDate($data['user_dob']);
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_user 
				WHERE 
				user_id=" . $this->user_id
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['user_firstname'] = $data['user_firstname'];
			$rec['user_surname'] = $data['user_surname'];
			$rec['language_id'] = $data['language_id'];
			$rec['template_id'] = $data['template_id'];
			$rec['user_hometown'] = $data['user_hometown'];
			$rec['user_dob'] = $data['user_dob'];
			$rec['user_homepage'] = $data['user_homepage'];
			$rec['user_gender'] = $data['user_gender'];
			
			if (!empty($data['user_password1'])) {
				$tmp = md5($data['user_password1']);
				$feed_password = $this->createFeedPassword($tmp);
				$rec['user_password'] = $tmp;
				$rec['user_feed_password'] = $feed_password;
			}
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$_SESSION['s_language_id'] = $data['language_id'];
			
		}
	} //EO updateUser;



	// insertLanguages --------------------------------------------------------------------
	// inserts languages that a user can read
	// tom calthrop - 18th Nov 2004
	//
	function insertLanguages($in_arr) {
		$rownums = count ($in_arr);

		for ($i=0; $i < $rownums; $i++) {
			
			$rec = array();
			$rec['user_id'] = $this->user_id;
			$rec['language_id'] = $in_arr[$i];
			
			$table = $this->db->prefix . "_user_language";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=insertLanguages class=UserAdmin.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}

	}//EO insertLanguages



	// createPassword --------------------------------------------------------------------
	// creates a password
	// tom calthrop - 19th April 2004
	//
	function createPassword(){

		// creates a password
		$totallength = 8;
		$salt = "abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
		srand((double)microtime()*1000000);
		$password = "";
		for ($i = 0; $i < $totallength; $i++) {
			$password .= substr ($salt, rand() % strlen($salt), 1);
		}

		return $password;
	}//EO createPassword



	// insertProfile --------------------------------------------------------------------
	// inserts a profile
	// tom calthrop - 27th December 2004
	//
	function insertProfile($data) {
		if (empty($data['profile_name'])) {
			$GLOBALS['am_error_log'][] = array(45, null, null);
		}
		
		if (empty($data['profile_nic'])) {
			$GLOBALS['am_error_log'][] = array(7, null, null);
		}

		if (empty($data['profile_hometown'])) {
			$GLOBALS['am_error_log'][] = array(10, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['profile_default'])) {
			    $data['profile_default'] = "null";
			}

			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}

			if (!empty($data['profile_allow_msg'])) {
			    $data['profile_allow_msg'] = 1;
			}
			else {
			    $data['profile_allow_msg'] = "null";
			}

			if (empty($data['profile_gender']) || (isset($data['profile_gender']) && $data['profile_gender']<=0)) {
			    $data['profile_gender'] = "null";
			}

			if (empty($data['profile_text1'])) {
			    $data['profile_text1'] = "null";
			}

			if (empty($data['profile_text2'])) {
			    $data['profile_text2'] = "null";
			}

			if (empty($data['profile_text3'])) {
			    $data['profile_text3'] = "null";
			}

			if (empty($data['profile_text4'])) {
			    $data['profile_text4'] = "null";
			}

			if (empty($data['profile_text5'])) {
			    $data['profile_text5'] = "null";
			}

			if (empty($data['profile_text6'])) {
			    $data['profile_text6'] = "null";
			}

			if (empty($data['profile_text7'])) {
			    $data['profile_text7'] = "null";
			}

			if (empty($data['profile_text8'])) {
			    $data['profile_text8'] = "null";
			}

			if (empty($data['profile_text9'])) {
			    $data['profile_text9'] = "null";
			}

			if (empty($data['profile_text10'])) {
			    $data['profile_text10'] = "null";
			}
			
			$rec = array();
			$rec['user_id'] = $this->user_id;
			$rec['profile_default'] = $data['profile_default'];
			$rec['profile_name'] = $data['profile_name'];
			$rec['profile_summary'] = $data['profile_summary'];
			$rec['profile_nic'] = $data['profile_nic'];
			$rec['profile_create_datetime'] = time();
			$rec['profile_text1'] = $data['profile_text1'];
			$rec['profile_text2'] = $data['profile_text2'];
			$rec['profile_text3'] = $data['profile_text3'];
			$rec['profile_text4'] = $data['profile_text4'];
			$rec['profile_text5'] = $data['profile_text5'];
			$rec['profile_text6'] = $data['profile_text6'];
			$rec['profile_text7'] = $data['profile_text7'];
			$rec['profile_text8'] = $data['profile_text8'];
			$rec['profile_text9'] = $data['profile_text9'];
			$rec['profile_text10'] = $data['profile_text10'];
			$rec['profile_hometown'] = $data['profile_hometown'];
			$rec['profile_gender'] = $data['profile_gender'];
			$rec['profile_allow_msg'] = $data['profile_allow_msg'];
			$rec['file_id'] = $data['file_id'];
			
			$table = $this->db->prefix . "_user_profile";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				
				$this->profile_id = $this->db->Insert_ID();
				
			}
			else {
				$error_info = "function=insertProfile class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO insertProfile



	// updateProfile --------------------------------------------------------------------
	// upates a profile
	// tom calthrop - 27th December 2004
	//
	function updateProfile($data) {
		if (empty($data['profile_name'])) {
			$GLOBALS['am_error_log'][] = array(45, null, null);
		}
		
		if (empty($data['profile_nic'])) {
			$GLOBALS['am_error_log'][] = array(7, null, null);
		}

		if (empty($data['profile_hometown'])) {
			$GLOBALS['am_error_log'][] = array(10, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			
			if (empty($data['file_id'])) {
			    $data['file_id'] = "null";
			}

			if (empty($data['profile_gender']) || (isset($data['profile_gender']) && $data['profile_gender']<=0)) {
			    $data['profile_gender'] = "null";
			}

			if (empty($data['profile_allow_msg'])) {
			    $data['profile_allow_msg'] = "null";
			}

			if (empty($data['profile_text1'])) {
			    $data['profile_text1'] = "null";
			}

			if (empty($data['profile_text2'])) {
			    $data['profile_text2'] = "null";
			}

			if (empty($data['profile_text3'])) {
			    $data['profile_text3'] = "null";
			}

			if (empty($data['profile_text4'])) {
			    $data['profile_text4'] = "null";
			}

			if (empty($data['profile_text5'])) {
			    $data['profile_text5'] = "null";
			}

			if (empty($data['profile_text6'])) {
			    $data['profile_text6'] = null;
			}

			if (empty($data['profile_text7'])) {
			    $data['profile_text7'] = "null";
			}

			if (empty($data['profile_text8'])) {
			    $data['profile_text8'] = "null";
			}

			if (empty($data['profile_text9'])) {
			    $data['profile_text9'] = "null";
			}

			if (empty($data['profile_text10'])) {
			    $data['profile_text10'] = "null";
			}
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_user_profile 
				WHERE 
				profile_id=" . $this->db->qstr($this->profile_id,get_magic_quotes_gpc()) . " AND 
				user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc())
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['profile_name'] = $data['profile_name'];
			$rec['profile_summary'] = $data['profile_summary'];
			$rec['profile_nic'] = $data['profile_nic'];
			$rec['profile_text1'] = $data['profile_text1'];
			$rec['profile_text2'] = $data['profile_text2'];
			$rec['profile_text3'] = $data['profile_text3'];
			$rec['profile_text4'] = $data['profile_text4'];
			$rec['profile_text5'] = $data['profile_text5'];
			$rec['profile_text6'] = $data['profile_text6'];
			$rec['profile_text7'] = $data['profile_text7'];
			$rec['profile_text8'] = $data['profile_text8'];
			$rec['profile_text9'] = $data['profile_text9'];
			$rec['profile_text10'] = $data['profile_text10'];
			$rec['profile_hometown'] = $data['profile_hometown'];
			$rec['profile_gender'] = $data['profile_gender'];
			$rec['profile_allow_msg'] = $data['profile_allow_msg'];
			$rec['file_id'] = $data['file_id'];
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
		}
	}//EO updateProfile



	// deleteProfile --------------------------------------------------------------------
	// deletes a profile
	// tom calthrop - 27th December 2004
	//
	function deleteProfile($profile_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_user_profile
			WHERE
			profile_id=" . $this->db->qstr($profile_id,get_magic_quotes_gpc())
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteProfile class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteProfile



	// updateDefaultProfile --------------------------------------------------------------------
	// updates the DB with the default profile ID
	// tom calthrop - 22nd December 2004
	//
	function updateDefaultProfile($default_profile_id) {
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user_profile 
			WHERE 
			user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['profile_default'] = "null";
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_user_profile 
			WHERE 
			profile_id=" . $this->db->qstr($default_profile_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['profile_default'] = 1;

		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	}//EO updateDefaultProfile



	// getDegreeProfiles --------------------------------------------------------------------
	// gets the available profile
	// tom calthrop - 17th April 2004
	//
	function getDegreeProfiles($degree_id=null) {
		$query = "
			SELECT profile_id, degree_id
			FROM " . $this->db->prefix . "_sn
			WHERE
			user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND "
		;

		if (isset($degree_id)) {
		    $query .= "degree_id=" . $this->db->qstr($degree_id,get_magic_quotes_gpc()) . " AND ";
		}

		$query .= "1=1";

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getDegreeProfiles class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getDegreeProfiles



	// updateDegreeProfiles --------------------------------------------------------------------
	// update profile degree
	// tom calthrop - 8th January 2005
	//
	function updateDegreeProfiles($data) {

		if (!empty($data)) {
			foreach($data as $key => $i):
				
				$query = "
					SELECT * FROM " . $this->db->prefix . "_sn 
					WHERE 
					degree_id=" . $this->db->qstr($key,get_magic_quotes_gpc()) . " and
					user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc())
				;
				
				$result = $this->db->Execute($query);
				
				$rec = array();
				$rec['profile_id'] = $i;
				
				$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
			endforeach;
		}
	} //EO updateDegreeProfiles



	// createFeedPassword --------------------------------------------------------------------
	// takes MD5'ed password and pulls out somm charactures to create a feed password for RSS
	// tom calthrop - 20th December 2004
	//
	function createFeedPassword($password) {

		$password = substr($password, 0, 9);

		//get 3 random numbers
		$random1 = rand(0, strlen($password));
		$random2 = rand(0, strlen($password));
		$random3 = rand(0, strlen($password));
		//get 3 charactures from password
		$passchar1 = substr($password, $random1, 1);
		$passchar2 = substr($password, $random2, 1);
		$passchar3 = substr($password, $random3, 1);


		$feed_pass = $random1 . $random2 . $random3 . $passchar1 . $passchar2 . $passchar3;

		return $feed_pass;
	}//EO createFeedPassword

	
	
	// selUserPreferences --------------------------------------------------
	// returns a user preference
	// tom calthrop - 27th August 2005
	//
	function selUserPreferences() {
		
		$query = "
			SELECT user_id, user_preference_id 
			FROM " . $this->db->prefix . "_user_preference "
		;
		
		$query .= "WHERE ";
		
		if (isset($this->user_id)) {
		    $query .= "user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			return $temp;
			
		}
		else {
			$error_info = "function=selUserPreferences class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selUserPreferences
	
	
	
	// selUserPreference --------------------------------------------------
	// returns a user preference
	// tom calthrop - 27th August 2005
	//
	function selUserPreference($user_id, $user_preference_id) {
		
		$query = "
			SELECT user_preference_id 
			FROM " . $this->db->prefix . "_user_preference 
			WHERE 
			user_id=" . $this->db->qstr($user_id,get_magic_quotes_gpc()) . " AND 
			user_preference_id=" . $this->db->qstr($user_preference_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows
		
		if (isset($result->fields['user_preference_id'])) {
			return true;
		}
		else {
			return false;
		}
	}//EO selUserPreference
	
	
	
	// insertUserPreference --------------------------------------------------------------------
	// inserts a users preference
	// tom calthrop - 27th August 2005
	//
	function insertUserPreference($user_preference_id, $user_id = null) {
		
		if (!isset($user_id)) {
			$user_id = $this->user_id;
		}
		
		$rec = array();
		$rec['user_id'] = $user_id;
		$rec['user_preference_id'] = $user_preference_id;
		$table = $this->db->prefix . "_user_preference";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=insertUserPreference class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertUserPreference
	
	
	// deletetUserPreference --------------------------------------------------------------------
	// deletes a users preference
	// tom calthrop - 27th August 2005
	//
	function deletetUserPreference($user_preference_id) {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_user_preference 
			WHERE
			user_id=" . $this->db->qstr($this->user_id,get_magic_quotes_gpc()) . " AND 
			user_preference_id=" . $this->db->qstr($user_preference_id,get_magic_quotes_gpc())
		;
		
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=deletetUserPreference class=User.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO deletetUserPreference
}
