<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

if (!empty($_REQUEST['group_id'])) { // page under group section
	include "inc/header_group.inc.php";
	require_once($languagePath . 'g_common.lang.php');
}
else {
	include "inc/header_my.inc.php";
	require_once($languagePath . 'my_common.lang.php');
}


if (isset($_REQUEST['file_id'])) {
	$file_id = $_REQUEST['file_id'];
}

//setup file class
$file->user_id = $me['user_id'];


if (isset($_POST['insert_file']) && $_FILES['upload_file']['size'] > 0) {
	
	if ($frmdata['max_allocation'] < $_FILES['upload_file']['size']) {
	    $GLOBALS['am_error_log'][] = array(42, null, null);
	}
	else {
		$file_upload = $_FILES['upload_file'];
		
		if (!empty($c_node['file']['mime']['browser_path'])) {
		    foreach($c_node['file']['mime']['browser_path'] as $i):
				if ($i['from'] == $file_upload['type']) {
				    $file_upload['type'] = $i['to'];
				}
			endforeach;
		}
		
		$file_upload['file_title'] = $frmdata['file_title'];
		$file->arr_file_upload = $file_upload;
		if ($file->checkFile()) {
			$file->insertFileRecord();
			$file->moveFile();
		}
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		if (!empty($_REQUEST['group_id'])) { // page under group section
			return header("Location: fil_edit.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
		}
		else {
			return header("Location: fil_edit.php" . SID);
		}
		exit;
	}
}
elseif (isset($_POST['delete_file'])) {
	$file->file_id = $frmdata['file_id'];
	$delete_file = $file->getFileRecord();
	
	if ( (isset($group_id) && isset($delete_file['group_id']) && $group_id == $delete_file['group_id']) || 
	     (!isset($group_id) && isset($delete_file['user_id']) && $me['user_id'] == $delete_file['user_id'])
	     ) {
	    $file->deleteFile($delete_file['file_name'], $delete_file['file_suffix']);
	    $file->deleteFileRecord($frmdata['file_id']);
	}

	if (empty($GLOBALS['am_error_log'])) {
	
		if (!empty($_REQUEST['group_id'])) { // page under group section
			return header("Location: fil_edit.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
		}
		else {
			return header("Location: fil_edit.php" . SID);
		}
		exit;
	}
}
elseif (isset($_POST['update_file'])) {
	$file->file_id = $frmdata['file_id'];
	$file_records = $file->getFileRecord();
	if( (isset($group_id) && isset($file_records['group_id']) && $group_id == $file_records['group_id']) ||
	    (!isset($group_id) && isset($file_records['user_id']) && $me['user_id'] == $file_records['user_id'])
	    ) {
	  $file_editable_flag = true;
	}

	if ($file_editable_flag &&  isset($_FILES['upload_file']) && $_FILES['upload_file']['size'] > 0) {
	    $file_upload = $_FILES['upload_file'];
		
		$new_suffix = $file->getSuffix($file_upload['type']);
		
		if ($new_suffix == $frmdata['file_suffix']) {
			
			$file_upload['file_title'] = $frmdata['file_title'];
			$file_upload['file_suffix'] = $frmdata['file_suffix'];
			$file_upload['file_name'] = $frmdata['file_name'];
			$file->file_id = $frmdata['file_id'];
			$file->arr_file_upload = $file_upload;
			
			if ($file->checkFile()) {
				$file->deleteFile($frmdata['file_name'], $frmdata['file_suffix']);
				$file->updateFileRecord();
				$file->moveFile();
			}
		}
		else { // the file types have to be the same
			
			$GLOBALS['am_error_log'][] = array(46, null, null);
		}
	}
	elseif($file_editable_flag) { //just update database with new title
		$file_upload['file_title'] = $frmdata['file_title'];
		$file->file_id = $frmdata['file_id'];
		$file->arr_file_upload = $file_upload;
		$file->updateFileRecord();
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		if (!empty($_REQUEST['group_id'])) { // page under group section
			return header("Location: fil_edit.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
		}
		else {
			return header("Location: fil_edit.php" . SID);
		}
		exit;
	}
}
elseif (isset($_POST['set_default']) && isset($_POST['default_file_id'])) {
	$file->default_file_id = $_POST['default_file_id'];
	$file->updateDefaultFile();
	
		if (!empty($_REQUEST['group_id'])) { // page under group section
			return header("Location: fil_edit.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
		}
		else {
			return header("Location: fil_edit.php" . SID);
		}
		exit;
}


if (isset($file_id)) {
	$file->file_id = $file_id;
	$output_file = $file->getFileRecord();
	$display = "edit";
}
elseif (isset($_REQUEST['add_image'])) {
	$display = "add";
}


$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
$file->orderby = "file_title";

if (!empty($group_id)) {
	unset($file->user_id);
}

$output_files = $file->getFiles();

//storage
$output_storage = $file->getAllocation();

if (isset($output_storage['allocation'])) {
	$percentage_used = floor((100/$output_storage['allocation']) * $output_storage['allocation_used']);
	if ($percentage_used > 100) {
	    $percentage_used = 100;
	}
	$percentage_unused = 100 - $percentage_used;
}

			
			
//move to template
if ($output_storage['allocation'] > $output_storage['allocation_used']) {
	$body->set('allow_file_add', 1);		
}
			
if (!empty($output_group)) {
    $body->set('group', $output_group);
}

if (!empty($output_files)) {
    $body->set('files', $output_files);
}

if (!empty($output_file)) {
    $body->set('out_file', $output_file);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (!empty($output_storage)) {
    $body->set('storage', $output_storage);
}

if (!empty($percentage_used)) {
    $body->set('percentage_used', $percentage_used);
}

if (!empty($percentage_unused)) {
    $body->set('percentage_unused', $percentage_unused);
}



include "inc/footer.inc.php";

?>
