<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_frm.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
	
	//ACS check2
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_hidden'])) { //resourece_id, Priv_id
		$forum->include_hidden = 1;
	}
} else {
	header("Location: g_groups.php&" . SID);
}

//SETUP RSP ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['forum']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	if (isset($frmdata['save_subject']) || isset($frmdata['save_go_subject'])) {
		if (empty($frmdata['subject_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			$forum->user_id = $me['user_id'];
			//check permissions
			if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id 
				$editable = true;
			} else {
				$editable = false;
			}

			if (isset($frmdata['subject_id']) && $frmdata['subject_id'] > 0) {
			  //check topic role permission (relattion subject_id)
			  if(!$editable) {
				$forum->subject_id = $frmdata['subject_id'];
				$current_subject = $forum->getSubject();
				$forum->topic_id = $current_subject['topic_id'];
				$current_topic_roles = $forum->selTopicRoles();
				$editable = false;
				if(is_array($current_topic_roles) && sizeof($current_topic_roles) > 0) {
				  foreach($current_topic_roles as $key => $val) {
				    if($val['role_id'] == $group_acs->role_id) {
				      $editable = true;
				      break;
				    }
				  }
				}
				//check topic role permission (posted topic_id)
				if($editable) {
				  $forum->topic_id = $frmdata['topic_id'];
				  $posted_topic_roles = $forum->selTopicRoles();
				  $editable = false;
				  if(is_array($posted_topic_roles) && sizeof($posted_topic_roles) > 0) {
				    foreach($posted_topic_roles as $key2 => $val2) {
				      if($val2['role_id'] == $group_acs->role_id) {
					$editable = true;
					break;
				      }
				    }
				  }
				}
			  }
				if($editable) {
					$update_result = $forum->updateSubject($frmdata);
					if($update_result === -1) {
						header("Location: frm_list.php?group_id=" . $group_id . '&' . SID);
						exit;
					}
				}
			}
		 	else { //we insert record
				$forum->topic_id = $frmdata['topic_id'];
				if(!$editable) {
				  $posted_topic_roles = $forum->selTopicRoles();
				  $editable = false;
				  if(is_array($posted_topic_roles) && sizeof($posted_topic_roles) > 0) {
				    foreach($posted_topic_roles as $key2 => $val2) {
				      if($val2['role_id'] == $group_acs->role_id) {
					$editable = true;
					break;
				      }
				    }
				  }
				}
				if($editable) {
					$forum->user_id = $me['user_id'];
					$forum->insertSubject($frmdata);
				} else {
					header("Location: frm_list.php?group_id=" . $group_id . '&' . SID);
					exit;
				}
		 	}
			
			if (empty($GLOBALS['am_error_log'])) {
				//insert into setup rsp
				if (!empty($frmdata['group_id'])) {
				    $temp['language_id'] = $output_group['language_id'];
				}
				else {
					$temp['language_id'] = $me['language_id'];
				}
				
				$temp['item_id'] = $forum->subject_id;
				//delete all
				$rsp->deleteRspItem($forum->subject_id);
				
				if (isset($frmdata['rsp_degree']) && $frmdata['rsp_degree'] == "all") {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['degree'];
					$temp['degree_id'] = "null";
					$rsp->insertRspItem($temp);
				}
					
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					$rsp->insertRspItem($temp);
				}
						
				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					$rsp->status_id = $c_node['rsp']['status']['pending'];
					$rsp->insertRspItem($temp);
				}
				
				//setup statistics
				require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
				$statistic = new Statistic($db, $c_acs['arr_section']['group'], $date);
				
				//update stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->section_item_id = $frmdata['group_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group']['total_forum_subjects'];
				}
				else {
					$forum->user_id = $user_id;
					$statistic->section_id = $c_acs['arr_section']['user'];
					$statistic->user_id = $me['user_id'];
					$statistic->section_item_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['user']['total_forum_subjects'];
				}
				
				$statistic->setStatistic($forum->getSubjectCount());
				
				//get member subject stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_forum_subjects'];
					$statistic->setStatistic($forum->getSubjectCount($me['user_id']));
				}
				
						
						
				if (isset($frmdata['save_go_subject'])) {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: frm_item.php?group_id=" . $frmdata['group_id'] . "&subject_id=" . $forum->subject_id . "&".SID);
						exit;
					}
					else {
						header("Location: frm_item.php?subject_id=" . $forum->subject_id . "&".SID);
						exit;
					}
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: frm_edit.php?group_id=" . $frmdata['group_id'] . "&subject_id=" . $forum->subject_id . "&".SID);
						exit;
					}
					else {
						header("Location: frm_edit.php?subject_id=" . $forum->subject_id . "&".SID);
						exit;
					}
				}
			}
			else { // somehing errored
				$output_subject = $frmdata;
			}
			
			$display = "edit_subject";
		}
	}
	elseif (isset($frmdata['save_topic']) || isset($frmdata['save_go_topic'])) {
		
		if (empty($frmdata['topic_title'])) {
		    $GLOBALS['am_error_log'][] = array(11, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			//
			if (isset($frmdata['topic_id']) && $frmdata['topic_id'] > 0) {
		         //we update the event
		 		$update_result = $forum->updateTopic($frmdata);
				if($update_result === -1) {
					header("Location: frm_list.php?group_id=" . $group_id . '&' . SID);
					exit;
				}
			}
		 	else { //we insert record
		 		$forum->user_id = $me['user_id'];
		 		$forum->insertTopic($frmdata);
		 	}
			
			if (empty($GLOBALS['am_error_log'])) {
				
				if (empty($frmdata['role_ids'])) {
					$frmdata['role_ids'] = array();
				}
				
				$forum->insertTopicRoles($frmdata['role_ids']);
				
				if (isset($frmdata['save_go_topic'])) {
					if (!empty($frmdata['group_id'])) { // page under group section
					    header("Location: frm_list.php?group_id=" . $frmdata['group_id'] . "&topic_id=" . $forum->topic_id . "&".SID);
						exit;
					}
					else {
						header("Location: frm_list.php?topic_id=" . $forum->topic_id . "&".SID);
						exit;
					}
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: frm_edit.php?group_id=" . $frmdata['group_id'] . "&topic_id=" . $forum->topic_id . "&".SID);
						exit;
					}
					else {
						header("Location: frm_edit.php?topic_id=" . $forum->topic_id . "&".SID);
						exit;
					}
				}
			}
			else { // somehing errored
				$output_topic = $frmdata;
			}
			
			$display = "edit_topic";
		}
	}
	elseif (isset($frmdata['delete_topic']) && isset($frmdata['topic_id'])) {
		//we can only delete a topic if no subjects are under it
		$forum->deleteTopic($frmdata['topic_id']);
	
	$display = "edit_topic";
	}
}
elseif (isset($_REQUEST['add_subject'])) {
	
	if (isset($_REQUEST['topic_id'])) {//we edit topic
		$output_subject['topic_id'] = $_REQUEST['topic_id'];
	}
	
	$display = "edit_subject";
}
elseif (isset($_REQUEST['topic_id'])) {//we edit topic
	$output_topic = $forum->getTopic();
	
	if (!empty($output_topic)) {
	    $output_topic['total_subjects'] = $forum->getSubjectCount();
	}
	
	$output_roles = $group_acs->getGroupRoles();
	$output_topic_roles = $forum->SelTopicRoles();	
	
	//$group_acs->role_id
	$display = "edit_topic";
}
elseif (isset($_REQUEST['add_topic'])) {//we add topic
	
	$output_roles = $group_acs->getGroupRoles();
	
	$display = "edit_topic";
}
elseif (isset($_REQUEST['subject_id'])) {
	$output_subject = $forum->getSubject();
	
	$display = "edit_subject";
}





if (!empty($group_id)) { // page under group section
	$file->group_id = $group_id;
}
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


// if we have edit permissions we list all topics, else we check for 
// the topics I can add to
if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	$output_topics = $forum->getTopics();
}
else {
	$output_topic_roles = $forum->SelTopicRoles($group_acs->role_id);
	
	if (!empty($output_topic_roles)) {
		$output_topic_role_ids = array();
		foreach($output_topic_roles as $key => $i):
			array_push($output_topic_role_ids, $i['topic_id']);
		endforeach;
		
		$forum->topic_ids = $output_topic_role_ids;
		$output_topics = $forum->getTopics();
	}
	else {
		if (!empty($group_id)) { // page under group section
			header("Location: frm_list.php?group_id=" . $group_id . "&".SID);
			exit;
		}
		else {
			header("Location: frm_list.php?".SID);
			exit;
		}
	}
}


//RSP items
if (!empty($forum->subject_id)) {
	$output_subject['rsp'] = $rsp->selRspItem($forum->subject_id);
}
elseif (!empty($frmdata)) { // just in case we preview before saving
	if (isset($frmdata['rsp_node']) && $frmdata['rsp_node']==1) {
	    $body->set('rsp_node', 1);
	}
	
	if (isset($frmdata['rsp_group']) && $frmdata['rsp_group']==1) {
	    $body->set('rsp_group_home', 1);
	}
	
	if (isset($frmdata['rsp_degree']) && $frmdata['rsp_degree']==1) {
	    $body->set('rsp_degree_set', 1);
	}
	
}

//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_topic)) {
	$body->set('topic', $output_topic);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_roles)) {
    $body->set('roles', $output_roles);
}

if (!empty($output_topic_roles)) {
    $body->set('topic_roles', $output_topic_roles);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
