<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------
// Tom Calthrop - 20th November 2004 (tom@barnraiser.org)




// ROLES ------------------------------------------------------------
/*
* a job function or assigned role or a level of membership
* user roles are fixed
* group roles are used as defaults when setting up a group
* once set up group roles are stored in the database
* refer to the acs_config file to see how roles are attached to sections
*/
$lang['arr_acs']['role'][101] = 					"管理者";		//user
$lang['arr_acs']['role'][102] = 					"メンバー";			//user

$lang['arr_acs']['role'][201] = 					"管理者";		//group
$lang['arr_acs']['role'][202] = 					"モデレーター";			//group
$lang['arr_acs']['role'][203] = 					"議長";			//group
$lang['arr_acs']['role'][204] = 					"議員";			//group
$lang['arr_acs']['role'][205] = 					"一般メンバー";			//group


// SECTIONS ------------------------------------------------------------
$lang['arr_acs']['section'][1] = 					"ユーザー";
$lang['arr_acs']['section'][2] = 					"グループ";



// RESOURCES ------------------------------------------------------------
$lang['arr_acs']['resource'][101] = 				"管理"; 			//user
$lang['arr_acs']['resource'][102] = 				"メンバーシップ";				//user
$lang['arr_acs']['resource'][103] = 				"ソーシャルネットワーク";			//user
$lang['arr_acs']['resource'][104] = 				"アクセス権限設定";					//user
$lang['arr_acs']['resource'][105] = 				"シャウトボックス";				//user
$lang['arr_acs']['resource'][106] = 				"公開設定";				//user
$lang['arr_acs']['resource'][107] = 				"グループ";				//user
$lang['arr_acs']['resource'][108] = 				"投票";					//user
$lang['arr_acs']['resource'][109] = 				"フォーラム";				//user
$lang['arr_acs']['resource'][110] = 				"ニュースレター";				//user

$lang['arr_acs']['resource'][201] = 				"管理";			//group
$lang['arr_acs']['resource'][202] = 				"アクセス権限設定";					//group
$lang['arr_acs']['resource'][203] = 				"会員情報";				//group
$lang['arr_acs']['resource'][204] = 				"Wiki";					//group
$lang['arr_acs']['resource'][205] = 				"フォーラム";				//group
$lang['arr_acs']['resource'][206] = 				"ファイル";				//group
$lang['arr_acs']['resource'][207] = 				"イベントとタスク";				//group
$lang['arr_acs']['resource'][208] = 				"RSP";				//group
$lang['arr_acs']['resource'][209] = 				"投票";				//group
$lang['arr_acs']['resource'][210] = 				"ブログ";					//group
$lang['arr_acs']['resource'][211] = 				"ニュースレター";				//group
$lang['arr_acs']['resource'][212] = 				"channels";			//group


//resource descriptions
$lang['arr_acs']['resource_desc'][101] = 			"ノード管理の権限";
$lang['arr_acs']['resource_desc'][102] = 			"メンバーの権限";
$lang['arr_acs']['resource_desc'][103] = 			"ネットワークの権限"; //social networking permissions";
$lang['arr_acs']['resource_desc'][104] = 			"アクセス権限設定の権限";
$lang['arr_acs']['resource_desc'][105] = 			"シャウトボックスの権限";
$lang['arr_acs']['resource_desc'][106] = 			"コンテンツマネジメントシステム（スプラッシュマガジン）";
$lang['arr_acs']['resource_desc'][107] = 			"グループの権限";
$lang['arr_acs']['resource_desc'][108] = 			"コミュニティ内の投票権限"; //Community wide poll permissions";
$lang['arr_acs']['resource_desc'][109] = 			"グループ内のフォーラムの権限"; //Community wide forum permissions";
$lang['arr_acs']['resource_desc'][110] = 			"グループ内のニュースレターの権限"; //Community wide newsletter permissions";

$lang['arr_acs']['resource_desc'][201] = 			"グループの管理権限（ルールと構造）"; //group administration permissions (rules and structure)";
$lang['arr_acs']['resource_desc'][202] = 			"アクセス管理設定の権限";
$lang['arr_acs']['resource_desc'][203] = 			"グループメンバー設定の権限";
$lang['arr_acs']['resource_desc'][204] = 			"Wikiの権限";
$lang['arr_acs']['resource_desc'][205] = 			"フォーラムの権限";
$lang['arr_acs']['resource_desc'][206] = 			"グループ共有ファイル（イメージファイル）の権限"; //group files (images) permissions";
$lang['arr_acs']['resource_desc'][207] = 			"イベントとタスクの権限";
$lang['arr_acs']['resource_desc'][208] = 			"公開設定の権限"; //content management system permissions (the level of publishing).";
$lang['arr_acs']['resource_desc'][209] = 			"投票の権限";
$lang['arr_acs']['resource_desc'][210] = 			"ブログの権限";
$lang['arr_acs']['resource_desc'][211] = 			"ニュースレターの権限"; //newsletter permissions";
$lang['arr_acs']['resource_desc'][212] = 			"channelの権限";

// PRIVILEGES ------------------------------------------------------------
$lang['arr_acs']['privilege'][1] = 				"アクセスを許可する";
$lang['arr_acs']['privilege'][2] = 				"アイテムを追加する";
$lang['arr_acs']['privilege'][3] = 				"編集を許可する";
$lang['arr_acs']['privilege'][4] = 				"招待を許可する";
$lang['arr_acs']['privilege'][5] = 				"一般に許可する";
$lang['arr_acs']['privilege'][6] = 				"非表示のアイテムを見る";
$lang['arr_acs']['privilege'][7] = 				"グループホームを許可する";
$lang['arr_acs']['privilege'][8] = 				"グループの編集";
$lang['arr_acs']['privilege'][9] = 				"ユーザーの編集";
$lang['arr_acs']['privilege'][10] = 				"コメントを許可する";
$lang['arr_acs']['privilege'][11] = 				"ノードを許可する";
$lang['arr_acs']['privilege'][12] = 				"制作を許可する";
$lang['arr_acs']['privilege'][13] = 				"追加を許可する";
$lang['arr_acs']['privilege'][14] = 				"送信を許可する";
$lang['arr_acs']['privilege'][15] = 			"allow locking";

?>
