<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_lib.inc.php";

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $output_group['group_id']."&".SID);
		exit;
	}
}


// PROCESS COMMENTS
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['library'], $date);


//get $library
unset($library->file);

if (isset($_REQUEST['contents'])) {
	$output_library_items = $library->getContents();

	$display = "contents";

}
elseif (isset($_REQUEST['history_library_id'])) {
	$output_library_items = $library->getHistory($_REQUEST['history_library_id']);

	$display = "history";
}
else { // items published by author
	if (!empty($group_id)) { // page under group section
		unset($library->user_id);
		$output_library_items = $library->selLibraryItems();
	}
	elseif ($menu_section == "my") {
	   	$output_library_items = $library->selLibraryItems();
	}
	else {
		$output_library_items = $library->selLibraryItems();
	}
}

if (!empty($output_library_items)) {
	foreach($output_library_items as $key => $i) {
		$output_library_history = $library->getHistory($i['library_id']);
		$temp_count = 0;
		foreach($output_library_history as $hist_key => $hist) {
			$temp_count += $comment->getCommentCount($hist['library_id']);
		}
		$output_library_items[$key]['comment_total'] = $temp_count;
	}
}




//move vars to template
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_profile)) {
	$body->set('profile', $output_profile);
}

if (!empty($output_library_items)) {
	$body->set('librarys', $output_library_items);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_statistic)) {
	$body->set('profile_statistic', $output_statistic);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

$template_pageLink = $lang['txt_library'];

include "inc/footer.inc.php";

?>