<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "config/config_aroundme.inc.php";
include "inc/functions.inc.php";

if (empty($_SESSION)) {
    session_start();
}


// SETUP TEMPLATE
$template_path = $c_node['dir']['template_path'];


if (isset($_SESSION['s_user_template'])) {
    $template_name = $_SESSION['s_user_template'];
}
else {
	$template_name = $c_node['node']['template_default_name'];
}

$template_path = $template_path . $template_name . "/";

require_once($c_node['dir']['class_path'] . 'Template.class.php');
$body = & new Template($template_path); // This is the inner template



// SETUP LANGUAGE -----------------------------------------------------------------------
$languagePath = "language/" . $_SESSION['s_language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "arrays/";
require_once($languagePath . 'man.lang.php');


//wiki
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');


if (!empty($_REQUEST['man_ids'])) {
	$man_ids = explode(',', $_REQUEST['man_ids']);
	
	//append language setup
	require_once($languageArrayPath . 'arr_man.lang.php');
	
	//we get the titles and the files and we wiki the files separately
	// (this ensures that separate toc's remain separate.
	$man = array();
	foreach ($man_ids as $key => $m):
		//get the file
		$temp = array();
		$langfile = $lang['man'][$m[0]][0] . ".man.php";
		$temp['man'] = readTxtFile($languagePath . 'man/' . $langfile);
		//$temp['man'] = stripslashes($temp['man']);
		$temp['man'] = $wiki->transform($temp['man'], 'Xhtml');
		$temp['title'] = $lang['man'][$m[0]][1];
		array_push($man, $temp);
	endforeach;



	$body->set('man', $man);
}

$body->set('templatePath', $template_path);
$body->set('lang', $lang);



echo $body->fetch("man.tpl.php");

?>
