<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
$menu_section = "message";

require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');


//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');


// Gettings list of friends
$sn = new Socialnetwork($me['user_id'], $db, $c_node['node']['node_id'], $c_node['sn']['max_degree']);
$sn->relation_type_ids = $c_node['user']['relation_type'];
$sn->status_ids = $c_node['user']['status'];
$sn->date = $date;

//trim multibyte characters
if(isset($data['message_subject'])) {
	$data['message_subject'] = mb_strimwidth($data['message_subject'],0,50);
}

// Handling the message choices
if (isset($_REQUEST['send_message'])) {
	$message_subject = stripslashes(htmlspecialchars($data['message_subject']));
	
	if ($user->selUserPreference($data['to_user_id'], $c_node['user']['preference']['email_message'])) {
		//we need to send a copy of the IM to the persons email
		
		//setup mail
		require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->language = 	$c_node['mail']['language'];
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		$mail->MimeHeader = 	$c_node['mail']['mime'];
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
				
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->AddReplyTo	($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$lang['subject_email_message'];
		$mail->CharSet =	$c_node['mail']['charset'];
		$mail->Encoding =	$c_node['mail']['encoding'];
		
		//get users information
		$output_to_user = $user->getUser($data['to_user_id']);
		
		//create mail content
		$body_mail_txt = readTxtFile($languageTextPath . "mail_email_message.txt.php");
		
		//create URL
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname ($_SERVER['PHP_SELF']);
		//sometimes the server adds / as the last characture - we need to check.
		if (substr($url, -1, 1) != "/") {
			$url .= "/";
		}
		$url .= "msg_list.php";
		
		$body_mail_txt = am_str_replace(array('NAME' => $output_to_user['user_firstname'],
											  'MESSAGE' => $message_subject .
											  					"\n\n" .
																$data['message_body'],
											  'URL' => $url),
										$body_mail_txt);

		$body_mail_txt = stripslashes($body_mail_txt);
		
		$mail->Body = $body_mail_txt;
		$mail->ClearAddresses();
		$mail->AddAddress($output_to_user['user_email'], '');
		
		if($mail->Send()) {
			// sent
		}
	}
	
	$im->sendMessage($data['to_user_id'], $message_subject, $data['message_body']);
	header("Location: msg_list.php?" . SID);
	exit;
}
elseif (isset($_REQUEST['reply'])) {

	$message = new Message($db, $_REQUEST['message_id']); // create message
	$message->user_id = $me['user_id'];
	$message->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
	$output_message = $message->getMessage();             // get message

	// Getting username
	$user->user_id = $output_message['from_user_id'];
	$to_user = $user->getProfile();
	$to_user_id = $output_message['from_user_id'];
	
	// Adding RE (langauge node?)
	$output_message["message_subject"] = "RE: ".$output_message["message_subject"];

	// Changing message_body
	$output_message["message_body"] = "\n\n----\n".$output_message["message_body"];

	// Checks if that user have blocked me....
	if ($sn->checkUserBlocked($to_user_id)) {
		$display = "compose_allowed";
	}
}
elseif (isset($_POST['preview_message'])) {
	$output_message["message_subject"] = stripslashes(htmlspecialchars($data["message_subject"]));
	$output_message["message_body"] = stripslashes($data["message_body"]);
	$output_message['message_body_display'] = $wiki->transform($output_message['message_body'], 'Xhtml');
	$to_user_id = $data['to_user_id'];
	$user->user_id = $data['to_user_id'];
	$to_user = $user->getProfile();

	$display = "preview_msg";

}
elseif (isset($_POST['edit_message_again'])) {
	$output_message["message_subject"] = stripslashes($data['message_subject']);
	$output_message["message_body"] = stripslashes($data["message_body"]);
	$to_user_id = $data['to_user_id'];
	$user->user_id = $data['to_user_id'];
	$to_user = $user->getProfile();

	$display = "compose_allowed";

}
elseif (isset($_REQUEST['to_user_id'])) {
	
	//check to see whether we are allowed to IM this person
	if ($sn->checkUserBlocked($_REQUEST['to_user_id'])) {
		$user->user_id = $_REQUEST['to_user_id'];
	    $to_user = $user->getProfile();
		$to_user_id = $_REQUEST['to_user_id'];
		$output_message['message_subject'] = "";
		$output_message['message_body'] = "";
		
		//does this person allow messaging to this profile?
		if (!empty($to_user['profile_allow_msg'])) {
			$display = "compose_allowed";
		}
	}

}
else {
	$output_message['message_subject'] = "";
	$output_message['message_body'] = "";
	
	$display = "compose_allowed";
}





$output_friend_ids = $sn->getFriends($me['user_id']);
if (!empty($output_friend_ids)) {
	foreach($output_friend_ids as $key => $i):
		$user->user_ids[] = $i;
	endforeach;

	unset ($user->file);
	$user->orderby = "p.profile_nic";
	$output_friends = $user->getProfiles();
	if (!empty($output_friends)) {
		foreach($output_friends as $key => $i):
			if (empty($i['profile_allow_msg'])) {
				unset($output_friends[$key]);
			}
		endforeach;
	}
}

if (!isset($to_user_id) && !isset($output_friends)) {
	unset($display);
}

//----------------------------------------------------------------------------
// Setting statistics
$im->setStatistics();

// Getting statistics
$output_message_statistics = $im->getStatistics();
//----------------------------------------------------------------------------

//display "no compose" screen if MB is over 100% full
$percentage_used = floor((100/$output_message_statistics['total_size_allowed']) * $output_message_statistics['total_size']);
if (isset($percentage_used) && $percentage_used >= 100) {
    $display = "size_allocation_exceeded";
}


//move to template
if (!empty($output_friends)) {
	$body->set('users', $output_friends);
}
if (!empty($output_message)) {
	$body->set('message', $output_message);
}

if (!empty($old_subject)) {
	$body->set('old_subject', $old_subject);
}
else {
	$body->set('old_subject', "");
}

if (!empty($old_message)) {
	$body->set('old_message', $old_message);
}
else {
	$body->set('old_message', "");
}

if (!empty($friends)) {
    $body->set('friends', $friends);// List of friends
}

if (!empty($to_user_id)) {
    $body->set('to_user_id', $to_user_id);// to_user_id
}

if (!empty($to_user)) {
    $body->set('to_user', $to_user);// Name of user to_user_id
}

if (isset($display)) {
    $body->set('display', $display);// Name of user to_user_id
}

$body->set('message_statistics', $output_message_statistics);			// Stats...
$body->set('message_status_read', $c_node['messaging']['message_status_read']);		// Status code: READ
$body->set('message_status_unread', $c_node['messaging']['message_status_unread']);	// Status code: UNREAD


$template_pageLink = "message";
include "inc/footer.inc.php";

?>
