<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


include "inc/header_pre_login.inc.php";


//set up user class and destroy any sessions
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);


//form actions
if (isset($_POST['newpassword'])) {
	// Checks the email and the password
	if ($_SESSION['CAPTCHAString'] != $_POST['captchastring']) {
		$GLOBALS['am_error_log'][] = array(36, null, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];

		$query = "
			SELECT u.user_id, u.user_firstname, u.user_email
			FROM " . $db->prefix . "_user u
			where
			u.user_email=" . $db->qstr($_POST['email'],get_magic_quotes_gpc()) . " and
			u.user_dob=" . $db->qstr($dob,get_magic_quotes_gpc())
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields['user_id'])) {
			$temp = $result->fields;
	
			//update the password and send email
			$password = $user->createPassword();
			$user->savePassword($password, $temp['user_email']);
	
			//get file to send
			$body_file = $languageTextPath . "send_new_password.txt.php";
	
			$handle = fopen($body_file, "rb");
			$body_file_txt = "";
			do {
			   $data = fread($handle, 8192);
			   if (strlen($data) == 0) {
			       break;
			   }
			   $body_file_txt .= $data;
			} while (true);
			fclose($handle);


			//create URL
			$url = "http://" . $_SERVER['HTTP_HOST'];
			$url .= dirname ($_SERVER['PHP_SELF']);
			//sometimes the server adds / as the last characture - we need to check.
			if (substr($url, -1, 1) != "/") {
			    $url .= "/";
			}

			$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
			$body_file_txt = am_str_replace(array('FIRSTNAME' => $temp['user_firstname'],
												  'PASSWORD' => $password,
												  'URL' => $url), $body_file_txt);


			//setup mail
			require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
			$mail = new PHPMailer();
			$mail->language =   $c_node['mail']['language'];
			$mail->Host = 		$c_node['mail']['host'];
			$mail->Mailer = 	$c_node['mail']['mailer'];
			$mail->MimeHeader = 	$c_node['mail']['mime'];
			if (isset($c_node['mail']['smtp']['username'])) {
				$mail->SMTPAuth = true;
				$mail->Username = $c_node['mail']['smtp']['username'];
				$mail->Password = $c_node['mail']['smtp']['password'];
			}
			
			$mail->From = 		$c_node['mail']['no_reply_address'];
			$mail->FromName = 	$c_node['mail']['from_name'];
			$mail->WordWrap = 	$c_node['mail']['wordwrap'];
			$mail->Subject = 	$lang['txt_email_subject_new_pass'];
			$mail->AddAddress($temp['user_email'], $temp['user_firstname']);
			$mail->Body = $body_file_txt;
			$mail->CharSet =    $c_node['mail']['charset'];
			$mail->Encoding =   $c_node['mail']['encoding'];

			if(!$mail->Send()) {
				$GLOBALS['am_error_log'][] = array(23, 1, $mail->ErrorInfo);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(22, null, null);
		}
	
		$display = "sent_pass";
		
		if (!empty($GLOBALS['am_error_log'])) {
			$display = "lost_pass";
		}
	}
}

//TEMPLATE
if (isset($c_node['node']['language']['pack'])) {
	$body->set('language_available', $c_node['node']['language']['pack']);
}

if (isset($display)) {
	$body->set('display', $display);
}

$body->set('datedropdown', $date->dateDropdown());

$pagename = "new password";
include "inc/footer_pre_login.inc.php";

?>
