<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_pol.inc.php";

if (!empty($group_id)) { // page under group section
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_poll'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $group_id ."&".SID);
		exit;
	}
} else {
  header("Location: g_groups.php?" . SID);
  exit;
  //check user_acs ?
}


//SETUP RSP ---------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['poll']);
$rsp->user_id = $me['user_id'];

if($c_node['rsp']['node']['auto_publish'] == 1) {
	$rsp->status_id = $c_node['rsp']['status']['live'];
}
else {
	$rsp->status_id = $c_node['rsp']['status']['pending'];
}

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (isset($frmdata['save']) || isset($frmdata['save_go'])) {

	if (!empty($frmdata['poll_start_date'])) {
		if (!empty($frmdata['poll_start_time'])) {
	    	$frmdata['poll_start_datetime'] = $date->formatFormDateTime($frmdata['poll_start_date'], $frmdata['poll_start_time']);
		}
		else {
			$frmdata['poll_start_datetime'] = $date->formatFormDateTime($frmdata['poll_start_date']);
		}
	}
	else {
		$GLOBALS['am_error_log'][] = array(38, null, null);
	}
	
	if (!empty($frmdata['poll_end_date'])) {
		if (!empty($frmdata['poll_start_time'])) {
	    	$frmdata['poll_end_datetime'] = $date->formatFormDateTime($frmdata['poll_end_date'], $frmdata['poll_end_time']);
		}
		else {
			$frmdata['poll_end_datetime'] = $date->formatFormDateTime($frmdata['poll_end_date']);
		}
	}
	else {
		$GLOBALS['am_error_log'][] = array(39, null, null);
	}
	
	if (empty($frmdata['poll_question'])) {
	    $GLOBALS['am_error_log'][] = array(37, null, null);
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		//
		if (isset($frmdata['poll_id']) && $frmdata['poll_id'] > 0) {
			$flag = $poll->updatePoll($frmdata);
			if($flag !== -1) {
			  unset($falg);
			}
		}
	 	else { //we insert record
			$poll->user_id = $me['user_id'];
	 		$poll->insertPoll($frmdata);
	 	}
				
		if (empty($GLOBALS['am_error_log']) && !isset($flag)) {
			//insert into setup rsp
			if (!empty($frmdata['group_id'])) {
			    $temp['language_id'] = $output_group['language_id'];
			}
			else {
				$temp['language_id'] = $me['language_id'];
			}
			
			
			$temp['item_id'] = $poll->poll_id;
			//delete all
			$rsp->deleteRspItem($poll->poll_id);
			
			if (isset($frmdata['rsp_degree']) && $frmdata['rsp_degree'] == "all") {
			    $temp['level_id'] = $c_node['rsp']['rsp_level']['degree'];
				$temp['degree_id'] = "null";
				$rsp->insertRspItem($temp);
			}
				
			if (!empty($frmdata['rsp_node'])) {
			    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
				$rsp->insertRspItem($temp);
			}
				
			if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					$rsp->status_id = $c_node['rsp']['status']['pending'];
					$rsp->insertRspItem($temp);
				}
			
			//setup statistics
			require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
			$statistic = new Statistic($db, $c_node['rsp']['item_type']['poll'], $date);
			
			//update stats
			if (!empty($frmdata['group_id'])) { // page under group section
				$statistic->section_item_id = $frmdata['group_id'];
				$statistic->statistic_type_id = $c_node['statistic']['group']['total_polls'];
			}
			else {
				$forum->user_id = $user_id;
				$statistic->section_id = $c_acs['arr_section']['user'];
				$statistic->user_id = $me['user_id'];
				$statistic->section_item_id = $me['user_id'];
				$statistic->statistic_type_id = $c_node['statistic']['user']['total_polls'];
			}
			
			$statistic->setStatistic($poll->getPollCount());
			
			//get member blog stats
			if (!empty($frmdata['group_id'])) { // page under group section
				$statistic->user_id = $me['user_id'];
				$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_polls'];
				$statistic->setStatistic($poll->getPollCount($me['user_id']));
			}
			
			
			if (isset($frmdata['save_go'])) {
				if (!empty($frmdata['group_id'])) { // page under group section
				    header("Location: pol_item.php?group_id=" . $frmdata['group_id'] . "&poll_id=" . $poll->poll_id . "&".SID);
					exit;
				}
				else {
					header("Location: pol_item.php?poll_id=" . $poll->poll_id . "&".SID);
					exit;
				}
			}
			else {
				if (!empty($frmdata['group_id'])) { // page under group section
					header("Location: pol_edit.php?group_id=" . $frmdata['group_id'] . "&poll_id=" . $poll->poll_id . "&".SID);
					exit;
				}
				else {
					header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
					exit;
				}
			}
		}
	}
	else { // somehing errored
		$output_poll = $frmdata;
	}
	
	$display = "allow_edit";
	
}
elseif (isset($_POST['delete_poll'])) {
	$poll->deletePoll();
	
	if (!empty($frmdata['group_id'])) { // page under group section
		header("Location: pol_list.php?group_id=" . $frmdata['group_id'] . "&".SID);
		exit;
	}
	else {
		header("Location: pol_list.php?".SID);
		exit;
	}
}
elseif (isset($_POST['insert_poll_option'])) {
	$poll->insertOption($frmdata['option_body']);
	
	if (!empty($frmdata['group_id'])) { // page under group section
		header("Location: pol_edit.php?group_id=" . $frmdata['group_id'] . "&poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}
	else {
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}
}
elseif (isset($_POST['update_poll_option'])) {
	$poll->updateOption($frmdata['option_id'], $frmdata['option_body']);
	
	if (!empty($frmdata['group_id'])) { // page under group section
		header("Location: pol_edit.php?group_id=" . $frmdata['group_id'] . "&poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}
	else {
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}

}
elseif (isset($_POST['delete_poll_option'])) {
	$poll->deleteOption($frmdata['option_id']);
	
	if (!empty($frmdata['group_id'])) { // page under group section
		header("Location: pol_edit.php?group_id=" . $frmdata['group_id'] . "&poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}
	else {
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}

}
elseif (isset($_REQUEST['poll_id']) && $_REQUEST['poll_id'] > 0) {
	$output_poll = $poll->getPoll();
	if(!is_null($output_poll)) {
		$display = "edit_poll";
	} else {
		$display = "add_poll";
		unset($output_poll);
		unset($poll->poll_id);
	}

}
else {
	$display = "add_poll";
}


if (isset($poll->poll_id)) {

	//You can delete before any comments are added or votes are given
	$output_poll_usage = $poll->getUserPollParticipation();
	
	if (isset($_REQUEST['option_id'])) { //we edit an option
		$output_option = $_REQUEST['option_id'];
	}
}



//format dates
if (isset($output_poll['poll_start_datetime'])) {
	$output_poll['poll_start_date'] = substr($output_poll['poll_start_datetime'], 0,10);
	$output_poll['poll_end_date'] = substr($output_poll['poll_end_datetime'], 0,10);
	$output_poll['poll_start_time'] = substr($output_poll['poll_start_datetime'], 11,15);
	$output_poll['poll_end_time'] = substr($output_poll['poll_end_datetime'], 11,15);
}
else {
	$output_poll['poll_start_date'] = date('Y-m-d');
	$output_poll['poll_end_date'] = date('Y-m-d');
	$output_poll['poll_start_time'] = date('H:i');
	$output_poll['poll_end_time'] = date('H:i');
}

//RSP items
if (isset($poll->poll_id)) {
	$output_poll['rsp'] = $rsp->selRspItem($poll->poll_id);
}


//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_polls)) {
   $body->set('polls', $output_polls);
}

if (!empty($output_poll)) {
   $body->set('poll', $output_poll);
}

if (!empty($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

if (!empty($output_option)) {
   $body->set('option', $output_option);
}

$body->set('languagePath', $languagePath);

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
