<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "config/config_aroundme.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";


//SETUP RSS FEED
include($c_node['dir']['class_path'] . 'FeedCreator.class.php');
$rss = new UniversalFeedCreator();
$rss->useCached();
$rss->link = $_SERVER['HTTP_HOST'];
$rss->syndicationURL = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];


		

if (isset($_REQUEST['feed'])) {
    //pull vars out of feed string
	$feed_user_pass = $_REQUEST['feed'];
	$user_id = substr($feed_user_pass,6);
	$feedpass = substr($feed_user_pass,0,6);
	
	
	// SETUP DATABASE -----------------------------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
	$ADODB_CACHE_DIR = 'cache/Adodb';
	$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
	$db = NewADOConnection($c_node['db']['driver']);
	$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
	$db->prefix = $c_node['db']['prefix'];
	
	
	//SETUP DATE -----------------------------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Date.class.php');
	$date = new Date();

	
	//we check that this person is who they say they are
	$query = "
		SELECT user_id, language_id 
		FROM " . $db->prefix . "_user
		WHERE 
		user_id=" . $db->qstr($user_id,get_magic_quotes_gpc()) . " AND 
		user_feed_password=" . $db->qstr($feedpass, get_magic_quotes_gpc())
	;
	
	$result = $db->Execute($query);
	
	//print_r($result);
	if (isset($result->fields['user_id'])) {//I am the correct user for this feed
		
		//url
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname ($_SERVER['PHP_SELF']);
		
		//get languages file
		$page_name_full = basename($_SERVER['REQUEST_URI']);
		$page_name = explode(".",$page_name_full);
		$languagePath = "language/" . $result->fields['language_id'] . "/" . $c_node['node']['template_default_name'] . "/";
		require_once($languagePath . $page_name[0] .'.lang.php');
		
		
		//SETUP RSS FEED
		$rss->title = $lang['txt_title'];
		$rss->description = $lang['txt_description'];
		
		
		//get blogs -----------------------------------------------------
		require_once($c_node['dir']['class_path'] . 'Blog.class.php');
		$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, null);
		$blog->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
		$blog->rsp_status_id = $c_node['rsp']['status']['live'];
		$blog->limit = 10;
		$output_blogs = $blog->selBlogs();
		
		
		
		//get library items -----------------------------------------------------
		require_once($c_node['dir']['class_path'] . 'Library.class.php');
		$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, null);
		$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
		$library->rsp_status_id = $c_node['rsp']['status']['live'];
		$library->limit = 10;
		$output_library_items = $library->selLibraryItems();
		
		
		//get polls  -----------------------------------------------------
		require_once($c_node['dir']['class_path'] . 'Poll.class.php');
		$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
		$poll->order_by = "p.poll_start_datetime desc";
		$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
		$poll->rsp_status_id = $c_node['rsp']['status']['live'];
		$poll->limit = 10;
		$output_polls = $poll->selPolls();
		
		
		//get subjects  -----------------------------------------------------
		require_once($c_node['dir']['class_path'] . 'Forum.class.php');
		$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, null);
		$forum->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
		$forum->rsp_status_id = $c_node['rsp']['status']['live'];
		$forum->limit = 10;
		$output_subjects = $forum->selSubjects();
		
		
		
		
		
		//OUTPUT RSS
		if (isset($output_subjects)) {
			$blog_url = $url . "/mag_item.php?subject_id=";
			
			foreach($output_subjects as $key => $i):
			    $item = new FeedItem();
			    $item->title = $i['subject_title'];
			    $item->link = $blog_url . $i['subject_id'];
			    $item->description = $i['subject_body'];
			    $item->date = $i['subject_create_timestamp'];
			    $item->source = $_SERVER['HTTP_HOST']."/";
			    $item->author = "";
			    
			    $rss->addItem($item);
			endforeach;
		}
		
		if (isset($output_blogs)) {
			$blog_url = $url . "/mag_item.php?blog_id=";
			
			foreach($output_blogs as $key => $i):
			    $item = new FeedItem();
			    $item->title = $i['blog_title'];
			    $item->link = $blog_url . $i['blog_id'];
			    $item->description = $i['blog_synopsis'];
			    $item->date = $i['blog_create_timestamp'];
			    $item->source = $_SERVER['HTTP_HOST']."/";
			    $item->author = "";
			    
			    $rss->addItem($item);
			endforeach;
		}
		
		if (isset($output_polls)) {
			$poll_url = $url . "/mag_item.php?poll_id=";
			
			foreach($output_polls as $key => $i):
			    $item = new FeedItem();
			    $item->title = $i['poll_question'];
			    $item->link = $poll_url . $i['poll_id'];
			    $item->description = $i['poll_question'];
			    $item->date = $i['poll_create_timestamp'];
			    $item->source = $_SERVER['HTTP_HOST']."/";
			    $item->author = "";
			    
			    $rss->addItem($item);
			endforeach;
		}
		
		if (isset($output_library_items)) {
			$library_url = $url . "/mag_item.php?library_id=";
			
			foreach($output_library_items as $key => $i):
			    $item = new FeedItem();
			    $item->title = $i['library_title'];
			    $item->link = $library_url . $i['library_id'];
			    $item->description = $i['library_synopsis'];
			    $item->date = $i['library_create_timestamp'];
			    $item->source = $_SERVER['HTTP_HOST']."/";
			    $item->author = "";
			    
			    $rss->addItem($item);
			endforeach;
		}
		
		//TIDY UP
		$db->Close();
		
		$rss->saveFeed($c_node['rss']['output'], "cache/feed.xml"); 
		
	}
	else {
		//SETUP RSS FEED WHERE PASSWORD WAS NOT RECEIVED
		$rss->title = "Error";
		$rss->description = "Your password is incorrect. Please change your membership password to rectify this.";
		$rss->saveFeed("RSS2.0", "cache/feed/feed_tmp.xml"); 
	}
}
else {
	//SETUP RSS FEED WHERE PASSWORD WAS NOT RECEIVED
	$rss->title = "Error";
	$rss->description = "Your password is incorrect. Please change your membership password to rectify this.";
	$rss->saveFeed("RSS2.0", "cache/feed/feed_tmp.xml"); 
}

?>