#ifndef __DIRECTORY_H__
#define __DIRECTORY_H__
#include "Common.h"

namespace AScript {
//-----------------------------------------------------------------------------
// DirEntry
//-----------------------------------------------------------------------------
class DLLDECLARE DirEntry {
private:
	String _name;
	bool _dirFlag;
protected:
	virtual ~DirEntry();
public:
	inline DirEntry() : _dirFlag(false) {}
	inline DirEntry(const String &name, bool dirFlag) :
						_name(name), _dirFlag(dirFlag) {}
	inline DirEntry(const DirEntry &dirEntry) :
						_name(dirEntry._name), _dirFlag(dirEntry._dirFlag) {}
	inline static void Delete(DirEntry *pDirEntry) { delete pDirEntry; }
	inline const char *GetName() const { return _name.c_str(); }
	inline bool IsDirectory() const { return _dirFlag; }
};

//-----------------------------------------------------------------------------
// Directory
//-----------------------------------------------------------------------------
class DLLDECLARE Directory {
protected:
	String _name;
protected:
	inline Directory(const char *name) : _name(name) {}
public:
	virtual ~Directory();
	virtual DirEntry *DoNext(Signal sig) = 0;
	virtual char GetSeparator() const = 0;
	inline DirEntry *Next(Signal sig) { return DoNext(sig); }
	inline const char *GetName() const { return _name.c_str(); }
};

//-----------------------------------------------------------------------------
// DirectoryFactory
//-----------------------------------------------------------------------------
class DLLDECLARE DirectoryFactory {
public:
	typedef std::vector<DirectoryFactory *> List;
private:
	static List *_pList;
public:
	virtual bool IsResponsible(Signal sig, const char *name) = 0;
	virtual Directory *DoOpen(Signal sig, const char *name) = 0;
public:
	static void Register(DirectoryFactory *pDirectoryFactory);
	static Directory *Open(Signal sig, const char *name);
	static DirectoryFactory *FindResponsible(Signal sig, const char *name);
};

//-----------------------------------------------------------------------------
// DirEntry_FileSystem
//-----------------------------------------------------------------------------
class DLLDECLARE DirEntry_FileSystem : public DirEntry {
public:
	inline DirEntry_FileSystem() {}
	inline DirEntry_FileSystem(const String &name, bool dirFlag) :
						DirEntry(name, dirFlag) {}
	inline DirEntry_FileSystem(const DirEntry_FileSystem &dirEntry) :
						DirEntry(dirEntry) {}
};

//-----------------------------------------------------------------------------
// Directory_FileSystem
//-----------------------------------------------------------------------------
class DLLDECLARE Directory_FileSystem : public Directory {
private:
#if defined(HAVE_WINDOWS_H)
	HANDLE _hFind;
#else
	DIR *_pDir;
#endif
public:
	Directory_FileSystem(const char *name);
	virtual ~Directory_FileSystem();
	virtual DirEntry *DoNext(Signal sig);
	virtual char GetSeparator() const;
};

//-----------------------------------------------------------------------------
// DirectoryFactory_FileSystem
//-----------------------------------------------------------------------------
class DLLDECLARE DirectoryFactory_FileSystem : public DirectoryFactory {
public:
	virtual bool IsResponsible(Signal sig, const char *name);
	virtual Directory *DoOpen(Signal sig, const char *name);
};

}

#endif
