#ifndef __STREAM_H__
#define __STREAM_H__

#include "Signal.h"
#include "Console.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Stream
//-----------------------------------------------------------------------------
class DLLDECLARE Stream : public Console {
public:
	enum SeekMode { SeekSet, SeekCur };
private:
	bool _infiniteFlag;
	size_t _offset;
	struct {
		char *buff;
		size_t bytes;
		size_t offsetRead;
	} _peek;
public:
	Stream(bool infiniteFlag);
	virtual ~Stream();
	virtual void Close();
	virtual const char *GetName() const = 0;
	virtual size_t DoRead(Signal sig, void *buff, size_t len) = 0;
	virtual size_t DoWrite(Signal sig, const void *buff, size_t len) = 0;
	virtual bool DoSeek(Signal sig, long offset, SeekMode seekMode) = 0;
	virtual bool DoFlush(Signal sig) = 0;
	virtual bool IsReadable() const = 0;
	virtual bool IsWritable() const = 0;
	inline bool IsInfinite() const { return _infiniteFlag; }
	size_t Read(Signal sig, void *buff, size_t len);
	size_t Write(Signal sig, const void *buff, size_t len);
	size_t Peek(Signal sig, void *buff, size_t len);
	bool Seek(Signal sig, long offset, SeekMode seekMode);
	bool Flush(Signal sig);
	bool HasNameSuffix(const char *suffix, bool ignoreCase = true) const;
	bool CheckReadable(Signal sig) const;
	bool CheckWritable(Signal sig) const;
	bool Compare(Signal sig, Stream &stream);
	bool ReadToStream(Signal sig, Stream &streamDst);
};

}

#endif
