#ifndef __OBJECT_DATETIME_H__
#define __OBJECT_DATETIME_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_DateTime / Object_DateTime
//-----------------------------------------------------------------------------
class DLLDECLARE Class_DateTime : public Class {
public:
	Class_DateTime(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_DateTime : public Object {
public:
	AScript_DeclareObjectAccessor(DateTime)
private:
	DateTime _dateTime;
public:
	inline Object_DateTime(Environment &env, const DateTime &dateTime) :
				Object(env.LookupClass(VTYPE_DateTime)), _dateTime(dateTime) {}
	inline Object_DateTime(Class *pClass, const DateTime &dateTime) :
				Object(pClass), _dateTime(dateTime) {}
	Object_DateTime(const Object_DateTime &obj);
	virtual ~Object_DateTime();
	virtual Object *Clone() const;
	virtual bool DoPropDir(Signal sig, SymbolSet &symbols);
	virtual Value DoPropGet(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual Value DoPropSet(Signal sig,
				const Symbol *pSymbol, const Value &value, bool &evaluatedFlag);
	virtual String ToString(Signal sig, bool exprFlag);
	inline DateTime &GetDateTime() { return _dateTime; }
	inline const DateTime &GetDateTime() const { return _dateTime; }
};

}

#endif
