#ifndef __OBJECT_ITERATOR_H__
#define __OBJECT_ITERATOR_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Iterator
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Iterator : public Class {
public:
	Class_Iterator(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Iterator : public Object {
public:
	AScript_DeclareObjectAccessor(Iterator)
private:
	Iterator *_pIterator;
public:
	inline Object_Iterator(Environment &env, Iterator *pIterator) :
				Object(env.LookupClass(VTYPE_Iterator)), _pIterator(pIterator) {}
	inline Object_Iterator(Class *pClass, Iterator *pIterator) :
				Object(pClass), _pIterator(pIterator) {}
	Object_Iterator(const Object_Iterator &obj);
	virtual ~Object_Iterator();
	virtual Object *Clone() const;
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	inline Iterator *GetIterator() const { return _pIterator; }
};

}

#endif
