#ifndef __OBJECT_STRING_H__
#define __OBJECT_STRING_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_String / Object_String
//-----------------------------------------------------------------------------
class DLLDECLARE Class_String : public Class {
public:
	Class_String(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_String : public Object {
public:
	class DLLDECLARE IteratorEach : public Iterator {
	private:
		Object_String *_pObj;
		int _cnt, _cntMax;
		bool _utf32Flag;
		String::const_iterator _pCur;
	public:
		IteratorEach(Object_String *pObj, int maxSplit, bool utf32Flag);
		virtual ~IteratorEach();
		virtual bool DoNext(Environment &env, Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
	class DLLDECLARE IteratorLine : public Iterator {
	private:
		Object_String *_pObj;
		int _cnt, _cntMax;
		String::const_iterator _pCur;
		bool _includeEOLFlag;
	public:
		IteratorLine(Object_String *pObj, int cntMax, bool includeEOLFlag);
		virtual ~IteratorLine();
		virtual bool DoNext(Environment &env, Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
	class DLLDECLARE IteratorSplit : public Iterator {
	private:
		Object_String *_pObj;
		String _sep;
		int _cnt, _cntMax;
		bool _ignoreCaseFlag;
		bool _doneFlag;
		String::const_iterator _pCur;
	public:
		IteratorSplit(Object_String *pObj,
						const char *sep, int cntMax, bool ignoreCaseFlag);
		virtual ~IteratorSplit();
		virtual bool DoNext(Environment &env, Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	AScript_DeclareObjectAccessor(String)
private:
	String _str;
public:
	inline Object_String(Class *pClass) : Object(pClass) {}
	inline Object_String(Environment &env) : Object(env.LookupClass(VTYPE_String)) {}
	inline Object_String(Environment &env, const char *str) :
						Object(env.LookupClass(VTYPE_String)), _str(str) {}
	inline Object_String(Environment &env, const char *str, size_t len) :
						Object(env.LookupClass(VTYPE_String)), _str(str, len) {}
	Object_String(const Object_String &obj);
	virtual ~Object_String();
	virtual Object *Clone() const;
	virtual Value IndexGet(Signal sig, const Value &valueIdx);
	virtual void IndexSet(Signal sig, const Value &valueIdx, const Value &value);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	inline const char *GetString() const { return _str.c_str(); }
	inline const String &GetStringSTL() const { return _str; }
};

}

#endif
