//-----------------------------------------------------------------------------
// AScript sample module
//-----------------------------------------------------------------------------
#include <ascript.h>

AScript_BeginModule(sample)

AScript_DeclarePrivSymbol(hoge_symbol);

//-----------------------------------------------------------------------------
// Object_Foo declaration
//-----------------------------------------------------------------------------
AScript_DeclarePrivClass(Foo);

class Object_Foo : public Object {
public:
	AScript_DeclareObjectAccessor(Foo)
public:
	inline Object_Foo() : Object(AScript_PrivClass(Foo)) {}
	inline Object_Foo(const Object_Foo &obj) : Object(obj) {}
	virtual ~Object_Foo();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
};

//-----------------------------------------------------------------------------
// Object_Foo implementation
//-----------------------------------------------------------------------------
Object_Foo::~Object_Foo()
{
}

Object *Object_Foo::Clone() const
{
	return new Object_Foo(*this);
}

String Object_Foo::ToString(Signal sig, bool exprFlag)
{
	return String("<Foo>");
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Foo
//-----------------------------------------------------------------------------
// sample.foo#test()
AScript_DeclareMethod(Foo, test)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

AScript_ImplementMethod(Foo, test)
{
	Object_Foo *pSelf = Object_Foo::GetSelfObj(args);
	return Value(env, "foo object");
}

// implementation of class Foo
AScript_ImplementPrivClass(Foo)
{
	AScript_AssignMethod(Foo, test);
}

//-----------------------------------------------------------------------------
// AScript module functions: sample
//-----------------------------------------------------------------------------
// sample.create_foo()
AScript_DeclareFunction(create_foo)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

AScript_ImplementFunction(create_foo)
{
	return Value(new Object_Foo());
}

// result = sample.adder(num1:number, num2:number)
AScript_DeclareFunction(adder)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder)
{
	return Value(args.GetNumber(0) + args.GetNumber(1));
}

// Module entry
AScript_ModuleEntry()
{
	// symbol realization
	AScript_RealizePrivSymbol(hoge_symbol);
	// class realization
	AScript_RealizePrivClass(Foo, "foo", env.LookupClass(VTYPE_Object));
	// value assignment
	AScript_AssignValue(foo, Value(env, "a value in sample module"));
	// function assignment
	AScript_AssignFunction(create_foo);
	AScript_AssignFunction(adder);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(sample, sample)

AScript_RegisterModule(sample)
