//
// Object_TimeDelta
//

#include "ascript/Object_TimeDelta.h"
#include "ascript/Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_TimeDelta
//-----------------------------------------------------------------------------
Object_TimeDelta::Object_TimeDelta(const Object_TimeDelta &obj) :
										Object(obj), _timeDelta(obj._timeDelta)
{
}

Object_TimeDelta::~Object_TimeDelta()
{
}

Object *Object_TimeDelta::Clone() const
{
	return new Object_TimeDelta(*this);
}

bool Object_TimeDelta::DoPropDir(Signal sig, SymbolSet &symbols)
{
	if (!Object::DoPropDir(sig, symbols)) return false;
	symbols.insert(AScript_Symbol(days));
	symbols.insert(AScript_Symbol(secs));
	symbols.insert(AScript_Symbol(usecs));
	return true;
}

Value Object_TimeDelta::DoPropGet(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag)
{
	evaluatedFlag = true;
	if (pSymbol->IsIdentical(AScript_Symbol(days))) {
		return Value(static_cast<Number>(_timeDelta.GetDays()));
	} else if (pSymbol->IsIdentical(AScript_Symbol(secs))) {
		return Value(static_cast<Number>(_timeDelta.GetSecsRaw()));
	} else if (pSymbol->IsIdentical(AScript_Symbol(usecs))) {
		return Value(static_cast<Number>(_timeDelta.GetUSecs()));
	}
	evaluatedFlag = false;
	return Value::Null;
}

Value Object_TimeDelta::DoPropSet(Signal sig,
				const Symbol *pSymbol, const Value &value, bool &evaluatedFlag)
{
	evaluatedFlag = true;
	if (pSymbol->IsIdentical(AScript_Symbol(days))) {
		_timeDelta = TimeDelta(value.GetLong(), _timeDelta.GetSecs(), _timeDelta.GetUSecs());
		return Value(static_cast<Number>(_timeDelta.GetDays()));
	} else if (pSymbol->IsIdentical(AScript_Symbol(secs))) {
		_timeDelta = TimeDelta(_timeDelta.GetDays(), value.GetLong(), _timeDelta.GetUSecs());
		return Value(static_cast<Number>(_timeDelta.GetSecsRaw()));
	} else if (pSymbol->IsIdentical(AScript_Symbol(usecs))) {
		_timeDelta = TimeDelta(_timeDelta.GetDays(), _timeDelta.GetSecs(), value.GetLong());
		return Value(static_cast<Number>(_timeDelta.GetUSecs()));
	}
	evaluatedFlag = false;
	return DoPropGet(sig, pSymbol, evaluatedFlag);
}

String Object_TimeDelta::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<timedelta:";
	str += _timeDelta.ToString();
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_TimeDelta
//-----------------------------------------------------------------------------
// assignment
Class_TimeDelta::Class_TimeDelta(Environment *pEnvOuter) : Class(pEnvOuter)
{
}

Object *Class_TimeDelta::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
