#ifndef __CONFIGDIALOG_H__
#define __CONFIGDIALOG_H__

#include <wx/wx.h>
#include <wx/notebook.h>
#include <wx/valgen.h>
#include <wx/colordlg.h>

class ConfigDialog : public wxDialog {
public:
	enum PageId {
		PAGEID_None,
		PAGEID_Terminal,
	};
private:
	class Page : public wxPanel {
	public:
		inline Page(wxWindow *pParent) : wxPanel(pParent, wxID_ANY) {}
	};
	class Page_Terminal : public Page {
	enum {
		ID_BTN_FontColor = 1000,
		ID_BTN_BackgroundColor,
	};
	private:
		wxString _fontSize;
		wxString _fontColor;
		wxString _backgroundColor;
		wxTextCtrl *_pTextFontColor;
		wxTextCtrl *_pTextBackgroundColor;
	public:
		Page_Terminal(wxWindow *pParent);
		virtual bool TransferDataToWindow();
		virtual bool TransferDataFromWindow();
	private:
		void ShowColourDialog(wxTextCtrl *pText);
		DECLARE_EVENT_TABLE()
		void OnButton_FontColor(wxCommandEvent &event);
		void OnButton_BackgroundColor(wxCommandEvent &event);
	};
public:
	ConfigDialog(wxWindow *pParent, PageId pageId = PAGEID_None);
};

#endif
