#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_testinfo
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #INCLUDE# ------------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	ASSETION FUNCTION
 * @public
 * Autest_GetCurrentTestInfo
 * AutestTestInfo_GetResult
 * AutestTestInfo_GetMessage
 * AutestTestInfo_GetName
 * AutestTestInfo_GetElapsedTime
#ce ----------------------------------------------------------------------------

;
; Autest_GetCurrentTestInfo
;
Func Autest_GetCurrentTestInfo()
	IF Not IsDeclared("autest_current_testinfo") Then
		Global $autest_current_testinfo = 0
	EndIf
	Return $autest_current_testinfo
EndFunc

;
; AutestTestInfo_GetResult
;
Func AutestTestInfo_GetResult($testinfo_ptr)
	Local $testinfo = Autest_CastToTestInfo($testinfo_ptr)
	Return DllStructGetData($testinfo, "result")
EndFunc

;
; AutestTestInfo_GetMessage
;
Func AutestTestInfo_GetMessage($testinfo_ptr)
	Local $testinfo = Autest_CastToTestInfo($testinfo_ptr)
	Return String(DllStructGetData($testinfo, "message"))
EndFunc

;
; AutestTestInfo_GetName
;
Func AutestTestInfo_GetName($testinfo_ptr)
	Local $testinfo = Autest_CastToTestInfo($testinfo_ptr)
	Return String(DllStructGetData($testinfo, "name"))
EndFunc

;
; AutestTestInfo_GetElapsedTime
;
Func AutestTestInfo_GetElapsedTime($testinfo_ptr)
	Local $testinfo = Autest_CastToTestInfo($testinfo_ptr)
	Return DllStructGetData($testinfo, "elapsed_msec")
EndFunc

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_SetCurrentTestInfo
 * AutestTestInfo_SetResult
 * AutestTestInfo_SetMessage
 * Autest_MakeTestFuncName
 * Autest_AddTestInfo
 * Autest_RunTestInfo
 * Autest_RunTest
#ce ----------------------------------------------------------------------------

;
; Autest_SetCurrentTestInfo
;
Func Autest_SetCurrentTestInfo($testinfo_ptr)
	IF Not IsDeclared("autest_current_testinfo") Then
		Global $autest_current_testinfo = 0
	EndIf
	$autest_current_testinfo = $testinfo_ptr
EndFunc

;
; AutestTestInfo_SetResult
;
Func AutestTestInfo_SetResult($ptr, $result)
	IF $ptr Then
		Local $testinfo = Autest_CastToTestInfo($ptr)
		DllStructSetData($testinfo, "result", $result)
	EndIf
EndFunc

;
; AutestTestInfo_SetMessage
;
Func AutestTestInfo_SetMessage($ptr, $msg)
	IF $ptr Then
		Local $testinfo = Autest_CastToTestInfo($ptr)
		DllStructSetData($testinfo, "message", $msg)
	EndIf
EndFunc

;
; Autest_MakeTestFuncName
;
Func Autest_MakeTestFuncName($testcase, $testname)
	Return $testcase & "_" & $testname
EndFunc

;
; Autest_AddTestInfo
;
Func Autest_AddTestInfo(ByRef $testcase, $testname)
	Local $varname = "autest_testinfo_var_" & String(Random()) & String(Random())
	Assign($varname, DllStructCreate( Autest_GetTestInfoDllStructString() ), 2 )
	Local $testinfo = Eval($varname)
	DllStructSetData($testinfo, "name", $testname)
	DllStructSetData($testinfo, "next", Ptr(0))
	DllStructSetData($testinfo, "result", True)
	DllStructSetData($testinfo, "elapsed_msec", 0)

	Local $top = DllStructGetData($testcase, "testinfo")
	IF $top Then
		Local $tail = Ptr(0)
		Local $curr = $top
		While $curr
			Local $info = Autest_CastToTestInfo($curr)
			Local $name = DllStructGetData($info, "name")
			IF StringCompare($testname, $name) == 0 Then
				; Error
			EndIf
			$tail = $info
			$curr = Autest_CastToTestInfo($curr)
		WEnd
		DllStructSetData($tail, "next", DllStructGetPtr($testinfo))
		Local $num = DllStructGetData($testcase, "num")
		DllStructSetData($testcase, "num", $num+1)
	Else
		DllStructSetData($testcase, "testinfo", DllStructGetPtr($testinfo))
		DllStructSetData($testcase, "num", 1)
	EndIf
EndFunc

;
; Autest_RunTestInfo
;
Func Autest_RunTestInfo(ByRef $testcase, $testinfo_ptr)
	Local $testcase_name = DllStructGetData($testcase, "name")
	Local $testinfo = Autest_CastToTestInfo($testinfo_ptr)
	Local $testname = DllStructGetData($testinfo, "name")
	Local $testfullname = Autest_MakeTestFuncName($testcase_name, $testname)
	Local $filter = AutestOpt_GetFilter()
	IF StringRegExp($testfullname, $filter) Then
		Autest_SetCurrentTestInfo($testinfo_ptr)
		Autest_OnTestStart($testcase_name, $testinfo)
		Local $tm = TimerInit()
		Autest_RunTest($testcase_name, $testname)
		Local $dif = TimerDiff($tm)
		Autest_OnTestEnd($testcase_name, $testinfo)
		Autest_SetCurrentTestInfo(Ptr(0))
		DllStructSetData($testinfo, "elapsed_msec", $dif)
	EndIf
EndFunc

;
; Autest_RunTest
;
Func Autest_RunTest($testcase_name, $testname)
	Local $testfullname = Autest_MakeTestFuncName($testcase_name, $testname)
	Call($testfullname)
EndFunc

;
; Autest_CastToTestInfo
;
Func Autest_CastToTestInfo($info)
	IF IsDllStruct($info) Then
		Return $info
	Else
		Local $testinfo = DllStructCreate( Autest_GetTestInfoDllStructString(), $info)
		IF @error Then Autest_ConsolePrintLn("Autest_CastToTestInfo: Failed " & @error)
		Return $testinfo
	EndIf
EndFunc

;
; Autest_GetNextTestInfo
;
Func Autest_GetNextTestInfo($info)
	Local $testinfo = Autest_CastToTestInfo($info)
	Return DllStructGetData($testinfo, "next")
EndFunc

;
; Autest_GetTestInfoDllStructString
;
Func Autest_GetTestInfoDllStructString()
	Local $str = "char name[256]; ptr next; int elapsed_msec; bool result; char message[1024];"
	Return $str
EndFunc

