#include	"trust.h"
#include	"shm.h"

void	exit (int status);

void	MainLoop();
void	CloseSocket();
void	CloseChild();

void main(argc, argv)
int	argc;
char	*argv[];
{
	FILE	*PidFile;

	Soc = 0;
	Acc = 0;
	TrustDB_in = 0;
	TrustDB_out = 0;
	cmdmode = 0;
	cmdin	= 0;

        PidFile = fopen ("/var/run/dstrust.pid","w");
        if (PidFile == NULL)
        {
                printf ("must run on supper user\n");
                exit(-1);
        }
        fprintf (PidFile, "%d\n",(int)getpid());
        fclose (PidFile);

	config();

        if (cmdmode == 0)
        {
                cmdin = 0;
        }
        else
        {
                cmdin = open ("/tmp/dstrust-cmdin", O_NONBLOCK | O_RDONLY);
                if (cmdin < 0)
                {
                        printf ("ERROR FIFO file not open /tmp/dstrust-cmdin\n");
                        cmdin = 0;
                }
        }

	InitSocket();
	InitSignal();
	MainLoop();
}

int InitSocket(void)
{
	char	hostname[MAXHOSTNAMELEN];
	struct	hostent	*myhost;
	struct	servent	*se;
	struct	sockaddr_in	me;
	int	opt;

	DB(fprintf(stderr,"InitSocket\n"));

	if (gethostname(hostname,MAXHOSTNAMELEN) == -1){
		perror("gethostname");
		exit(-1);
	}
	DB(fprintf(stderr,"hostname=%s\n",hostname));
	if ((se=getservbyname("AuthTrust","tcp")) == NULL){
		perror("getservbyname");
		exit(-1);
	}
	DB(fprintf(stderr,"getservbyname:OK\n"));
	if ((myhost=gethostbyname(hostname)) == NULL){
		perror("gethostbyname");
		exit(-1);
	}
	DB(fprintf(stderr,"gethostbyname:OK\n"));
	if ((Soc=socket(AF_INET,SOCK_STREAM,0)) < 0){
		perror("socket");
		exit(-1);
	}
	DB(fprintf(stderr,"socket:OK\n"));
	opt=1;
	if (setsockopt(Soc,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
		perror("setsockopt");
		exit(-1);
	}
	DB(fprintf(stderr,"setsockopt:OK\n"));
        memset((char *)&me,0,sizeof(me));
        me.sin_family=AF_INET;
        me.sin_port=se->s_port;
        if (bind(Soc,(struct sockaddr *)&me,sizeof(me)) == -1){
                perror("bind");
                exit(-1);
        }
        DB(fprintf(stderr,"bind:OK\n"));
        if ((se=getservbyname("TrustDB_in","udp")) == NULL){
                perror("getservbyname");
                exit(-1);
        }
        DB(fprintf(stderr,"getservbyname:TrustDB_in:OK\n"));
	dbInPort = se->s_port;
        if ((TrustDB_in = socket(AF_INET,SOCK_DGRAM,0)) < 0){
                perror("socket:TrustDB_in");
                exit(-1);
        }
        DB(fprintf(stderr,"socket:TrustDB_in:OK\n"));

	memset((char *)&db_in,0,sizeof(db_in));
	db_in.sin_family=AF_INET;
	db_in.sin_port=dbInPort;
	if (bind(TrustDB_in,(struct sockaddr *)&db_in, sizeof(db_in)) == -1){
		perror("bind:db");
		exit(-1);
	}
	DB(fprintf(stderr,"bind:db:OK\n"));

        if ((se=getservbyname("TrustDB_out","udp")) == NULL){
                perror("getservbyname");
                exit(-1);
        }
        DB(fprintf(stderr,"getservbyname:TrustDB_out:OK\n"));
	dbOutPort = se->s_port;

        shm_id = shmget (IPC_PRIVATE, sizeof(struct shm_form) * MAX_SHM ,
				IPC_CREAT | 0660);
	if (shm_id == -1)
        {
                perror("shmget");
                exit(-1);
        }
	DB(fprintf(stderr,"shmget:OK\n"));

	shm_msg = shmat (shm_id, NULL, 0);
	if (shm_msg == (void *)-1)
	{
		perror("shmat");
		shmctl (shm_id, IPC_RMID, NULL);
		exit(-1);
	}
        DB(fprintf(stderr,"shmat:OK\n"));

	return(0);
}

void CloseSocket()
{
	DB(fprintf(stderr,"CloseSocket\n"));
	if(Soc != 0){
		close(Soc);
		DB(fprintf(stderr,"close(Soc)\n"));
		Soc = 0;
	}
	if(Acc != 0){
		close(Acc);
		DB(fprintf(stderr,"close(Acc)\n"));
		Acc = 0;
	}
        if(TrustDB_in != 0){
                close(TrustDB_in);
                DB(fprintf(stderr,"close(TrustDB_in)\n"));
                TrustDB_in = 0;
        }
        if(TrustDB_out != 0){
                close(TrustDB_out);
                DB(fprintf(stderr,"close(TrustDB_out)\n"));
                TrustDB_out = 0;
        }
	DB(fprintf(stderr,"CloseSocket:exit\n"));

        shmdt (shm_msg);
        shmctl (shm_id, IPC_RMID, NULL);

	exit(0);
}

void CloseChild()
{
	int	pid;

	DB(fprintf(stderr,"CloseChild\n"));
	pid=wait(0);
	DB(fprintf(stderr,"wait:pid=%d:end\n",pid));
	signal(SIGCLD,CloseChild);
}

int InitSignal()
{
	DB(fprintf(stderr,"InitSignal\n"));
	signal(SIGINT,CloseSocket);
	signal(SIGTERM,CloseSocket);
	signal(SIGCLD,CloseChild);

	return(0);
}

void MainLoop(void)
{
	struct sockaddr_in	from;
	int	n;
	int	len,width, pid;
	fd_set	readOk,Mask;
	struct	timeval	timeout;
	char	client[64];

	DB(fprintf(stderr,"MainLoop\n"));

	for (n = 0 ; n < MAX_SHM ; n++)
	{
		shm_msg->shmem[n].mem.type = 0;
		shm_msg->shmem[n].mem.protocol = 0;	/* default ICOM (G1 & G2) */
		shm_msg->shmem[n].e_time.tv_sec = 0;
		shm_msg->shmem[n].e_time.tv_usec = 0;
		memset (shm_msg->shmem[n].mem.srcCall, 0x20, 8); 
		memset (shm_msg->shmem[n].mem.dstCall, 0x20, 8);
	}

	FD_ZERO(&Mask);
	FD_SET(Soc, &Mask);
	FD_SET(TrustDB_in, &Mask);
	FD_SET(cmdin, &Mask);
	width = Soc;
	if (width < cmdin) width = cmdin;
	if (width < TrustDB_in) width = TrustDB_in;
	width += 1;

	listen(Soc,SOMAXCONN);
	DB(fprintf(stderr,"listen:OK\n"));
	while(1){
		readOk = Mask;
		timeout.tv_sec = 0;
		timeout.tv_usec = 500000;
		switch (select(width, (fd_set *)&readOk, NULL, NULL, &timeout)){
			case	-1:
				perror("select");
				break;
			case	0:
				DeleteEntry();
				break;
			default:
				if(FD_ISSET(Soc,&readOk)){
					len=sizeof(from);
					Acc=accept(Soc, (struct sockaddr *)&from,&len);
					if(Acc<0){
						if(errno==EINTR){
							continue;
						}
						perror("accept");
						continue;
					}
					sprintf(client,"%s", inet_ntoa (from.sin_addr));
					DB(fprintf(stderr,"accept:%s\n",client));
					RepeaterIP = from.sin_addr;
					if((pid=fork())==0){
						close(Soc);
						Soc=0;
						Repeater();
						DB(fprintf(stderr,"MainLoop:exit\n"));
						exit(0);
					}
					DB(fprintf(stderr,"pid=%d\n",pid));
					setpgrp(pid, getpid());
					close(Acc);
					Acc=0;
				}
				if (FD_ISSET(TrustDB_in, &readOk))
				{
					insEntry();
				}
				if(FD_ISSET(cmdin,&readOk)){
					KeyIn();
				}
				break;
		}
	}
}

