/*
	Auther	Satoshi Yasuda	7m3tjz/ad6gz
*/

#include	"trustDB.h"

void	exit (int status);

void	MainLoop();
void	CloseSocket();
void	CloseChild();

void main(argc, argv)
int	argc;
char	*argv[];
{
	FILE	*PidFile;

	TrustDB_in = 0;
	TrustDB_out = 0;
	cmdin = 0;
	cmdmode = 0;
	dbInPort = htons(29001);
	dbOutPort = htons(29002);

        PidFile = fopen ("/var/run/dstrustdb.pid","w");
        if (PidFile == NULL)
        {
                printf ("must run on supper user\n");
                exit(-1);
        }
        fprintf (PidFile, "%d\n",(int)getpid());
        fclose (PidFile);

        config();

        if (cmdmode == 0)
        {
                cmdin = 0;
        }
        else
        {
                cmdin = open ("/tmp/dstrustdb-cmdin", O_NONBLOCK | O_RDONLY);
                if (cmdin < 0)
                {
                        printf ("ERROR FIFO file not open /tmp/dstrustdb-cmdin\n");
                        cmdin = 0;
                }
        }

	InitSocket();
	InitSignal();
	MainLoop();
}

int InitSocket(void)
{
	char	hostname[MAXHOSTNAMELEN];
	struct	hostent	*myhost;
	int	opt;

	DB(fprintf(stderr,"InitSocket\n"));


        if ((TrustDB_in = socket(PF_INET,SOCK_DGRAM,0)) < 0){
                perror("socket:TrustDB_in");
                exit(-1);
        }
        DB(fprintf(stderr,"socket:TrustDB_in:OK\n"));

        opt=1;
        if (setsockopt(TrustDB_in,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
                perror("setsockopt");
                exit(-1);
        }
        DB(fprintf(stderr,"setsockopt:OK\n"));

        if ((TrustDB_out = socket(PF_INET,SOCK_DGRAM,0)) < 0){
                perror("socket:TrustDB_out");
                exit(-1);
        }
        DB(fprintf(stderr,"socket:TrustDB_out:OK\n"));
        opt=1;
        if (setsockopt(TrustDB_out,SOL_SOCKET,SO_REUSEADDR,&opt,sizeof(int)) != 0){
                perror("setsockopt");
                exit(-1);
        }
        DB(fprintf(stderr,"setsockopt:OK\n"));
	memset((char *)&db_out,0,sizeof(db_out));
	db_out.sin_family=PF_INET;
	db_out.sin_port=dbOutPort;
//	db_out.sin_addr.s_addr = inet_addr("127.0.0.1");
	if (bind(TrustDB_out,(struct sockaddr *)&db_out, sizeof(db_out)) == -1){
		perror("bind:db_out");
		exit(-1);
	}
	DB(fprintf(stderr,"bind:db:OK\n"));

	return(0);
}

void CloseSocket()
{
	DB(fprintf(stderr,"CloseSocket\n"));
        if(TrustDB_in != 0){
                close(TrustDB_in);
                DB(fprintf(stderr,"close(TrustDB_in)\n"));
                TrustDB_in = 0;
        }
        if(TrustDB_out != 0){
                close(TrustDB_out);
                DB(fprintf(stderr,"close(TrustDB_out)\n"));
                TrustDB_out = 0;
        }
	DB(fprintf(stderr,"CloseSocket:exit\n"));

	exit(0);
}

void CloseChild()
{
	int	pid;

	DB(fprintf(stderr,"CloseChild\n"));
	pid=wait(0);
	DB(fprintf(stderr,"wait:pid=%d:end\n",pid));
	signal(SIGCLD,CloseChild);
}

int InitSignal()
{
	DB(fprintf(stderr,"InitSignal\n"));
	signal(SIGINT,CloseSocket);
	signal(SIGTERM,CloseSocket);
	signal(SIGCLD,CloseChild);

	return(0);
}

void CheckEntry(void)
{
	int	ret;
	int	len;
	socklen_t addrlen;
	

	addrlen = sizeof(struct sockaddr_in);
	ret = recvfrom(TrustDB_out, &RelayPacket, sizeof(RelayPacket), 0, 
		(struct sockaddr *)&db_out, &addrlen);
	if (ret > 0)
	{
		if (memcmp ((char *)&RelayPacket.dv.pkt.ID, "DSVT", 4) == 0)
		{
                        memset((char *)&db_in,0,sizeof(db_in));
                        db_in.sin_family = PF_INET;
                        db_in.sin_port = RelayPacket.dv.port;
                        db_in.sin_addr = RelayPacket.dv.ip;
			len = 27;
			if (RelayPacket.dv.pkt.B_header.seq == 0x80) len = 56;
                        sendto (TrustDB_out, &RelayPacket.dv.pkt, len, 0,
                                (struct sockaddr *)&db_in, sizeof(db_in));
		}
		else
		{
        		memset((char *)&db_in,0,sizeof(db_in));
        		db_in.sin_family = PF_INET;
        		db_in.sin_port = dbInPort;
        		db_in.sin_addr.s_addr = inet_addr("127.0.0.1");
			RelayPacket.send_msg.srcPort = db_out.sin_port;
			RelayPacket.send_msg.srcIP = db_out.sin_addr;
if (RelayPacket.send_msg.type != 0x44) printf ("TrustDB debug type=%2.2x port=%d IP=%s\n",RelayPacket.send_msg.type, ntohs(db_out.sin_port), inet_ntoa(db_out.sin_addr)); 
			if (RelayPacket.send_msg.dstCall[0] == '/')
			{
				memcpy (&RelayPacket.send_msg.dstCall[0], &RelayPacket.send_msg.dstCall[1], 6);
				RelayPacket.send_msg.dstCall[6] = 0x20;
			}
			sendto (TrustDB_in, &RelayPacket.send_msg, sizeof(struct shm_form), 0, 
				(struct sockaddr *)&db_in, sizeof(db_in));
		}
	}
}


void MainLoop(void)
{
	int	n;
	int	len,width, pid;
	fd_set	readOk,Mask;
	struct	timeval	timeout;
	char	client[64];

	DB(fprintf(stderr,"MainLoop\n"));

	FD_ZERO(&Mask);
	FD_SET(TrustDB_out, &Mask);
	FD_SET(cmdin, &Mask);
	width = TrustDB_out;
	if (width < cmdin) width = cmdin;
	width += 1;

	while(1){
		readOk = Mask;
		timeout.tv_sec = 1;
		timeout.tv_usec = 0;
		switch (select(width,(fd_set *)&readOk, NULL, NULL, &timeout)){
			case	-1:
				perror("select");
				break;
			case	0:
				break;
			default:
				if (FD_ISSET(TrustDB_out, &readOk)) {
					CheckEntry();
				}
				if(FD_ISSET(cmdin, &readOk)){
					KeyIn();
				}
				break;
		}
	}
}

int KeyIn(void)
{
	char	buf[128];

	read (cmdin, buf, sizeof(buf));

	DoKeyInCommand(buf);

	return(0);
}

int DoKeyInCommand(char *str)
{
	int	k, n;

	k = strlen(str);
	for (n = 0 ; n < k ; n++)
	{	
		if (str[n] == 0x0a) str[n] = 0x00;
		if (str[n] == 0x0d) str[n] = 0x00;
	}

	DB(fprintf(stderr,"(%s)\n",str));

	if (strlen(str))
	{
		if((strncmp(str,"end", strlen(str))==0) 
			|| strncmp(str, "exit", strlen(str)) == 0){
			killpg(getpid(),SIGTERM);
			CloseSocket();
			return(1);
		}
	}

	return(0);
}

