<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2soap.php 68 2006-04-01 14:27:55Z sakamoto $
 */
include_once(dirname(dirname(__FILE__)) . "/XMLogic/Visitor.class.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/XMLogic.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/SchemaFactory.class.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/WsdlFactory.class.php");
include_once(dirname(dirname(__FILE__)) . "/XMLogic/exportTextVisitor.class.php");

include_once(dirname(__FILE__) . "/ReflectionAccept.php");

include_once(dirname(dirname(__FILE__)) . "/Anno/Anno.php");
include_once(dirname(dirname(__FILE__)) . "/Anno/DocCommand.class.php");

include_once(dirname(__FILE__) . "/class2soapVisitor.class.php");
include_once(dirname(__FILE__) . "/class2xsdVisitor.class.php");
include_once(dirname(__FILE__) . "/class2SoapXsdVisitor.class.php");
include_once(dirname(__FILE__) . "/class2wsdlVisitor.class.php");
include_once(dirname(__FILE__) . "/ElementType.class.php");

/**
 * NXWSDLf[^ւ̕ϊpNX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2wsdl {
    private $visitor;

    function __construct($class_name, $target_uri, $location)
    {
        $this->visitor = new AutoSOAP_class2wsdlVisitor();
        $this->visitor->init($target_uri, $class_name, $location);
        $target = new AutoSOAP_ReflectionAcceptImpl(new ReflectionClass($class_name));

        $target->accept($this->visitor);
    } 
    function getResult($to_encoding = null, $from_encoding = null)
    {
        return $this->visitor->getResult($to_encoding, $from_encoding);
    } 

    /**
     * NX}bvԂ
     */
    public function getClassmap()
    { 
        // NX}bvĂ
        return $classmap = $this->visitor->getClassmap();
    } 
} 

/**
 * NXSOAPbZ[WؗpXSDf[^ւ̕ϊNX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2SoapXsd {
    private $visitor;

    function __construct($class_name, $target_uri, $soapenv_uri = null, $soapenc_uri = null)
    {
        $this->visitor = new AutoSOAP_class2SoapXsdVisitor();
        $this->visitor->init($target_uri, $soapenv_uri, $soapenc_uri);
        $target = new AutoSOAP_ReflectionAcceptImpl(new ReflectionClass($class_name));

        $target->accept($this->visitor);
    } 
    function getResult($to_encoding = null, $from_encoding = null)
    {
        return $this->visitor->getResult($to_encoding, $from_encoding);
    } 

    /**
     * NX}bvԂ
     */
    public function getClassmap()
    { 
        // NX}bvĂ
        return $classmap = $this->visitor->getClassmap();
    } 
} 

?>