<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: DocCommand.class.php 77 2006-04-09 15:57:21Z sakamoto $
 */

/**
 * ҖԂ
 * Ԓl̃tH[}bg
 * array(
 *   0 =>array(Җ1,'[AhX1'),
 *   1 =>array(Җ2,'[AhX2'),
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode author
 * @format Җ<[AhX>
 */
class AutoSOAP_Anno_AuthorCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'author';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/([^\<\>\r\n]+)\s*(?:<([^\<\>\r\n]+@[^\<\>\r\n]+)>)?/i", $value, $matchs)) {
            $this->result[] = array($matchs[1], $matchs[2]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * pbP[WԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode package
 * @format pbP[W
 */
class AutoSOAP_Anno_PackageCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'package';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * TupbP[WԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode subpackage
 * @format TupbP[W
 */
class AutoSOAP_Anno_SubpackageCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'subpackage';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * JeS[pXԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode category
 * @format JeS[pX
 */
class AutoSOAP_Anno_CategoryCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'category';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * Rs[CgԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode copyright
 * @format Rs[Cg
 */
class AutoSOAP_Anno_CopyrightCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'copyright';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * CZXԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode license
 * @format CZX
 */
class AutoSOAP_Anno_LicenseCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'license';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * TodoԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode todo
 * @format TodoRg
 */
class AutoSOAP_Anno_TodoCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'todo';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * NԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode link
 * @format N
 */
class AutoSOAP_Anno_LinkCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'link';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * `[gAԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode tutorial
 * @format N
 */
class AutoSOAP_Anno_TutorialCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'tutorial';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * o[WԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode version@
 * @format o[W
 */
class AutoSOAP_Anno_VersionCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'version';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ǂ̃o[W瑶݂Ă̂Ԃ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode since
 * @format o[W
 */
class AutoSOAP_Anno_SinceCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'since';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * QƐԂ
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode see@
 * @format ֘A֐
 */
class AutoSOAP_Anno_SeeCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'see';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result[] = $value;
    } 
} 

/**
 * p~LĂꍇtrueԂA͒uAPIԂB
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode deprecated@
 * @format Rg
 */
class AutoSOAP_Anno_DeprecatedCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'deprecated';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = ('' == $value) ? true : $value;
    } 
} 

/**
 * I[oCg֎~̗LԂ
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode final@
 * @format 
 */
class AutoSOAP_Anno_FinalCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'final';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * ÓIȂ̂Ԃ
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode static@
 * @format 
 */
class AutoSOAP_Anno_StaticCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'static';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * 邩Ԃ
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode ignore@
 * @format 
 */
class AutoSOAP_Anno_IgnoreCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'ignore';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * AbstractNXԂ
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode abstract
 * @format 
 */
class AutoSOAP_Anno_AbstractCmd implements AutoSOAP_Anno_Command {
    private $result = false;
    public function getCode()
    {
        return 'abstract';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $this->result = true;
    } 
} 

/**
 * p[^AzzŕԂ
 * Ԓl̃tH[}bg
 * array(
 *   p[^1=>array('^','Rg'),
 *   p[^2=>array('^','Rg'),
 *   p[^3=>array('^','Rg'),
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode param
 * @format ^ p[^ Rg
 */
class AutoSOAP_Anno_ParamCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'param';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = array($matchs[1], $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * Tvt@CꏊԂ
 * array(
 *   0 => array('t@CpX','Rg'),
 *   1 => array('t@CpX','Rg'),
 *     .
 *     .
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode example
 * @format t@CpX Rg
 */
class AutoSOAP_Anno_ExampleCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'example';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[] = array($matchs[1], $matchs[2]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * O[oϐ̏Ԃ
 * array(
 *   'ϐ' => array('^','Rg'),
 *   'ϐ' => array('^','Rg'),
 *     .
 *     .
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode global
 * @format ^ ϐ Rg
 */
class AutoSOAP_Anno_GlobalCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'global';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = array($matchs[1], $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ÓIϐ̏Ԃ
 * array(
 *   'ϐ' => array('^','Rg'),
 *   'ϐ' => array('^','Rg'),
 *     .
 *     .
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode staticvar
 * @format ^ ϐ Rg
 */
class AutoSOAP_Anno_StaticvarCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'staticvar';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = array($matchs[1], $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * pÕNXNX̕ϐԂ
 * array(
 *   'NX' => 'Rg',
 *   'ϐ' => 'Rg',
 *     .
 *     .
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode uses
 * @format ϐ Rg
 */
class AutoSOAP_Anno_UsesCmd implements AutoSOAP_Anno_Command {
    private $result = array();
    public function getCode()
    {
        return 'uses';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[$matchs[1]] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ϐ̌^Ԃ
 * array(
 *   0 => '^',
 *   1 => 'Rg',
 *   )
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode var
 * @format ^ Rg
 */
class AutoSOAP_Anno_VarCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'var';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[0] = $matchs[1];
            $this->result[1] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * Ԃ
 * array(
 *    Ώۂ̕ϐ(Ȃ'') => ,
 *       E
 *       E
 *       E
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode restriction_name
 * @format 
 */
class AutoSOAP_Anno_RestrictionNameCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'restriction_name';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(?:(\S*)@)?(\S+)/i", $value, $matchs)) {
            $this->result[$matchs[1]] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * V^ƔhԂ
 * array(
 *     => ^,
 *       E
 *       E
 *       E
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode restriction_type
 * @format ^ 
 */
class AutoSOAP_Anno_RestrictionTypeCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'restriction_type';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(\S+)\s+(\S+)/i", $value, $matchs)) {
            $this->result[$matchs[2]] = $matchs[1];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * Ԃ
 * array(
 *    Ώۂ̕ϐ(Ȃ'') => array(
 *      0 => array(
 *        @ => l
 *      ),
 *      1 => array(
 *        @ => l
 *      ),
 *       E
 *       E
 *       E
 *   )
 *   : 
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode restriction
 * @format [^[Qbg@]@ l
 */
class AutoSOAP_Anno_RestrictionCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'restriction';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (preg_match("/^(?:(\S*)@)?(\S+)\s+(.+)/i", $value, $matchs)) {
            $this->result[$matchs[1]][] = array($matchs[2] => $matchs[3]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ԒlԂB
 * Ԓl̃tH[}bg
 * array(
 *   0 => array('^','^','^',...),
 *   1 => 'Rg'
 *   )
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode return@
 * @format Ԓľ^(or l)|Ԓľ^(or l)... Rg
 */
class AutoSOAP_Anno_ReturnCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'return';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/^(\S+)\s*(.*)/i", $value, $matchs)) {
            $this->result[0] = explode('|', $matchs[1]);
            $this->result[1] = $matchs[2];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ANZXCqԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode access
 * @format ANZXCq(private|protected|public)
 */
class AutoSOAP_Anno_AccessCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'access';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(private|protected|public)/i", $value, $matchs)) {
            $this->result = strtolower($matchs[1]);
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 

/**
 * ؎̃G[bZ[WԂ
 *   : s
 * 
 * @package jp.servlet.AutoSOAP.Anno
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @commandcode validate_error
 * @format G[bZ[W
 */
class AutoSOAP_Anno_ValidateErrorCmd implements AutoSOAP_Anno_Command {
    private $result = null;
    public function getCode()
    {
        return 'validate_error';
    } 
    public function getResult()
    {
        return $this->result;
    } 
    public function execute($value)
    {
        $matchs = array();
        if (!is_null($this->result)) {
            trigger_error('It has already been set.(' . __CLASS__ . ')', E_USER_WARNING);
        } else if (preg_match("/(?:\S.*)/i", $value, $matchs)) {
            $this->result = $matchs[0];
        } else {
            trigger_error('It failed in the match.(' . __CLASS__ . ')', E_USER_WARNING);
        } 
    } 
} 
?>