<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2wsdlVisitor.class.php 78 2006-04-11 13:51:37Z sakamoto $
 */

/**
 * NXWSDLf[^ւ̕ϊprW^[NX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2wsdlVisitor implements AutoSOAP_ReflectionVisitor {
    // SOAPf[^Ǘ
    private $_class2soap; 
    // WSDL̊ep[c
    private $_portType;
    private $_binding;
    private $_service; 
    // ؎̃G[bZ[W}bv
    private $_ValidateErrorMap = array();

    /**
     * 
     */
    public function init($target_uri, $wsdl_name, $location)
    {
        $wsdl = AutoSOAP_XMLogic_WsdlFactory :: getInstance(); 
        // XMLXL[}^ONX
        $schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();

        /**
         * WSDL̑g̍쐬
         */ 
        // Root
        $root = $wsdl -> createRoot($target_uri); 
        // Types
        $types = $wsdl -> createTypes();
        $root -> add($types); 
        // Types_Schema
        $types_schema = $schema -> createRoot($target_uri);
        $types -> add($types_schema); 
        // portType
        $this -> _portType = $wsdl -> createPortType($wsdl_name . '_portType');
        $root -> add($this -> _portType); 
        // Binding
        $this -> _binding = $wsdl -> createBinding($wsdl_name . '_Binding', $wsdl_name . '_portType', $target_uri, AutoSOAP_XMLogic_WsdlFactory :: XMLNS_HTTP);
        $root -> add($this -> _binding); 
        // Service
        $this -> _service = $wsdl -> createService($wsdl_name . '_Service', $wsdl_name . '_Binding', $target_uri, $location);
        $root -> add($this -> _service);

        $class2xsd = new AutoSOAP_class2xsdVisitor();
        $class2xsd -> init($types_schema, $wsdl); 
        
        $this -> _class2soap = new AutoSOAP_class2soap($target_uri, $root, $class2xsd);
    } 

    /**
     * ʂԂ
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        return $this -> _class2soap -> getResult($to_encoding, $from_encoding);
    } 

    /**
     * q
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children)
    {
        return AutoSOAP_class2soap :: visitChildren($this, $children);
    } 

    /**
     * NX
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class)
    {
        $wsdl = AutoSOAP_XMLogic_WsdlFactory :: getInstance();

        /**
         * C^[tF[XV^CN[h
         */
        $this -> _class2soap -> createNewTypes($class);

        /**
         * Rg̎擾
         */ 
        // $annotation = AutoSOAP_Anno :: parseReflector($class);
        // $this->_class2soap->appendXML($wsdl->createDoc(trim($annotation->getComment())),0);
        // $this->_service->add($wsdl->createDoc($annotation->getComment()),0);
        // \bhǉ
        $class -> getMethods() -> accept($this);
    } 

    /**
     * \bh
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method)
    {
        if (!$this -> _class2soap -> createMethodInfo($method)) {
            return ;
        } 

        $wsdl = AutoSOAP_XMLogic_WsdlFactory :: getInstance();
        $method_name = $method -> getName();

        /**
         * ؎̃G[bZ[W擾
         */
        $validate_error = $this -> _class2soap -> getValidateError();
        if (!is_null($validate_error))
            $this -> _ValidateErrorMap[$method_name] = $validate_error;

        /**
         * NGXg\bhǉ
         */
        $request_name = $method_name . "Request";
        $request = $wsdl -> createMessage($request_name); 
        // p[^ǉ
        $parameters = $method -> getParameters() -> accept($this);
        if (0 < count($parameters)) {
            foreach($parameters as $param) {
                $request -> add($param);
            } 
        } 
        $this -> _class2soap -> appendXML($request, 1);

        /**
         * X|X\bhǉ
         */
        $response_name = $method_name . "Response";
        $response = $wsdl -> createMessage($response_name);
        $response -> add($this -> getMessagePort('return', $this -> _class2soap -> getReturnInfo()));
        $this -> _class2soap -> appendXML($response, 2);

        /**
         * portType֒ǉ
         */
        $this -> _portType -> add($wsdl -> createOperationOfPortType($method_name,
                $request_name,
                $response_name,
                $this -> _class2soap -> getTargetURI())
            );

        /**
         * binding֒ǉ
         */
        $this -> _binding -> add($wsdl -> createOperationOfBinding($method_name,
                (0 < strlen($request_name)),
                (0 < strlen($response_name)),
                $this -> _class2soap -> getTargetURI())
            );
    } 

    /**
     * 
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param)
    {
        $elemType = $this -> _class2soap -> getParameterInfo($param -> getName());
        $options = AutoSOAP_class2soap :: getParamOptions($param);

        return $this -> getMessagePort($param -> getName(), $elemType, $options);
    } 

    /**
     * vpeB
     */
    public function visitProperty(AutoSOAP_ReflectionAccept $property)
    {
    } 
    /**
     * ֐
     */
    public function visitFunction(AutoSOAP_ReflectionAccept $func)
    {
    } 
    /**
     * IuWFNg
     */
    public function visitObject(AutoSOAP_ReflectionAccept $object)
    {
    } 
    /**
     * GNXeV
     */
    public function visitExtension(AutoSOAP_ReflectionAccept $extension)
    {
    } 

    /**
     * bZ[W|[g̃GgԂB
     */
    private function getMessagePort($name, AutoSOAP_ElementType $elemType, $options = null)
    {
        $wsdl = AutoSOAP_XMLogic_WsdlFactory :: getInstance();
        $info = $this -> _class2soap -> getElementInfo($name, $elemType, $options);
        return $wsdl -> createPart($info['name'], $info['datatype'], $info['namespace'], $options);
    } 

    /**
     * SOAPf[^ǗԂ
     */
    public function getClass2soap()
    {
        return $this -> _class2soap;
    } 

    /**
     * ؎̃G[bZ[W}bvԂ
     */
    public function getValidateErrorMap()
    {
        return $this -> _ValidateErrorMap;
    } 
} 

?>