<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: SchemaFactory.class.php 78 2006-04-11 13:51:37Z sakamoto $
 */

/**
 * XML Schame̐ɕKvȃp[c𐶐ׂFactoryNXł
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_SchemaFactory {
    const XMLNS_XSD = "http://www.w3.org/2001/XMLSchema";

    private static $instance;
    private $_fctry;

    private function __construct()
    {
        $this -> _fctry = AutoSOAP_XMLogic_XMLFactory :: getInstance();
    } 

    public static function getInstance()
    {
        if (self :: $instance == null) {
            self :: $instance = new AutoSOAP_XMLogic_SchemaFactory();
        } 
        return self :: $instance;
    } 

    /**
     * [g𐶐
     */
    public function createRoot($targetnamespace)
    {
        $tmp = $this -> _fctry -> node("schema", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> xmlns('xsd', self :: XMLNS_XSD));
        $tmp -> add($this -> _fctry -> xmlns('tns', $targetnamespace));
        $tmp -> add($this -> _fctry -> attr("targetNamespace", $targetnamespace));

        return $tmp;
    } 

    /**
     * C|[g𐶐
     */
    public function createImport($namespace, $schemaLocation)
    {
        $tmp = $this -> _fctry -> node("import", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr('namespace', $namespace));
        $tmp -> add($this -> _fctry -> attr("schemaLocation", $schemaLocation));

        return $tmp;
    } 

    /**
     * XL[}̃Gg𐶐
     */
    public function createElement($name, $type = null, $namespace = null, $options = null)
    {
        if (is_null($namespace))
            $namespace = self :: XMLNS_XSD;
        $tmp = $this -> _fctry -> node("element", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr('name', $name));
        if (0 < strlen($type))
            $tmp -> add($this -> _fctry -> attr("type", array($type, $namespace)));

        if (true === $options['default']) {
            $tmp -> add($this -> _fctry -> attr('minOccurs', '0'));
        } 

        return $tmp;
    } 

    /**
     * ComplexType𐶐
     */
    public function createComplexType($name)
    {
        $tmp = $this -> _fctry -> node("complexType", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr('name', $name));

        return $tmp;
    } 

    /**
     * complexContent𐶐
     */
    public function createComplexContent()
    {
        return $this -> _fctry -> node("complexContent", self :: XMLNS_XSD);
    } 

    /**
     * SimpleType𐶐
     */
    public function createSimpleType($name = null)
    {
        $tmp = $this -> _fctry -> node("simpleType", self :: XMLNS_XSD);
        if (0 < strlen($name))
            $tmp -> add($this -> _fctry -> attr('name', $name));

        return $tmp;
    } 

    /**
     * gx[X𐶐
     */
    public function createExtensionBase($base, $namespace = null)
    {
        if (is_null($namespace))
            $namespace = self :: XMLNS_XSD;
        $tmp = $this -> _fctry -> node("extension", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr("base", array($base, $namespace)));

        return $tmp;
    } 

    /**
     * x[X𐶐
     */
    public function createRestrictionBase($base, $namespace = null)
    {
        if (is_null($namespace))
            $namespace = self :: XMLNS_XSD;
        $tmp = $this -> _fctry -> node("restriction", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr("base", array($base, $namespace)));

        return $tmp;
    } 

    /**
     * 𐶐
     */
    public function createRestriction($name, $value)
    {
        $tmp = $this -> _fctry -> node($name, self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr('value', $value));

        return $tmp;
    } 

    /**
     * anyAttribute𐶐
     */
    public function createAnyAttribute($namespace, $processContents)
    {
        $tmp = $this -> _fctry -> node("anyAttribute", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr('namespace', $namespace));
        $tmp -> add($this -> _fctry -> attr("processContents", $processContents));

        return $tmp;
    } 

    /**
     * Attribute𐶐
     */
    public function createAttributeRef($ref, $namespace = null)
    {
        if (is_null($namespace))
            $namespace = self :: XMLNS_XSD;
        $tmp = $this -> _fctry -> node("attribute", self :: XMLNS_XSD);
        $tmp -> add($this -> _fctry -> attr("ref", array($ref, $namespace)));

        return $tmp;
    } 

    /**
     * sequence𐶐
     */
    public function createSequence()
    {
        return $this -> _fctry -> node("sequence", self :: XMLNS_XSD);
    } 

    /**
     * z^̃Gg𐶐
     */
    function createArray($name, $type, $namespace, $min_count, $max_count)
    {
        $tmp = $this -> createComplexType($name);
        $seq = $this -> createSequence();
        $element = $this -> createElement('item', $type, $namespace); 
        // $element = $this->createElement($type,$type,$namespace);
        if (0 < $min_count)
            $element -> add($this -> _fctry -> attr('minOccurs', $min_count));
        $element -> add($this -> _fctry -> attr('maxOccurs', ((1 > $max_count)?'unbounded':$max_count)));

        $seq -> add($element);
        $tmp -> add($seq);

        $tmp -> add($this -> createAnyAttribute("##other", "lax"));

        return $tmp;
    } 
} 

?>
