<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: ElementType.class.php 93 2006-04-16 15:23:57Z sakamoto $
 */

/**
 * アノテーションを利用した型の情報
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ElementType {
    private $properties;
	
	public function __construct($properties=null)
	{
	    $this->properties = (is_array($properties)) ? $properties : array();
	}
	
	public function __get($name)
	{
	    return 	(isset($this->properties[$name])) ? $this->properties[$name] : null;
	}
	
	/**
	 * プロパティのアノテーションから型の情報を生成する
	 */
	static public function createByProperty($annotation)
	{
	    $properties = array();
	    
        // 型を取得
        $anno_var = $annotation->execute(new AutoSOAP_Anno_VarCmd());
        $properties['datatype'] = (is_array($anno_var)) ? $anno_var[0] : null; 
        // 制限を取得
        $tmp = $annotation->execute(new AutoSOAP_Anno_RestrictionCmd());
        $properties['restriction'] = $tmp[''];
        
        return new AutoSOAP_ElementType($properties);
	}
	
	/**
	 * メソッドのアノテーションから型の情報を生成する
	 */
	static public function createByMethod($annotation)
	{
        // 型情報を取得
        $types = $annotation->execute(new AutoSOAP_Anno_ParamCmd()); 
        // パラメータの制限を取得
        $restrictions = $annotation->execute(new AutoSOAP_Anno_RestrictionCmd()); 
        // 返値情報を取得
        $return = $annotation->execute(new AutoSOAP_Anno_ReturnCmd());
 
        $result = array();
        if(is_array($types)) {
            foreach($types as $param => $type) {
	            $properties = array();
	            $properties['datatype'] = $type[0];
	            $properties['restriction'] = (isset($restrictions[$param])) ? $restrictions[$param] : null ;
	            $result[$param] = new AutoSOAP_ElementType($properties);
            }
        }
        $return_prty = array();
	    $return_prty['datatype'] = null;
	    if (is_array($return)) {
            $return_types = $return[0]; 
            // 型指定が１パターン以外はすべてNULLにする
            if (1 == count($return_types)) {
                $return_prty['datatype'] = $return_types[0];
            } 
        } 
	    
	    $return_prty['restriction'] = (isset($restrictions['#return'])) ? $restrictions['#return'] : null ;
        $result['#return'] = new AutoSOAP_ElementType($return_prty);
        
        return $result;
	}
	
	/**
	 * クラスのアノテーションから型の情報を生成する
	 */
	static public function createByClass($annotation)
	{
        // 新しい型情報を取得
        $types = $annotation->execute(new AutoSOAP_Anno_RestrictionTypeCmd()); 
        // パラメータの制限を取得
        $restrictions = $annotation->execute(new AutoSOAP_Anno_RestrictionCmd()); 
        // 返値情報を取得
        $return = $annotation->execute(new AutoSOAP_Anno_ReturnCmd());
 
        $result = array();
        if(is_array($types)) {
            foreach($types as $newtype => $type) {
	            $properties = array();
	            $properties['datatype'] = $type;
	            $properties['restriction'] = (isset($restrictions['#'.$newtype])) ? $restrictions['#'.$newtype] : null ;
	            $result[$newtype] = new AutoSOAP_ElementType($properties);
            }
        }
        
        return $result;
	}
}
?>