<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2SoapXsdVisitor.class.php 97 2006-04-23 10:05:16Z sakamoto $
 */

/**
 * クラス→SOAPメッセージ検証用XSDデータへの変換用ビジタークラス
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2SoapXsdVisitor implements AutoSOAP_ReflectionVisitor {
    // SOAPデータ生成管理
    private $_class2soap;

    // エンコード
    private $_encoding = null;

    /**
     * 初期化
     */
    public function init($target_uri, $soapenv_uri = null, $soapenc_uri = null)
    {
        $schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();

        /**
         * XSDの大枠の作成
         */
        $root = $schema -> createRoot($target_uri);
        $class2xsd = new AutoSOAP_class2xsdVisitor();
        $class2xsd -> init($root);

        /**
         * SOAPエンブローブスキーマをインポート
         */
        $xml = AutoSOAP_XMLogic_XMLFactory :: getInstance();
        if (is_null($soapenv_uri))
            $soapenv_uri = AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV;
        if (is_null($soapenc_uri))
            $soapenc_uri = AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC;
        $root -> add($schema -> createImport(AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV, $soapenv_uri));
        $root -> add($xml -> xmlns('soapenv', AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV));

        $root -> add($schema -> createImport(AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC, $soapenc_uri));
        $root -> add($xml -> xmlns('soapenc', AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC)); 
        
        $this -> _class2soap = new AutoSOAP_class2soap($target_uri, $root, $class2xsd);
    } 

    /**
     * 結果を返す
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        $encoding = (is_null($from_encoding)) ? $this->_encoding : $from_encoding;
        return $this -> _class2soap -> getResult($to_encoding, $from_encoding);
    } 

    /**
     * 子を処理する
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children)
    {
        return AutoSOAP_class2soap :: visitChildren($this, $children);
    } 

    /**
     * クラスを処理する
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class)
    {
        /**
         * インターフェースから新しい型をインクルードする
         */
        $this -> _class2soap -> createNewTypes($class); 

        /**
         * アノテーションの取得
         */ 
        $annotation = AutoSOAP_Anno :: parseReflector($class);

        // エンコードを取得
        $this->_encoding = $annotation->execute(new AutoSOAP_Anno_EncodingCmd()); 

        // 新しい型の取得
        $elemTypes = AutoSOAP_ElementType :: createByClass($annotation);
        foreach($elemTypes as $newtype => $elemType) {
            $this -> _class2soap -> getElementInfo('', $elemType, array('new_type' => $newtype));
        }

        // メソッド追加
        $class -> getMethods() -> accept($this);
    } 

    /**
     * メソッドを追加する
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method)
    {
        if (!$this -> _class2soap -> createMethodInfo($method)) {
            return ;
        } 

        $method_name = $method -> getName(); 
        // XMLスキーマタグ生成クラス
        $schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();

        /**
         * リクエストメソッド追加
         */
        $request_name = $method_name . "Request";
        $request = $schema -> createComplexType($request_name);

        /**
         * パラメータ追加
         */
        $parameters = $method -> getParameters() -> accept($this);
        if (0 < count($parameters)) {
            $seq = $schema -> createSequence();
            foreach($parameters as $param) {
                $seq -> add($param);
            } 
            $request -> add($seq);
        } 
        $request -> add($schema -> createAnyAttribute("##other", "lax"));
        $this -> _class2soap -> appendXML($request);

        /**
         * 別名も追加しておく
         */
        $alias = $schema -> createComplexType($method_name);
        $alias_tmp = $schema -> createComplexContent();
        $alias_tmp -> add($schema -> createExtensionBase($request_name, $this -> _class2soap -> getTargetURI()));
        $alias -> add($alias_tmp);
        $this -> _class2soap -> appendXML($alias);

        /**
         * レスポンスメソッド追加
         */
        $response_name = $method_name . "Response";
        $response = $this -> _class2soap -> getDataTypeElement($response_name, $this -> _class2soap -> getReturnInfo());
        $this -> _class2soap -> appendXML($response);
    } 

    /**
     * 引数を処理する
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param)
    {
        $elemType = $this -> _class2soap -> getParameterInfo($param -> getName());
        $options = AutoSOAP_class2soap :: getParamOptions($param);

        return $this -> _class2soap -> getDataTypeElement($param -> getName(), $elemType, $options);
    } 

    /**
     * プロパティを処理する
     */
    public function visitProperty(AutoSOAP_ReflectionAccept $property)
    {
    } 
    /**
     * 関数を処理する
     */
    public function visitFunction(AutoSOAP_ReflectionAccept $func)
    {
    } 
    /**
     * オブジェクトを処理する
     */
    public function visitObject(AutoSOAP_ReflectionAccept $object)
    {
    } 
    /**
     * エクステンションを処理する
     */
    public function visitExtension(AutoSOAP_ReflectionAccept $extension)
    {
    } 

    /**
     * SOAPデータ生成管理を返す
     */
    public function getClass2soap()
    {
        return $this -> _class2soap;
    } 
} 

?>