<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id$
 */

/**
 * フレームワークテストファンクション
 * 
 * @package jp.servlet.AutoSOAP.Framework
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Framework_TestFunction {
    public $func;
    private $return;
    private $param;
    private $types;
    private $cookies;

	public function __construct($func_str, $types) {
	    $matches = array();
	    if (preg_match("/^(\S+)\s+(\S+)\((.*)\)$/i", $func_str,$matches)) {
		    $this->types = $types;
		    $this->return = $matches[1];
		    $this->func   = $matches[2];
		    $tmp = explode(', ', $matches[3]);
		    
		    $this->param = array();
		    foreach($tmp as $val) {
			    $tmp2 = explode(' $',$val);
			    if (0<strlen($tmp2[1])) {
			    	$this->param[$tmp2[1]] = $tmp2[0];
			    }
		    }
	    }
    }
    
	public function execute(&$client, &$post, &$files) {
	    try {
		    $func_param = array();
		    foreach($this->param as $key=>$type) {
			    $basetype = $this->getBaseType($type);
			    if( preg_match("/Binary/i",$basetype)) {
			        $func_param[$key] = file_get_contents($files[$key]['tmp_name']);
			    } else {
			        $func_param[$key] = $post[$key];
			    }
		    }
		    $result = call_user_func_array(array($client,$this->func), $func_param);
	    } catch (Exception $e) {
		    $result = "<font color=red>Error!!</font><br>".$e->faultstring;
		    return $result;
	    }
	    $headers = $client->__getLastResponseHeaders();
	    $matches1 = array();
	    $matches2 = array();
	    if (preg_match("/^Set-Cookie:\s([^\r\n]*)/im", $headers, $matches1)) {
		    if( preg_match_all("/([^=]+)=([^;]*);?\s*/i",$matches1[1], $matches2, PREG_SET_ORDER)) {
		    $_SESSION['soap_session'] = array();
		    foreach($matches2 as $cookie) {
		          $_SESSION['soap_session'][$cookie[1]] = $cookie[2];
		    }
	    }
    }
    
    return var_export($result, true);
    }
    
    public function output() {
	    AutoSOAP_Framework_TestContents::testForm($this, get_object_vars($this));
    }
    
    /**
     * 
     */
    public function getBaseType($type) {
        if (isset($this->types[$type])) {
            return $this->getBaseType($this->types[$type], $this->types);
        }
        return $type;
    }

    /**
     * 
     */
    public function isArrayType($type) {
        if(isset($this->types[$type.'[]'])) {
            return true;
        }
        if (isset($this->types[$type])) {
            return $this->isArrayType($this->types[$type], $this->types);
        }
        return false;
    }
}
?>