<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: ServiceFactory.class.php 119 2006-04-27 09:43:28Z sakamoto $
 */

/**
 * 簡易的なサービス生成ファクトリー
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ServiceFactory {
    private $services_dir;
    private $wsdls_dir;
    private $xsds_dir;
    private $options_dir;

    public function __construct($services_dir, $wsdls_dir, $xsds_dir, $options_dir)
    {
        $this->services_dir = $services_dir . '/';
        $this->wsdls_dir    = $wsdls_dir . '/';
        $this->xsds_dir     = (is_null($xsds_dir)) ? null : $xsds_dir . '/';
        $this->options_dir  = $options_dir . '/';
    }

    public function getService($service_path, $location, $timestamp=null, $namehead='')
    {
        $matches = array();
        if (preg_match("/[\/@\;\: ]/", $service_path)) {
            trigger_error("Parse Error!!", E_USER_ERROR);
            return null;
        }
        
        $class_name  = preg_replace("/[\.]+/","_",$service_path);
        $class_path  = $this->services_dir . str_replace("_", "/", $class_name) . '.service.php';

        $wsdl_path   = $this->wsdls_dir . $namehead . $class_name . ".wsdl";
        $xsd_path    = (is_null($this->xsds_dir)) ? null : $this->xsds_dir  . $namehead . $class_name . ".xsd";
        $option_path = $this->options_dir . $namehead . $class_name . ".option.php";

        return new AutoSOAP_Service($class_name,
            $class_path,
            $wsdl_path,
            $xsd_path,
            $option_path,
            $location,
            $location,
            $timestamp
            );
    }
    
    public function getInfo() {
        return get_object_vars($this);
    }
} 

?>