<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Uploader.service.php 103 2006-04-24 14:05:08Z sakamoto $
 */

include_once("AutoSOAP/Types/Io.type.php");

/**
 * ファイルアップローダ
 *
 * @package jp.servlet.AutoSOAP.Services.io
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @encoding UTF-8
 * @rtype hexBinary UploadData
 * @r              #UploadData@maxLength 1073741824
 */
class AutoSOAP_Services_io_uploader implements AutoSOAP_Types_Io {
    static $__const;
    static $__sess;
    
    private $_base_dir;
    private $_current_dir;
    
    public function __construct() {
    		if (!self::$__const->defined('chroot')) {
            trigger_error("The constant of AutoSOAP_Define::_(".__CLASS__.")->'chroot' is not defined.", E_USER_ERROR);
            return ;
        }
        $this->_base_dir = realpath(self::$__const->chroot).'/';
        if (false===$this->_base_dir) {
            trigger_error("The directory doesn't exist.",E_USER_ERROR);
        }
        if (is_null(self::$__sess->current_dir)) {
            self::$__sess->current_dir = $this->_base_dir;
        }
    }
    
    /**
     * @param #FileName $file_name
     * @param #UploadData $data
     * @return int
     */
    public function touch($file_name, $data) {
        $dir = dirname($file_name);
        $real_path = $this->getPath($dir);
        if (false===$real_path) {
            trigger_error("The directory doesn't exist.",E_USER_ERROR);
            return false;
        }

        $real_path .= '/';

        if (strlen($real_path)>=strlen($this->_base_dir)) {
            return file_put_contents($real_path.$file_name, $data);
        }
        trigger_error("The file doesn't saved.",E_USER_ERROR);
        return false;
    }    
    
    /**
     * @param #FilePath $dir
     * @return boolean
     */
    public function cd($dir) {
        $real_path = realpath(self::$__sess->current_dir.$dir);
        if (false===$real_path) {
            trigger_error("The directory doesn't exist.",E_USER_ERROR);
            return false;
        }

        $real_path .= '/';

        self::$__sess->current_dir = (strlen($real_path)>strlen($this->_base_dir)) ? $real_path : $this->_base_dir ;
        
        return true;
    }    
    
    /**
     * @param #FilePath $dir
     * @param boolean $flg_cd
     * @return boolean
     */
    public function mkdir($dir,$flg_cd) {
        $real_path = $this->getPath($dir."/");
        if (false!==$real_path) {
            trigger_error("The directory already exists.",E_USER_ERROR);
            return false;
        }
        
        $real_path = $this->getPath($dir.'/../');
        if (false===$real_path) {
            trigger_error("The directory cannot be created.",E_USER_ERROR);
            return false;
        }
        $real_path .= '/'.basename($dir);
        
        if (strlen($real_path)>strlen($this->_base_dir)) {
            $result = mkdir($real_path);
            if ($result && $flg_cd) {
                self::$__sess->current_dir = $real_path.'/' ;
            }
            return $result;
        }

        trigger_error("The directory cannot be created.",E_USER_ERROR);
        return false;
    }
    
    /**
     * @param #FilePath $dir
     * @return boolean
     */
    public function rmdir($dir) {
        $real_path = $this->getPath($dir);
        if (false===$real_path) {
            trigger_error("The directory doesn't exist.",E_USER_ERROR);
            return false;
        }
        
        $real_path .= '/';
        
        if (strlen($real_path)>strlen($this->_base_dir)) {
            return rmdir($real_path);
        }
        trigger_error("The directory cannot be deleted.",E_USER_ERROR);
        return false;
    }    

    /**
     * @param #FilePath $dir
     * @return anyType
     */
    public function ls($dir=null) {
        $real_path = $this->getPath($dir);
        if (false===$real_path) {
            trigger_error("The directory doesn't exist.",E_USER_ERROR);
            return null;
        }
        
        $real_path .= '/';
        
        if (strlen($real_path)>=strlen($this->_base_dir)) {
            $result = array();
            $result['dirs'] = array();
            $result['files'] = array();
            $d = dir($real_path);
            while (false !== ($entry = $d->read())) {
                if (is_file($real_path.$entry)) {
                    $result['files'][] = $entry;
                } else {
                    $result['dirs'][] = $entry;
                }
            }
            $d->close();
            
            return $result;
        }
        
        trigger_error("The directory cannot be accessed.",E_USER_ERROR);
        return null;
    }    

    private function getPath($dir) {
        if ('/'==substr($dir,0,1)) {
            $real_path = realpath($this->_base_dir.$dir);
        } else {
            $real_path = realpath(self::$__sess->current_dir.$dir);
        }
        return $real_path;
    }
}
?>
