<?php
include_once("AutoSOAP/Framework.class.php");

$framework = AutoSOAP_Framework::getInstance(dirname(__FILE__)."/data/");

//初期化
init_framework($framework);

//開発環境にしておく
settingDebugMode($framework);

// 初期化処理
function init_framework(&$framework)
{
    // エイリアス設定
    $alias = array(
      "info"=>"AutoSOAP.Services.Core.Framework", //リネーム
      "/^auto\.(.*)/"=>"AutoSOAP.Services.$1", //サービスの頭がautoならAutoSOAP.Servicesを利用する
      //"/.*/"=>"",     // すべてのサービスを拒否
      "/(.*)/"=>"$1", // すべてのサービスを許可
    );
    $framework->setAlias($alias);
}

// 開発環境として動かす
function settingDebugMode(&$framework)
{
    // タイムスタンプ設定(常にファイルが生成されるように設定)
    //date_default_timezone_get('GMT');
    //$framework->setTimestamp(date("Y/m/d H:i:s"));
    
    // フィルター設定
    //$framework->appendAutoSOAPFilter("traceResponse");
    
    // ロギング設定
    //include_once("AutoSOAP/FileLogger.class.php");
    //$framework->setLogger(new AutoSOAP_FileLogger($framework->getVarDir() . 'logs/'));

    //定数定義
    //$tmp = AutoSOAP_Define::_('AutoSOAP_Filters_traceResponse');
    //$tmp->define('output_dir',$framework->getVarDir());
    $tmp = AutoSOAP_Define::_('AutoSOAP_Services_io_uploader');
    $tmp->define('chroot',$framework->getVarDir());
}
?>