/*
 * Decompiled with CFR 0.152.
 */
package avis.base;

import avis.base.AException;
import avis.base.AExceptionThrower;
import avis.base.ALogger;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;

public class Avis
implements ALogger {
    public static final int DIRECTION_STEPS = 256;
    public static final int BANK_STEPS = 256;
    protected static double[] COS;
    protected static double[] SIN;
    protected static boolean initialized;
    protected static Avis instance;
    private static Avis logger;
    private int logLevel;
    private PrintStream logWriter = System.out;

    static {
        Avis.initialize();
    }

    protected Avis() {
    }

    public static String format(long n) {
        String ret = "";
        String comma = "";
        long nn = n;
        while (nn > 0L) {
            String tmp;
            if (nn < 1000L) {
                tmp = Long.toString(nn % 1000L);
            } else {
                tmp = "000" + nn % 1000L;
                tmp = tmp.substring(tmp.length() - 3);
            }
            nn /= 1000L;
            ret = String.valueOf(tmp) + comma + ret;
            comma = ",";
        }
        return ret;
    }

    private static void initialize() {
        if (!initialized) {
            COS = new double[256];
            SIN = new double[256];
            int i = 0;
            while (i < 256) {
                Avis.COS[i] = Math.cos(Math.PI * 2 * (double)i / 256.0);
                Avis.SIN[i] = Math.sin(Math.PI * 2 * (double)i / 256.0);
                ++i;
            }
            instance = new Avis();
            initialized = true;
            logger = instance;
        }
    }

    public static double cos(int i) {
        assert (initialized) : "Util\u30af\u30e9\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        if (i < 0) {
            return COS[256 + i];
        }
        return COS[i % 256];
    }

    public static double sin(int i) {
        assert (initialized) : "Util\u30af\u30e9\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        if (i < 0) {
            return SIN[256 + i];
        }
        return SIN[i % 256];
    }

    public static double sin(int theta1, int theta2) {
        assert (initialized) : "Util\u30af\u30e9\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        return -Avis.cos(theta1) * Avis.sin(theta2) + Avis.sin(theta1) * Avis.cos(theta2);
    }

    public static double cos(int theta1, int theta2) {
        assert (initialized) : "Util\u30af\u30e9\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        return Avis.cos(theta1) * Avis.cos(theta2) + Avis.sin(theta1) * Avis.sin(theta2);
    }

    public static InputStream openUrl(String resourceName) throws AException {
        assert (initialized) : "Util\u30af\u30e9\u30b9\u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        try {
            logger.info("Loading Resoure:resourceName=<" + resourceName + ">");
            URL url = instance.getClass().getClassLoader().getResource(resourceName);
            InputStream ret = url.openStream();
            return ret;
        }
        catch (IOException e) {
            AExceptionThrower.throwIOFailedException(resourceName, e);
            return null;
        }
    }

    public static Image readImage(InputStream is) throws AException {
        BufferedImage ret;
        try {
            ret = ImageIO.read(is);
        }
        catch (IOException e) {
            AExceptionThrower.throwIOFailedException("(unknonwn)", e);
            ret = null;
        }
        return ret;
    }

    public static void closeStream(InputStream is) {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Properties loadPropertes(InputStream is) throws AException {
        Properties ret = new Properties();
        try {
            ret.load(is);
        }
        catch (IOException e) {
            AExceptionThrower.throwIOFailedException("NOT AVAILABLE", e);
        }
        return ret;
    }

    public static double srad2rad(double d) {
        return Math.PI * 2 * d / 256.0;
    }

    public static InputStream openFile(File f) throws AException {
        BufferedInputStream is;
        try {
            is = new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            AExceptionThrower.throwIOFailedException(f.getAbsolutePath(), e);
            is = null;
        }
        return is;
    }

    @Override
    public void debug(String message) {
        if (this.logLevel <= 100) {
            this.logWriter.print("[Debug] ");
            this.logWriter.println(message);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.logLevel <= 100000) {
            this.logWriter.print("[Error] ");
            this.logWriter.println(String.valueOf(message) + "(" + t.getMessage() + ")");
            StackTraceElement[] trace = t.getStackTrace();
            int i = 0;
            while (i < trace.length) {
                this.logWriter.print("[Error] ");
                this.logWriter.println(trace[i]);
                ++i;
            }
        }
    }

    @Override
    public void info(String message) {
        if (this.logLevel <= 1000) {
            this.logWriter.print("[Info] ");
            this.logWriter.println(message);
        }
    }

    @Override
    public void setOut(PrintStream ps) {
        this.logWriter = ps;
    }

    @Override
    public void statistics(String message) {
        if (this.logLevel <= 10000) {
            this.logWriter.print("[Statistics] ");
            this.logWriter.println(message);
        }
    }

    @Override
    public void level(int level) {
        this.logLevel = level;
    }

    @Override
    public int level() {
        return this.logLevel;
    }

    public static ALogger logger() {
        return logger;
    }
}

