/*
 * Decompiled with CFR 0.152.
 */
package avis.motion;

import avis.base.Avis;
import avis.motion.DrivantObserver;
import avis.motion.Group;
import avis.motion.MMachineSpec;
import avis.motion.Parameters;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Drivant {
    protected static final EventDispatcher dispatcher = new EventDispatcher();
    protected Parameters prepared;
    protected Parameters committed;
    protected DrivantObserver observer = DrivantObserver.NULL_OBSERVER;
    protected String label;
    private boolean collisionDetectEnabled = true;
    private static final Product _productPrototype = new Product();

    public Drivant() {
        this.committed = this.createInitialParameters();
    }

    public double bank() {
        return 0.0;
    }

    public void addObserver(DrivantObserver observer) {
        if (observer == DrivantObserver.NULL_OBSERVER || observer == dispatcher) {
            return;
        }
        if (this.observer == DrivantObserver.NULL_OBSERVER) {
            this.observer = dispatcher;
        }
        dispatcher.add(observer, this);
    }

    public void removeObserver(DrivantObserver observer) {
        if (observer != dispatcher) {
            return;
        }
        dispatcher.remove(observer);
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public Set<DrivantObserver> observers() {
        return dispatcher.oberversFor(this);
    }

    public final void commit() {
        this.committed = this.prepared.cloneParameters();
        this.prepared = null;
    }

    public final void rollback() {
        this.prepared = null;
    }

    public final Parameters snapshot() {
        return this.committed.cloneParameters();
    }

    public Parameters parameters() {
        return this.committed;
    }

    protected abstract Parameters createInitialParameters();

    public int direction() {
        return (int)this.committed.direction;
    }

    public Group groupId() {
        return this.parameters().groupId;
    }

    public final void init(Parameters parameters) {
        this.committed = parameters.cloneParameters();
    }

    public boolean isValid() {
        return this.committed.alive;
    }

    public final Parameters prepare() {
        assert (this.prepared == null) : "Object=<" + this + "> is already prepared.";
        this.prepared = this.committed.cloneParameters();
        return this.prepared;
    }

    public abstract void perform();

    public double velocity() {
        return this.committed.velocity;
    }

    public int viewDirection() {
        return (int)this.committed.direction;
    }

    public double x() {
        return this.committed.x;
    }

    public double y() {
        return this.committed.y;
    }

    public double width() {
        return this.committed.width;
    }

    public double height() {
        return this.committed.height;
    }

    public void invalidate() {
        Parameters parameters = this.prepared;
        dispatcher.invalidated(this);
        parameters.alive = false;
    }

    public Product product(Drivant target) {
        Product ret = _productPrototype.cloneProduct();
        if (target != null) {
            Parameters p = this.parameters();
            double dx = target.x() - this.x();
            double dy = target.y() - this.y();
            int direction = (int)p.direction;
            double vx = Avis.cos(direction);
            double vy = Avis.sin(direction);
            ret.inner = dx * vx + dy * vy;
            ret.outer = dx * vy - dy * vx;
            ret.tangent = ret.inner != 0.0 ? ret.outer / ret.inner : (ret.outer > 0.0 ? Double.MAX_VALUE : Double.MIN_VALUE);
            ret.distance = this.distance(target);
        } else {
            ret.inner = Double.MAX_VALUE;
            ret.outer = Double.MAX_VALUE;
            ret.tangent = Double.MAX_VALUE;
            ret.distance = Double.MAX_VALUE;
        }
        return ret;
    }

    public double distance(Drivant another) {
        double dx = this.x() - another.x();
        double dy = this.y() - another.y();
        double r = Math.sqrt(dx * dx + dy * dy);
        return r;
    }

    public void beforeInteraction() {
    }

    public void afterInteraction() {
    }

    public void enableCollisionDetect() {
        this.collisionDetectEnabled = true;
    }

    public void disableCollisionDetect() {
        this.collisionDetectEnabled = false;
    }

    public boolean isCollisionDetectEnabled() {
        return this.collisionDetectEnabled;
    }

    public Parameters rollbackSegment() {
        return this.prepared;
    }

    public static class EventDispatcher
    implements DrivantObserver {
        Set<DrivantObserver> observers = new HashSet<DrivantObserver>();
        Map<DrivantObserver, Set<Drivant>> destinationMap = new HashMap<DrivantObserver, Set<Drivant>>();

        public Set<DrivantObserver> oberversFor(Drivant drivant) {
            HashSet<DrivantObserver> ret = new HashSet<DrivantObserver>();
            for (DrivantObserver cur : this.observers) {
                Set<Drivant> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(drivant)) continue;
                ret.add(cur);
            }
            return ret;
        }

        public void add(DrivantObserver observer, Drivant drivant) {
            this.observers.add(observer);
            Set<Drivant> destinations = null;
            destinations = this.destinationMap.get(observer);
            if (destinations == null) {
                destinations = new HashSet<Drivant>();
                this.destinationMap.put(observer, destinations);
            }
            destinations.add(drivant);
        }

        public void remove(DrivantObserver observer) {
            this.observers.remove(observer);
            if (!this.destinationMap.containsKey(observer)) {
                this.destinationMap.remove(observer);
            }
        }

        @Override
        public void emit(Drivant source, MMachineSpec emittable) {
            for (DrivantObserver cur : this.observers) {
                Set<Drivant> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(source)) continue;
                cur.emit(source, emittable);
            }
        }

        @Override
        public void invalidated(Drivant source) {
            for (DrivantObserver cur : this.observers) {
                Set<Drivant> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(source)) continue;
                cur.invalidated(source);
            }
        }

        @Override
        public void registered(Drivant source) {
            for (DrivantObserver cur : this.observers) {
                Set<Drivant> destinations = this.destinationMap.get(cur);
                if (!destinations.contains(source)) continue;
                cur.registered(source);
            }
        }
    }

    public static class Product
    implements Cloneable {
        public double inner;
        public double outer;
        public double tangent = Double.NaN;
        public double distance = Double.NaN;

        Product cloneProduct() {
            Product ret = null;
            try {
                ret = (Product)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
    }
}

