/*
 * Decompiled with CFR 0.152.
 */
package avis.motion;

import avis.motion.Drivant;
import avis.motion.MMachine;
import avis.motion.MMachineBuilder;
import avis.motion.Parameters;
import avis.spec.ASpriteSpec;
import avis.spec.ASpriteSpecManager;
import avis.sprite.ASprite;
import avis.video.APlane;

public class MMachineBuilderImpl
implements MMachineBuilder {
    protected APlane plane;
    protected ASpriteSpecManager spriteSpecManager;

    protected MMachineBuilderImpl(ASpriteSpecManager manager, APlane plane) {
        this.plane = plane;
        this.spriteSpecManager = manager;
    }

    public static synchronized MMachineBuilder getInstance(ASpriteSpecManager manager, APlane plane) {
        return new MMachineBuilderImpl(manager, plane);
    }

    @Override
    public MMachine buildMMachine(Drivant drivant, Parameters drivantParameters, String spriteSpecName, int priority) {
        drivant.init(drivantParameters);
        ASpriteSpec spriteSpec = this.spriteSpecManager.getSpriteSpec(spriteSpecName);
        ASprite sprite = spriteSpec.createSprite(priority);
        this.plane.attach(sprite);
        if (sprite != null) {
            sprite.visible(true);
        }
        MMachine ret = new MMachine(drivant, sprite);
        return ret;
    }

    @Override
    public APlane plane() {
        return this.plane;
    }
}

