/*
 * Decompiled with CFR 0.152.
 */
package avis.sound;

import avis.base.AException;
import avis.base.AExceptionThrower;
import avis.base.Avis;
import avis.sound.ABGMManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class ADefaultBGMManager
extends ABGMManager {
    private static final int END_OF_TRACK_MESSAGE = 47;
    private Map<String, Sequence> sequences = new HashMap<String, Sequence>();
    private Sequencer sequencer;
    private Sequence playingSequence;
    private long stoppedPosition;
    private long startTick = 0L;

    @Override
    public String load(String resourceName) throws AException {
        String ret = null;
        try {
            InputStream is = Avis.openUrl(resourceName);
            try {
                if (this.sequencer == null) {
                    this.sequencer = MidiSystem.getSequencer();
                    this.sequencer.open();
                    this.sequencer.addMetaEventListener(new MyMetaEventListener(this.sequencer, this.startTick));
                }
                ret = resourceName;
                this.sequences.put(ret, MidiSystem.getSequence(is));
            }
            finally {
                Avis.closeStream(is);
            }
        }
        catch (MidiUnavailableException e) {
            AExceptionThrower.throwFailedToLoadMidiResource(resourceName, e);
        }
        catch (InvalidMidiDataException e) {
            AExceptionThrower.throwFailedToLoadMidiResource(resourceName, e);
        }
        catch (IOException e) {
            AExceptionThrower.throwFailedToLoadMidiResource(resourceName, e);
        }
        return ret;
    }

    @Override
    public void play(String resourceName) {
        Sequence seq = null;
        this.stoppedPosition = -1L;
        seq = this.sequences.get(resourceName);
        if (seq == null) {
            return;
        }
        if (this.playingSequence == seq) {
            return;
        }
        this.stop();
        try {
            this.sequencer.setSequence(seq);
            this.playingSequence = seq;
            this.sequencer.start();
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (this.sequencer.isRunning()) {
            this.stoppedPosition = this.sequencer.getTickPosition();
            this.sequencer.stop();
        }
    }

    @Override
    public void resume() {
        Sequence seq = this.playingSequence;
        if (this.playingSequence != null) {
            try {
                this.sequencer.setSequence(seq);
                this.sequencer.setTickPosition(this.stoppedPosition != -1L ? this.stoppedPosition : this.startTick);
                this.sequencer.start();
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MyMetaEventListener
    implements MetaEventListener {
        private Sequencer sequencer;
        private long startTick;

        public MyMetaEventListener(Sequencer sequencer, long startTick) {
            this.sequencer = sequencer;
            this.startTick = startTick;
        }

        @Override
        public void meta(MetaMessage meta) {
            if (meta.getType() == 47 && this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.setMicrosecondPosition(this.startTick);
                this.sequencer.start();
            }
        }
    }
}

