/*
 * Decompiled with CFR 0.152.
 */
package avis.sound;

import java.io.DataInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class DataClip {
    public byte[] data;
    public int index;
    public AudioFormat format;
    public boolean running = false;
    public int sampleRate;

    public DataClip(byte[] data, AudioFormat format) {
        this.data = data;
        this.index = 0;
        this.format = format;
    }

    public DataClip(AudioInputStream audioStream) throws IOException {
        this.index = 0;
        this.format = audioStream.getFormat();
        int length = (int)(audioStream.getFrameLength() * (long)this.format.getFrameSize());
        this.data = new byte[length];
        DataInputStream is = new DataInputStream(audioStream);
        is.readFully(this.data);
    }

    public void calculateSampleRate(int milliseconds) {
        this.sampleRate = (int)((float)milliseconds * ((float)this.format.getChannels() * this.format.getSampleRate() * (float)this.format.getSampleSizeInBits() / 8.0f) / 1000.0f);
    }
}

