/*
 * Decompiled with CFR 0.152.
 */
package avis.spec;

import avis.base.AException;
import avis.base.AExceptionThrower;
import avis.base.Avis;
import avis.spec.ASpecException;
import avis.spec.ASpriteSpec;
import avis.sprite.AImageSprite;
import avis.sprite.ASprite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import javax.imageio.ImageIO;

public class AImageSpriteSpec
extends ASpriteSpec {
    protected static final String KEY_DISPLAY_HEIGHT = "image.display.height";
    protected static final String KEY_DISPLAY_WIDTH = "image.display.width";
    protected static final String KEY_IMAGES = "image.images";
    protected static final String KEY_HEIGHT = "image.height";
    protected static final String KEY_WIDTH = "image.width";
    protected static final String KEY_DIRECTIONS = "image.directions";
    protected static final String KEY_IMAGE = "image.{0}";
    protected static final String KEY_NAME = "image.name";
    protected static final double UNIT_RATIO = 1.41;
    protected int displayWidth;
    protected int displayHeight;
    protected int unitWidth;
    protected int unitHeight;
    protected int biasX;
    protected int biasY;
    protected int[] unitX;
    protected int[] unitY;
    protected int directionUnits;
    protected int imageUnits;
    protected BufferedImage image;
    protected int patternDenominator;

    @Override
    public void init(Object propertiesResourceName) throws AException {
        InputStream is = Avis.openUrl(propertiesResourceName.toString());
        try {
            this.init(is);
        }
        finally {
            Avis.closeStream(is);
        }
    }

    public void init(InputStream is) throws AException {
        Properties properties = Avis.loadPropertes(is);
        this.init(properties);
    }

    public void init(Properties properties) throws AException {
        if (this.directionUnits > 0) {
            this.unitWidth = (int)Math.ceil((double)this.getWidth(properties) * 1.41);
            this.unitHeight = (int)Math.ceil((double)this.getHeight(properties) * 1.41);
        } else {
            this.unitWidth = (int)Math.ceil(this.getWidth(properties));
            this.unitHeight = (int)Math.ceil(this.getHeight(properties));
        }
        this.displayHeight = this.getDisplayHeight(properties);
        this.displayWidth = this.getDisplayWidth(properties);
        this.biasX = this.displayWidth / 2;
        this.biasY = this.displayHeight / 2;
        this.directionUnits = this.getNumberOfDirections(properties);
        this.imageUnits = this.getNumberOfImages(properties);
        this.patternDenominator = 256 / this.imageUnits;
        int units = Math.max(1, this.directionUnits / 2);
        this.unitX = new int[units];
        this.unitY = new int[this.imageUnits];
        int i = 0;
        while (i < units) {
            this.unitX[i] = i * this.unitWidth;
            ++i;
        }
        i = 0;
        while (i < this.imageUnits) {
            this.unitY[i] = i * this.unitHeight;
            ++i;
        }
        this.image = this.directionUnits > 0 ? this.generateTurnedImages(properties) : this.generateNonturnedImage(properties);
    }

    private BufferedImage generateNonturnedImage(Properties properties) throws AException {
        BufferedImage ret = new BufferedImage(this.unitWidth, this.unitHeight, 2);
        Graphics2D g = (Graphics2D)ret.getGraphics();
        this.initializeImage(g, ret.getWidth(), ret.getHeight());
        Image sourceImage = this.getImageFromProperty(properties, 0);
        g.drawImage(sourceImage, 0, 0, this.unitWidth, this.unitHeight, 0, 0, sourceImage.getWidth(null), sourceImage.getHeight(null), null);
        g.dispose();
        return ret;
    }

    public int getNumberOfImages(Properties properties) throws ASpecException {
        return this.getIntegerFromProperty(properties, KEY_IMAGES);
    }

    public int getNumberOfDirections(Properties properties) throws ASpecException {
        return this.getIntegerFromProperty(properties, KEY_DIRECTIONS);
    }

    public int getWidth(Properties properties) throws ASpecException {
        return this.getIntegerFromProperty(properties, KEY_WIDTH);
    }

    public int getHeight(Properties properties) throws ASpecException {
        return this.getIntegerFromProperty(properties, KEY_HEIGHT);
    }

    public int getDisplayWidth(Properties properties) throws ASpecException {
        return this.getIntegerFromProperty(properties, KEY_DISPLAY_WIDTH);
    }

    public int getDisplayHeight(Properties properties) throws ASpecException {
        return this.getIntegerFromProperty(properties, KEY_DISPLAY_HEIGHT);
    }

    protected int getIntegerFromProperty(Properties properties, String key) throws ASpecException {
        int ret;
        String s = properties.getProperty(key);
        if (s == null) {
            AExceptionThrower.throwSpecifiedKeyNotFoundException(key);
        }
        try {
            ret = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            AExceptionThrower.throwSpecifiedKeyMalformattedException(key, s);
            return -1;
        }
        return ret;
    }

    protected BufferedImage generateTurnedImages(Properties properties) throws AException {
        BufferedImage ret = new BufferedImage(this.unitWidth * this.directionUnits / 2, this.unitHeight * this.imageUnits, 2);
        Graphics2D g = (Graphics2D)ret.getGraphics();
        this.initializeImage(g, ret.getWidth(), ret.getHeight());
        int i = 0;
        while (i < this.imageUnits) {
            Image sourceImage = this.getImageFromProperty(properties, i);
            int units = Math.max(1, this.directionUnits / 2);
            int j = 0;
            while (j < units) {
                this.generateRotatedImage(ret, sourceImage, j, i);
                ++j;
            }
            ++i;
        }
        g.dispose();
        return ret;
    }

    protected Image getImageFromProperty(Properties properties, int i) throws AException {
        BufferedImage ret = null;
        String s = "00" + i;
        s = s.substring(s.length() - 2);
        String imageResource = properties.getProperty(MessageFormat.format(KEY_IMAGE, s));
        InputStream is = Avis.openUrl(imageResource);
        try {
            try {
                ret = ImageIO.read(is);
            }
            catch (IOException e) {
                AExceptionThrower.throwFailedToLoadImage(String.valueOf(imageResource) + "(" + i + ")", e);
                Avis.closeStream(is);
            }
        }
        finally {
            Avis.closeStream(is);
        }
        return ret;
    }

    protected void initializeImage(Graphics g, int w, int h) {
        Color backup = g.getColor();
        Color cc = new Color(0, true);
        g.setColor(cc);
        g.fillRect(0, 0, w, h);
        g.setColor(backup);
    }

    protected void generateRotatedImage(Image destination, Image source, int direction, int image) {
        int originalWidth = source.getWidth(null);
        int originalHeight = source.getHeight(null);
        double theta = (double)direction / (double)this.directionUnits * 256.0;
        Graphics2D g = (Graphics2D)destination.getGraphics();
        BufferedImage tmpImage = new BufferedImage(this.unitWidth, this.unitHeight, 2);
        Graphics2D tmpG = (Graphics2D)tmpImage.getGraphics();
        this.initializeImage(tmpG, this.unitWidth, this.unitHeight);
        tmpG.rotate((64.0 - theta) / 256.0 * 2.0 * Math.PI, (double)this.unitWidth / 2.0, (double)this.unitHeight / 2.0);
        tmpG.drawImage(source, 0, 0, tmpImage.getWidth() - 1, tmpImage.getHeight() - 1, 0, 0, originalWidth, originalHeight, null);
        tmpG.dispose();
        g.drawImage(tmpImage, this.unitX[direction], this.unitY[image], this.unitX[direction] + this.unitWidth - 1, this.unitY[image] + this.unitHeight - 1, 0, 0, this.unitWidth - 1, this.unitHeight - 1, null, null);
        tmpImage.flush();
        tmpImage = null;
        g.dispose();
    }

    protected void generateRotatedImage(Graphics2D g, Image source, int direction, int image) {
        int originalWidth = source.getWidth(null);
        int originalHeight = source.getHeight(null);
        double theta = (double)direction / (double)this.directionUnits * 256.0;
        g.rotate((64.0 - theta) / 256.0 * 2.0 * Math.PI, (double)this.unitX[direction] + (double)this.unitWidth / 2.0, (double)this.unitY[image] + (double)this.unitHeight / 2.0);
        g.drawImage(source, this.unitX[direction], this.unitY[image], this.unitX[direction] + this.unitWidth - 1, this.unitY[image] + this.unitHeight - 1, 0, 0, originalWidth - 1, originalHeight - 1, null, null);
    }

    public int defaultDisplayHeight() {
        return this.unitWidth;
    }

    public int defaultDisplayWidth() {
        return this.unitHeight;
    }

    public int unitWidth() {
        return this.unitWidth;
    }

    public int unitHeight() {
        return this.unitHeight;
    }

    public void paint(Graphics g, int x, int y, int pattern, int direction, int displayWidth, int displayHeight, ImageObserver observer) {
        if (this.directionUnits > 0) {
            double directionRatio = (double)this.directionUnits / 256.0;
            int j = pattern;
            int i = (int)((double)direction * directionRatio) % this.directionUnits;
            if (i < this.directionUnits / 2 || this.directionUnits == 1) {
                g.drawImage(this.image, x - this.biasX, y - this.biasY, x + this.biasX - 1, y + this.biasY - 1, this.unitX[i], this.unitY[j], this.unitX[i] + this.unitWidth - 1, this.unitY[j] + this.unitHeight - 1, observer);
            } else {
                g.drawImage(this.image, x - this.biasX, y - this.biasY, x + this.biasX - 1, y + this.biasY - 1, this.unitX[i -= this.directionUnits / 2] + this.unitWidth - 1, this.unitY[j] + this.unitHeight - 1, this.unitX[i], this.unitY[j], observer);
            }
        } else {
            g.drawImage(this.image, x - this.biasX, y - this.biasY, x + this.biasX - 1, y + this.biasY - 1, 0, 0, this.unitWidth, this.unitHeight, observer);
        }
    }

    @Override
    public int patternDenominator() {
        return this.patternDenominator;
    }

    @Override
    public ASprite createSprite_Protected() {
        AImageSprite ret = new AImageSprite();
        return ret;
    }
}

