/*
 * Decompiled with CFR 0.152.
 */
package avis.video;

import avis.base.AException;
import avis.base.Avis;
import avis.video.AViewport;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.InputStream;
import javax.swing.JComponent;

public class ABackground
extends JComponent {
    private static final long serialVersionUID = 1008157887766723036L;
    protected Image image;
    protected double imageHeight;
    protected double imageWidth;
    protected ImageObserver observer;
    private AViewport viewport;

    protected ABackground(Image background, AViewport viewport) {
        if (background != null) {
            this.image(background);
        }
        this.viewport = viewport;
    }

    public void draw(Graphics2D gg, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        if (this.image != null) {
            double ratio = this.viewport.ratio();
            gg.drawImage(this.image, dx1, dy1, dx2, dy2, (int)((double)sx1 * ratio), (int)((double)sy1 * ratio), (int)((double)sx2 * ratio), (int)((double)sy2 * ratio), null);
        }
    }

    public void image(Image background) {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        this.imageWidth = background.getWidth(this.observer);
        this.imageHeight = background.getHeight(this.observer);
        this.image = background;
        Avis.logger().info("Setup:background=<" + background + ">");
    }

    public Image image() {
        return this.image;
    }

    public double imageWidth() {
        return this.imageWidth * this.viewport.zoom();
    }

    public double imageHeight() {
        return this.imageHeight * this.viewport.zoom();
    }

    public void load(String resource) throws AException {
        InputStream is = Avis.openUrl(resource);
        Image image = null;
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        try {
            image = Avis.readImage(is);
        }
        finally {
            Avis.closeStream(is);
        }
        this.image(image);
    }
}

