/*
 * Decompiled with CFR 0.152.
 */
package avis.video;

import avis.base.AException;
import avis.base.Avis;
import avis.base.Configuration;
import avis.spec.ASpriteSpec;
import avis.sprite.ASprite;
import avis.sprite.IASpriteObserver;
import avis.video.ABackground;
import avis.video.AViewport;
import avis.video.IAPlaneObserver;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class APlane
implements Comparable<APlane>,
IASpriteObserver {
    protected ABackground background;
    protected IAPlaneObserver observer;
    protected List<ASprite> sprites;
    protected AViewport viewport;
    protected int width;
    protected int height;
    private String name;
    private int priority;

    public APlane(String name, AViewport viewport, ABackground background, int width, int height, int priority, IAPlaneObserver observer) {
        this.name = name;
        this.sprites = new LinkedList<ASprite>();
        this.background = background;
        this.viewport = viewport;
        this.width = width;
        this.height = height;
        this.priority = priority;
        this.observer = observer;
    }

    public String name() {
        return this.name;
    }

    public void attach(ASprite sprite) {
        int i = Collections.binarySearch(this.sprites, sprite);
        this.sprites.add(i < 0 ? 0 : i, sprite);
    }

    public boolean detach(ASprite sprite) {
        return this.sprites.remove(sprite);
    }

    public ASprite createSprite(ASpriteSpec spec, int priority) throws AException {
        ASprite ret = spec.createSprite(priority);
        ret.init(spec);
        ret.visible(true);
        this.attach(ret);
        return ret;
    }

    protected void gcSprites() {
        Iterator<ASprite> iSprites = this.sprites.iterator();
        while (iSprites.hasNext()) {
            ASprite cur = iSprites.next();
            if (!cur.isDisposed()) continue;
            iSprites.remove();
        }
    }

    public double height() {
        return this.height;
    }

    public void paint(Graphics g) {
        double x = this.viewport.x();
        double y = this.viewport.y();
        double theta = this.viewport.theta();
        double halfWidth = this.width() / 2.0;
        double halfHeight = this.height() / 2.0;
        Graphics2D gg = (Graphics2D)g;
        AffineTransform backupTransform = gg.getTransform();
        if (Configuration.rotationMode == Configuration.RotationMode.ENABLED) {
            gg.rotate(Avis.srad2rad(theta), halfWidth, halfHeight);
        }
        Rectangle rect = new Rectangle();
        try {
            double _halfHeight;
            double _halfWidth;
            if (Configuration.rotationMode == Configuration.RotationMode.ENABLED) {
                _halfWidth = Math.abs(halfWidth * Avis.cos((int)theta)) + Math.abs(halfHeight * Avis.sin((int)theta));
                _halfHeight = Math.abs(halfWidth * Avis.sin((int)theta)) + Math.abs(halfHeight * Avis.cos((int)theta));
            } else {
                _halfWidth = halfWidth;
                _halfHeight = halfHeight;
            }
            int sx1 = (int)(x - _halfWidth);
            int sy1 = (int)(y - _halfHeight);
            int sx2 = (int)(x + _halfWidth);
            int sy2 = (int)(y + _halfHeight);
            int dx1 = (int)(halfWidth - _halfWidth);
            int dy1 = (int)(halfHeight - _halfHeight);
            int dx2 = (int)(halfWidth + _halfWidth);
            int dy2 = (int)(halfHeight + _halfHeight);
            this.background.draw(gg, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
            int _x1 = Math.min(dx1, dx2);
            int _y1 = Math.min(dy1, dy2);
            int _x2 = Math.max(dx1, dx2);
            int _y2 = Math.max(dy1, dy2);
            rect.setBounds(_x1, _y1, _x2 - _x1, _y2 - _y1);
            for (ASprite cur : this.sprites()) {
                if (!cur.visible() || !cur.touches(rect)) continue;
                cur.paint(gg, null);
            }
            if (Configuration.debugMode == Configuration.DebugMode.GRID) {
                this.debugGrid(gg);
            }
            this.gcSprites();
        }
        finally {
            gg.setTransform(backupTransform);
        }
    }

    private void debugGrid(Graphics2D gg) {
        Color c = gg.getColor();
        try {
            gg.setColor(Color.yellow);
            int i = 0;
            while (i <= this.width) {
                gg.drawLine(i, 0, i, this.height);
                i += 50;
            }
            i = 0;
            while (i <= this.height) {
                gg.drawLine(0, i, this.width, i);
                i += 50;
            }
            i = 0;
            while (i < this.width) {
                int j = 0;
                while (j <= this.height) {
                    gg.drawString("(" + i + "," + j + ")", i, j);
                    j += 100;
                }
                i += 100;
            }
        }
        finally {
            gg.setColor(c);
        }
    }

    public void background(ABackground background) {
        this.background = background;
    }

    public ABackground background() {
        return this.background;
    }

    public List<ASprite> sprites() {
        return this.sprites;
    }

    public AViewport viewport() {
        return this.viewport;
    }

    public double width() {
        return this.width;
    }

    @Override
    public int compareTo(APlane o) {
        return -(this.priority - o.priority);
    }

    public int priority() {
        return this.priority;
    }

    public void priority(int priority) {
        this.priority = priority;
        if (this.observer != null) {
            this.observer.priorityChanged(this);
        }
    }

    public void clear() {
        while (this.sprites.size() > 0) {
            ASprite cur = this.sprites.remove(0);
            cur.dispose();
        }
    }

    @Override
    public void disposed(ASprite sprite) {
    }

    @Override
    public void priorityChanged(ASprite sprite) {
        if (this.sprites.contains(sprite)) {
            Collections.sort(this.sprites);
        }
    }

    @Override
    public void setVisible(ASprite sprite, boolean visible) {
    }
}

