/*
 * Decompiled with CFR 0.152.
 */
package avis.video;

import avis.base.AException;
import avis.base.Avis;
import avis.base.Configuration;
import avis.input.ACompositeDevice;
import avis.input.AInputDevice;
import avis.input.AJoypadDevice;
import avis.input.AKeyboardDevice;
import avis.input.APS3JoystickDevice;
import avis.spec.ASpriteSpec;
import avis.spec.ASpriteSpecManager;
import avis.sprite.AMessageSprite;
import avis.sprite.ASprite;
import avis.sprite.ASpriteException;
import avis.sprite.IASpriteObserver;
import avis.video.ABackground;
import avis.video.APlane;
import avis.video.AViewport;
import avis.video.IAPlaneObserver;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;

public class AScreen
extends JFrame
implements IAPlaneObserver,
IASpriteObserver {
    private static final String FOREGROUND_PLANE = "FOREGROUND_PLANE";
    private static final String BACKGROUND_PLANE = "BACKGROUND_PLANE";
    protected APlane foregroundPlane = null;
    protected APlane backgroundPlane = null;
    private static final long serialVersionUID = -4359479588246032825L;
    protected Image bImage;
    protected List<APlane> planes = new LinkedList<APlane>();
    protected AInputDevice stick;
    protected Graphics2D graphics2d;
    protected String bgImageResourceName;
    protected List<ASpriteSpec> specs = new LinkedList<ASpriteSpec>();
    protected int messagePriority = 9999;
    protected ASpriteSpecManager spriteSpecManager;
    protected boolean closed;
    private GraphicsDevice device;
    private BufferStrategy bufferStrategy = null;

    public AScreen(int width, int height, ASpriteSpecManager manager) {
        this.spriteSpecManager = manager;
        this.closed = false;
        this.setSize(width, height);
        this.setResizable(false);
        this.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AScreen.this.closed = true;
            }
        });
        Avis.logger().info("width=" + width + ", height=" + height);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public APlane createPlane(String name, int priority, Image backgroundImage) throws ASpriteException {
        AViewport viewport = new AViewport(this);
        ABackground background = null;
        background = new ABackground(backgroundImage, viewport);
        APlane newPlane = new APlane(name, viewport, background, this.getWidth(), this.getHeight(), priority, this);
        this.planes.add(newPlane);
        return newPlane;
    }

    public List<APlane> planes() {
        return this.planes;
    }

    public void init() throws AException, ASpriteException {
        try {
            if (Configuration.videoMode == Configuration.VideoMode.NORMAL) {
                Avis.logger().info("normal video mode");
                this.device = null;
                this.setVisible(true);
                this.bImage = Configuration.renderingMode == Configuration.RenderingMode.VOLATILE ? this.createVolatileImage((int)((double)this.getWidth() * 1.0), (int)((double)this.getHeight() * 1.0)) : this.createImage((int)((double)this.getWidth() * 1.0), (int)((double)this.getHeight() * 1.0));
                this.graphics2d = (Graphics2D)this.bImage.getGraphics();
            } else {
                int w = this.getWidth();
                int h = this.getHeight();
                this.setVisible(false);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.device = ge.getDefaultScreenDevice();
                Avis.logger().statistics("Available vram=<" + this.device.getAvailableAcceleratedMemory() + ">");
                if (this.device.isFullScreenSupported()) {
                    Avis.logger().info("go fullscreen");
                    this.setUndecorated(true);
                    BufferedImage cursorImage = new BufferedImage(1, 1, 2);
                    Graphics g = ((Image)cursorImage).getGraphics();
                    g.clearRect(0, 0, 1, 1);
                    g.dispose();
                    Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "");
                    this.setCursor(cursor);
                    this.device.setFullScreenWindow(this);
                    DisplayMode[] modes = this.device.getDisplayModes();
                    int d = -1;
                    int r = 0;
                    DisplayMode modeChosen = null;
                    int i = 0;
                    while (i < modes.length) {
                        Avis.logger().debug("mode=<" + modes[i].getWidth() + "," + modes[i].getHeight() + "," + modes[i].getBitDepth() + "," + modes[i].getRefreshRate() + ">");
                        if (modes[i].getWidth() >= w && modes[i].getHeight() >= h && modes[i].getBitDepth() >= d && modes[i].getRefreshRate() >= r && (modeChosen == null || modeChosen.getWidth() >= modes[i].getWidth() && modeChosen.getHeight() >= modes[i].getHeight() && modeChosen.getBitDepth() <= modes[i].getBitDepth() && modeChosen.getRefreshRate() <= modes[i].getRefreshRate())) {
                            modeChosen = modes[i];
                        }
                        ++i;
                    }
                    if (this.device.isDisplayChangeSupported()) {
                        Avis.logger().info("width=<" + w + ">");
                        Avis.logger().info("height=<" + h + ">");
                        if (modeChosen != null) {
                            this.device.setDisplayMode(modeChosen);
                            this.createBufferStrategy(2);
                            this.bufferStrategy = this.getBufferStrategy();
                            Avis.logger().statistics("mode(width,height,depth,refresh rate)=<" + modeChosen.getWidth() + "," + modeChosen.getHeight() + "," + modeChosen.getBitDepth() + "," + modeChosen.getRefreshRate() + ">");
                        } else {
                            Avis.logger().info("There is no applicable screen mode.");
                        }
                    } else {
                        this.terminate();
                    }
                    Avis.logger().info("full screen supported=<" + this.device.isFullScreenSupported() + ">");
                    Avis.logger().info("display change supported=<" + this.device.isDisplayChangeSupported() + ">");
                } else {
                    Avis.logger().info("not able to go fullscreen");
                    Avis.logger().info("full screen supported=<" + this.device.isFullScreenSupported() + ">");
                    Avis.logger().info("display change supported=<" + this.device.isDisplayChangeSupported() + ">");
                    this.device = null;
                }
            }
        }
        finally {
            if (this.graphics2d == null && Configuration.renderingMode == Configuration.RenderingMode.BUFFERED) {
                this.setVisible(true);
                this.toFront();
                this.bImage = this.createImage((int)((double)this.getWidth() * 1.0), (int)((double)this.getHeight() * 1.0));
                this.graphics2d = (Graphics2D)this.bImage.getGraphics();
                if (this.bufferStrategy != null) {
                    this.bufferStrategy.dispose();
                    this.bufferStrategy = null;
                }
            }
            if (Configuration.renderingMode == Configuration.RenderingMode.VOLATILE) {
                this.setVisible(true);
                this.bImage = this.createVolatileImage((int)((double)this.getWidth() * 1.0), (int)((double)this.getHeight() * 1.0));
                this.graphics2d = (Graphics2D)this.bImage.getGraphics();
                Avis.logger().debug("Wndows mode is selected.");
            }
            Avis.logger().info("Device setup:bImage=<" + this.bImage + ">, graphics2d=<" + this.graphics2d + ">, bufferStrategy=<" + this.bufferStrategy + ">");
        }
        if (this.bufferStrategy != null) {
            Avis.logger().statistics("Window mode=<Full screen mode>");
        } else {
            Avis.logger().statistics("Window mode=<Normal window mode>");
        }
        if (Configuration.renderingMode == Configuration.RenderingMode.VOLATILE) {
            Avis.logger().statistics("Rendering mode=<Volatile image>");
        } else {
            Avis.logger().statistics("Rendering mode=<Buffered image>");
        }
        Avis.logger().info("Setup: bImage=<" + this.bImage + ">");
        this.stick = new ACompositeDevice();
        if (Configuration.joystickMode != Configuration.JoystickMode.DISABLED) {
            try {
                Avis.logger().info("System property java.library.path=<" + System.getProperty("java.library.path") + ">");
                if (Configuration.joystickMode == Configuration.JoystickMode.JOYPAD) {
                    ((ACompositeDevice)this.stick).add(new AJoypadDevice());
                } else if (Configuration.joystickMode == Configuration.JoystickMode.PS3) {
                    ((ACompositeDevice)this.stick).add(new APS3JoystickDevice());
                }
            }
            catch (IOException e) {
                Avis.logger().info("No joystick found");
            }
        }
        AKeyboardDevice keyboardDevice = new AKeyboardDevice();
        ((ACompositeDevice)this.stick).add(keyboardDevice);
        this.addKeyListener(keyboardDevice);
        this.backgroundPlane = this.loadPlaneFromResource(BACKGROUND_PLANE, 0, this.bgImageResourceName);
        this.backgroundPlane.viewport().zoom(1.0);
        this.foregroundPlane = this.createPlane(FOREGROUND_PLANE, 10000, null);
    }

    public APlane loadPlaneFromResource(String planeName, int priority, String resourceName) throws AException, ASpriteException {
        InputStream is = resourceName != null ? Avis.openUrl(resourceName) : null;
        try {
            APlane aPlane = this.loadPlane(planeName, priority, is);
            return aPlane;
        }
        catch (AException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (is != null) {
                Avis.closeStream(is);
            }
        }
    }

    public APlane loadPlane(String planeName, int priority, InputStream is) throws AException, ASpriteException {
        Image image = is != null ? Avis.readImage(is) : null;
        APlane ret = this.createPlane(planeName, priority, image);
        return ret;
    }

    void renderOffscreen(Graphics2D gg) {
        if (this.bufferStrategy == null && Configuration.renderingMode == Configuration.RenderingMode.VOLATILE) {
            VolatileImage vImg = (VolatileImage)this.bImage;
            do {
                if (vImg.validate(this.getGraphicsConfiguration()) == 2) {
                    vImg = this.createVolatileImage(this.getWidth(), this.getHeight());
                }
                this.graphics2d = vImg.createGraphics();
                for (APlane cur : this.planes) {
                    cur.paint(this.graphics2d);
                }
                this.graphics2d.dispose();
            } while (vImg.contentsLost());
        } else {
            for (APlane cur : this.planes) {
                cur.paint(gg);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (Configuration.renderingMode == Configuration.RenderingMode.VOLATILE) {
            VolatileImage vImg = (VolatileImage)this.bImage;
            if (vImg != null) {
                do {
                    int returnCode;
                    if ((returnCode = vImg.validate(this.getGraphicsConfiguration())) == 1) {
                        this.renderOffscreen((Graphics2D)g);
                    } else if (returnCode == 2) {
                        vImg = this.createVolatileImage(this.getWidth(), this.getHeight());
                        this.renderOffscreen((Graphics2D)g);
                    }
                    g.drawImage(vImg, 0, 0, this);
                } while (vImg.contentsLost());
            } else {
                Avis.logger().debug("volatile image is currently <null>");
            }
        } else {
            g.drawImage(this.bImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    public void render() {
        if (this.bufferStrategy == null) {
            this.renderOffscreen(this.graphics2d);
            Graphics g = this.getGraphics();
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
        Graphics2D gg = (Graphics2D)this.bufferStrategy.getDrawGraphics();
        try {
            this.renderOffscreen(gg);
        }
        finally {
            gg.dispose();
        }
        if (!this.bufferStrategy.contentsLost()) {
            this.bufferStrategy.show();
        } else {
            Avis.logger().info("BufferStrategy Contents Lost");
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public AInputDevice stick() {
        return this.stick;
    }

    public APlane backgroundPlane() {
        return this.backgroundPlane;
    }

    public APlane foregroundPlane() {
        return this.foregroundPlane;
    }

    public void clear() {
        for (APlane cur : this.planes) {
            cur.clear();
        }
    }

    @Override
    public void priorityChanged(APlane plane) {
        Collections.sort(this.planes);
    }

    public AMessageSprite message(String message, int x, int y, Color c, float fontSize, int durationToDisplay) {
        return this.message(message, x, y, c, fontSize, durationToDisplay, "PlainMessage");
    }

    public AMessageSprite message(String message, int x, int y, Color c, float fontSize, int durationToDisplay, String messageSpecName) {
        AMessageSprite ret = null;
        try {
            ret = (AMessageSprite)this.createSprite(this.foregroundPlane, messageSpecName, this.messagePriority);
            if (fontSize != -1.0f) {
                ret.size(fontSize);
            }
            ret.plane(this.foregroundPlane);
            ret.color(c);
            ret.lifetime(durationToDisplay);
            ret.message(message);
            ret.put(x, y);
        }
        catch (AException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public AMessageSprite message(String message, int x, int y, Color c, float fontSize) {
        return this.message(message, x, y, c, fontSize, -1);
    }

    public ASprite createSprite(APlane plane, String spriteSpecName, int priority) throws AException {
        Avis.logger().info("Creating sprite from spec named=<" + spriteSpecName + ">");
        ASprite ret = plane.createSprite(this.spriteSpecManager.getSpriteSpec(spriteSpecName), priority);
        ret.visible(true);
        return ret;
    }

    @Override
    public void disposed(ASprite sprite) {
        if (sprite instanceof AMessageSprite) {
            sprite.spec();
            this.specs.remove(sprite);
        }
    }

    @Override
    public void setVisible(ASprite sprite, boolean visible) {
    }

    @Override
    public void priorityChanged(ASprite sprite) {
    }

    public void terminate() {
        if (this.device != null) {
            Window w = this.device.getFullScreenWindow();
            if (w != null) {
                w.dispose();
            }
            this.device.setFullScreenWindow(null);
        }
    }
}

