/*
 * Decompiled with CFR 0.152.
 */
package avis.video;

import avis.base.AException;
import avis.base.AResourceObserver;
import avis.base.Avis;
import avis.spec.ASpriteSpecManager;
import avis.sprite.ASpriteException;
import avis.video.AScreen;
import java.awt.Dimension;
import java.awt.Toolkit;

public class AVideoEngine {
    protected static AVideoEngine instance = null;
    protected AScreen screen;
    private ASpriteSpecManager spriteSpecManager;
    private int width;
    private int height;
    AResourceObserver observer = new AResourceObserver(){

        @Override
        public void endLoading(String resourceName) {
        }

        @Override
        public void startLoading(String resourceName) {
        }
    };

    protected AVideoEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVideoEngine instance() {
        Class<AVideoEngine> clazz = AVideoEngine.class;
        synchronized (AVideoEngine.class) {
            if (instance == null) {
                instance = new AVideoEngine();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void resourceObserver(AResourceObserver observer) {
        this.observer = observer;
    }

    public void size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public synchronized AScreen getScreen() throws ASpriteException, AException {
        if (this.screen == null) {
            this.screen = this.createScreen(this.width, this.height);
            this.screen.setSize(this.width, this.height);
        }
        return this.screen;
    }

    public synchronized ASpriteSpecManager getSpriteSpecManager() {
        if (this.spriteSpecManager == null) {
            this.spriteSpecManager = this.createSpriteSpecManager(this.observer);
        }
        return this.spriteSpecManager;
    }

    private ASpriteSpecManager createSpriteSpecManager(AResourceObserver observer) {
        ASpriteSpecManager ret = new ASpriteSpecManager(observer);
        return ret;
    }

    protected Dimension getDesktopSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize;
    }

    protected AScreen createScreen(int width, int height) throws ASpriteException, AException {
        Dimension desktopSize = this.getDesktopSize();
        AScreen screen = new AScreen(width, height, this.getSpriteSpecManager());
        Avis.logger().info("Setup: desktop width = <" + desktopSize.width + ">");
        Avis.logger().info("Setup: desktop height = <" + desktopSize.height + ">");
        screen.setLocation(desktopSize.width / 2 - width / 2, desktopSize.height / 2 - height / 2);
        screen.init();
        return screen;
    }

    public void terminate() {
        if (this.screen != null) {
            this.screen.terminate();
        }
        instance = null;
    }
}

