/*
 * Decompiled with CFR 0.152.
 */
package siovanus;

import avis.motion.Group;
import java.util.LinkedList;
import java.util.List;

public class SGroup
extends Group
implements Comparable<SGroup> {
    public static final Group Enemy_Aerial = new SGroup("Enemy_Aerial");
    public static final Group Player_Aerial = new SGroup("Player_Aerial");
    public static final Group Enemy_Surface = new SGroup("Enemy_Surface");
    public static final Group Player_Surface = new SGroup("Player_Surface");
    private static List<Pair> collidablePairs = new LinkedList<Pair>();
    private static List<Pair> interactablePairs;

    static {
        collidablePairs.add(new Pair(Player_Aerial, Enemy_Aerial));
        collidablePairs.add(new Pair(Player_Surface, Enemy_Surface));
        interactablePairs = new LinkedList<Pair>();
        interactablePairs.add(new Pair(Player_Aerial, Enemy_Aerial));
        interactablePairs.add(new Pair(Player_Aerial, Enemy_Surface));
        interactablePairs.add(new Pair(Player_Surface, Enemy_Aerial));
        interactablePairs.add(new Pair(Player_Surface, Enemy_Surface));
    }

    public SGroup(String tag) {
        super(tag);
    }

    @Override
    public int compareTo(SGroup o) {
        return this.toString().compareTo(o.toString());
    }

    private boolean checkReaction(Group another, List<Pair> reactionPairs) {
        for (Pair cur : reactionPairs) {
            if (!cur.equals(this, another)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean interacts(Group another) {
        return this.checkReaction(another, interactablePairs);
    }

    @Override
    public boolean collides(Group another) {
        return this.checkReaction(another, collidablePairs);
    }

    protected static class Pair {
        Group a;
        Group b;

        public Pair(Group a, Group b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Group g1, Group g2) {
            return g1 == this.a && g2 == this.b || g1 == this.b && g2 == this.a;
        }
    }
}

