/*
 * Decompiled with CFR 0.152.
 */
package siovanus.drivant.aviator;

import avis.input.AInputDevice;
import avis.motion.Drivant;
import siovanus.drivant.AviatorDrivant;
import siovanus.drivant.aviator.Aviator;

public class UserAviator
extends Aviator {
    protected AInputDevice inputDevice;
    protected TwistActionState twistActionState = TwistActionState.Neutral;
    protected int remainingStateDuration = 0;
    public static final int INITIAL_ENERGY = 4800;
    private int _twistEnergy = 4800;
    public static final int TWIST_ENERGY_REQUIRED = 2400;

    public UserAviator(AInputDevice inputDevice) {
        this.inputDevice = inputDevice;
    }

    @Override
    public void performAction(AviatorDrivant drivant, Drivant target) {
        AInputDevice.Stick s = this.inputDevice.cursor();
        if (s == AInputDevice.Stick.UP || s == AInputDevice.Stick.UP_LEFT || s == AInputDevice.Stick.UP_RIGHT) {
            drivant.accelerate();
        } else if (s == AInputDevice.Stick.DOWN || s == AInputDevice.Stick.DOWN_LEFT || s == AInputDevice.Stick.DOWN_RIGHT) {
            drivant.decelerate();
        }
        boolean rollOnly = false;
        TurningDirection turningDirection = TurningDirection.Neutral;
        if (s == AInputDevice.Stick.RIGHT || s == AInputDevice.Stick.UP_RIGHT || s == AInputDevice.Stick.DOWN_RIGHT) {
            if (this.inputDevice.trigger(AInputDevice.Trigger.L1) || !this.inputDevice.trigger(AInputDevice.Trigger.R1)) {
                drivant.yawRight();
                drivant.recoverYawHalf();
            }
            if ((rollOnly = this.inputDevice.trigger(AInputDevice.Trigger.R1)) || !this.inputDevice.trigger(AInputDevice.Trigger.L1)) {
                drivant.rollRight(rollOnly);
            }
            turningDirection = TurningDirection.Right;
        } else if (s == AInputDevice.Stick.LEFT || s == AInputDevice.Stick.UP_LEFT || s == AInputDevice.Stick.DOWN_LEFT) {
            if (this.inputDevice.trigger(AInputDevice.Trigger.L1) || !this.inputDevice.trigger(AInputDevice.Trigger.R1)) {
                drivant.yawLeft();
                drivant.recoverYawHalf();
            }
            if ((rollOnly = this.inputDevice.trigger(AInputDevice.Trigger.R1)) || !this.inputDevice.trigger(AInputDevice.Trigger.L1)) {
                drivant.rollLeft(rollOnly);
            }
            turningDirection = TurningDirection.Left;
        } else {
            drivant.recoverYaw();
            drivant.recoverBank();
        }
        if (this.inputDevice.trigger(AInputDevice.Trigger.SQUARE)) {
            drivant.shot();
        }
        if (this.inputDevice.trigger(AInputDevice.Trigger.CIRCLE)) {
            drivant.bomb();
        }
        if (this.remainingStateDuration > 0) {
            --this.remainingStateDuration;
            if (this.twistActionState == TwistActionState.LeftTwist || this.twistActionState == TwistActionState.RightTwist) {
                drivant.disableCollisionDetect();
                this.twist(drivant);
            }
        } else {
            drivant.enableCollisionDetect();
            this.twistActionState = TwistActionState.Neutral;
        }
        this._twistEnergy = Math.min(4800, this._twistEnergy + 1);
        if (this.twistActionState == TwistActionState.Neutral) {
            if (this._twistEnergy > 2400) {
                if (turningDirection == TurningDirection.Left && this.inputDevice.trigger(AInputDevice.Trigger.L1)) {
                    this.twistActionState = TwistActionState.LeftTwist;
                    this._twistEnergy -= 2400;
                    this.remainingStateDuration = 96;
                } else if (turningDirection == TurningDirection.Right && this.inputDevice.trigger(AInputDevice.Trigger.L1)) {
                    this.twistActionState = TwistActionState.RightTwist;
                    this._twistEnergy -= 2400;
                    this.remainingStateDuration = 96;
                }
            }
        } else if (this.twistActionState != TwistActionState.RightTwist) {
        }
    }

    protected void twist(AviatorDrivant drivant) {
        if (this.twistActionState == TwistActionState.RightTwist) {
            drivant.rollRight(2.0, false);
        } else if (this.twistActionState == TwistActionState.LeftTwist) {
            drivant.rollLeft(2.0, false);
        }
    }

    @Override
    public boolean isTwisting() {
        return this.twistActionState == TwistActionState.LeftTwist || this.twistActionState == TwistActionState.RightTwist;
    }

    @Override
    public int energy() {
        return this._twistEnergy;
    }

    protected static enum TurningDirection {
        Left,
        Right,
        Neutral;

    }

    protected static enum TwistActionState {
        Neutral,
        RightTwist,
        LeftTwist;

    }
}

