#!/bin/sh

SIOVANUS_EXEC=`stat --printf "%N" $0 | sed "s/.+ -\> //g" | sed "s/^\\\`//g" | sed "s/'$//g"`
SIOVANUS_HOME=`dirname $SIOVANUS_EXEC`
USER_HOME=`cd; pwd`
MACHINE=`uname -m`
if [ $MACHINE = 'i386' -o $MACHINE = 'i686' ] 
then export LD_LIBRARY_PATH=$SIOVANUS_HOME/lib/linux_i386
elif [ $MACHINE = 'ia64' -o $MACHINE = 'x86_64' ]
then export LD_LIBRARY_PATH=$SIOVANUS_HOME/lib/linux_x86_64
else exit "Unsupported architecture '$MACHINE'"
fi

CLASSPATH=${SIOVANUS_HOME}/siovanus.jar:${SIOVANUS_HOME}/lib/Joystick.jar
VMARGS="-client -Dsun.java2d.opengl=true -Xms384m -Xmx384m"
APPARGS="-video=FULL -rendering=VOLATILE -bgquality=HIGH -session=siovanus.SSession"
APPARGS=$APPARGS" -joystick=PS3"
LOG=${USER_HOME}/.siovanus.log
JAVA=java

$JAVA -cp $CLASSPATH  $VMARGS avis.session.ASession $APPARGS > $LOG  &