/*
 * Decompiled with CFR 0.152.
 */
package plus.reflect;

import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import plus.reflect.Cache;
import plus.util.NumHelper;

final class RefHelper {
    static final Map<Class<?>, Class<?>> PRIM_TYPES = new HashMap();
    private static final Constructor<?>[] EMPTY_CONSTRUCTOR_ARRAY = new Constructor[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Comparable[] EXTRACTS = new Comparable[]{new Comparable(){

        @Override
        public boolean exclude(Class<?> prm, Class<?> arg, Object val) {
            return val instanceof Number && null == NUMBER_TYPES.get(prm);
        }
    }, new Comparable(){

        @Override
        public boolean exclude(Class<?> prm, Class<?> arg, Object val) {
            boolean bc = false;
            if (val instanceof Number && (prm.isPrimitive() || null != NUMBER_TYPES.get(prm))) {
                if (!(Integer.TYPE != prm && Integer.class != prm || Long.class != arg && Double.class != arg && Float.class != arg)) {
                    bc = true;
                } else if (!(Long.TYPE != prm && Long.class != prm || Double.class != arg && Float.class != arg)) {
                    bc = true;
                } else if ((Short.TYPE == prm || Short.class == prm) && Byte.class != arg) {
                    bc = true;
                }
            }
            return bc;
        }
    }, new Comparable(){

        @Override
        public boolean exclude(Class<?> prm, Class<?> arg, Object val) {
            return val instanceof Number && arg != NUMBER_TYPES.get(prm);
        }
    }, new Comparable(){

        @Override
        public boolean exclude(Class<?> prm, Class<?> arg, Object val) {
            return prm.isPrimitive() ? arg != PRIM_TYPES.get(prm) : prm != arg;
        }
    }, null};
    private static final int NUMBER_CAPACITY = 19;
    static final Map<Class<?>, Class<?>> NUMBER_TYPES = new HashMap(19);

    private RefHelper() {
    }

    static Object cast(Class<?> prmType, Class<?> argType, Object arg) {
        Object a = arg;
        if (prmType != argType && null != prmType) {
            if (prmType.isPrimitive()) {
                double d = NumHelper.doubleValue(arg);
                if (prmType == Double.TYPE) {
                    a = d;
                } else if (prmType == Integer.TYPE) {
                    a = (int)d;
                } else if (prmType == Boolean.TYPE) {
                    a = 0.0 != d;
                } else if (prmType == Long.TYPE) {
                    a = (long)d;
                } else if (prmType == Short.TYPE) {
                    a = (short)d;
                } else if (prmType == Float.TYPE) {
                    a = Float.valueOf((float)d);
                } else if (prmType == Byte.TYPE) {
                    a = (byte)d;
                } else if (prmType == Character.TYPE) {
                    a = Character.valueOf((char)d);
                }
            } else if (!(CharSequence.class != prmType && String.class != prmType || arg instanceof String)) {
                a = arg.toString();
            }
        }
        return a;
    }

    static Object[] cast(Class<?>[] prmTypes, Class<?>[] argTypes, Object[] args) {
        int prmlen = prmTypes.length;
        int i = args.length;
        Object[] arr = new Object[i];
        while (0 <= --i) {
            Class<?> prm = prmlen > i ? prmTypes[i] : (1 <= prmlen ? prmTypes[prmlen - 1] : null);
            arr[i] = RefHelper.cast(prm, argTypes[i], args[i]);
        }
        return arr;
    }

    private static List<Class<?>[]> extract(Object[] args, Class<?>[] argTypes, List<Class<?>[]> parmTypes) {
        List<Class<?>[]> buf = parmTypes;
        for (Comparable comp : EXTRACTS) {
            ArrayList<Class<?>[]> xxx = new ArrayList<Class<?>[]>();
            for (Class<?>[] parms : buf) {
                int prmlen = parms.length;
                boolean hasNext = true;
                int len = argTypes.length;
                for (int i = 0; hasNext && len > i; ++i) {
                    Class<?> prm;
                    Class<?> arg = argTypes[i];
                    Class<Object> clazz = prmlen > i ? parms[i] : (prm = 1 <= prmlen ? parms[prmlen - 1] : null);
                    if (prm == arg || null != comp && !comp.exclude(prm, arg, args[i])) continue;
                    hasNext = false;
                }
                if (!hasNext) continue;
                xxx.add(parms);
            }
            if (1 == xxx.size()) {
                return xxx;
            }
            buf = xxx.isEmpty() ? buf : xxx;
        }
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static Constructor<?> getConstructor(Class<?> clazz, Object[] args, Class<?>[] argTypes) {
        Constructor<?>[] x = RefHelper.getConstructors(clazz, args.length);
        if (2 <= x.length) {
            void var8_10;
            HashMap map = new HashMap();
            List<Class<?>[]> buf = new ArrayList<Class<?>[]>();
            Constructor<?>[] constructorArray = x;
            int n = constructorArray.length;
            boolean bl = false;
            while (var8_10 < n) {
                Constructor<?> m = constructorArray[var8_10];
                Class<?>[] prmTypes = m.getParameterTypes();
                if (RefHelper.isAssignable(args, argTypes, prmTypes)) {
                    map.put(prmTypes, m);
                    buf.add(prmTypes);
                }
                ++var8_10;
            }
            if (1 < buf.size()) {
                ArrayList<Class[]> tmp = new ArrayList<Class[]>();
                for (Class[] classArray : buf) {
                    if (!RefHelper.isInstance(args, classArray)) continue;
                    tmp.add(classArray);
                }
                if (!tmp.isEmpty()) {
                    buf = tmp;
                }
                if (1 < buf.size()) {
                    buf = RefHelper.extract(args, argTypes, buf);
                }
            }
            if (1 != buf.size()) {
                RefHelper.info(RefHelper.mkString("WARNING: newInstance: " + String.valueOf(clazz), argTypes));
                RefHelper.info(RefHelper.mkString(buf.toArray()));
            }
            return buf.isEmpty() ? x[0] : (Constructor)map.get(buf.get(0));
        }
        return 1 == x.length ? x[0] : null;
    }

    private static Constructor<?>[] getConstructors(Class<?> clazz, int argslen) {
        String name = clazz.getName();
        String key = argslen + "," + name;
        Constructor[] x = (Constructor[])Cache.CONSTRUCTOR.get(key);
        if (null == x) {
            ArrayList buf = new ArrayList();
            for (Constructor<?> m : clazz.getConstructors()) {
                Class<?>[] prm = m.getParameterTypes();
                int prmlen = prm.length;
                if (prmlen != argslen && (!m.isVarArgs() || prmlen - 1 > argslen)) continue;
                buf.add(m);
                if (0 == prmlen) break;
            }
            if (!buf.isEmpty()) {
                x = buf.toArray(new Constructor[0]);
                Cache.CONSTRUCTOR.put(key, x);
            }
        }
        return null == x ? EMPTY_CONSTRUCTOR_ARRAY : x;
    }

    @Nullable
    static Field getField(Class<?> clazz, String name) {
        String key = RefHelper.getFieldKey(clazz, name);
        Field x = (Field)Cache.FIELD.get(key);
        if (null == x) {
            Field[][] fieldArrayArray = new Field[][]{clazz.getDeclaredFields(), clazz.getFields()};
            int n = fieldArrayArray.length;
            for (int i = 0; i < n; ++i) {
                Field[] g;
                for (Field m : g = fieldArrayArray[i]) {
                    if (!m.getName().equals(name)) continue;
                    Cache.FIELD.put(key, m);
                    return m;
                }
            }
        }
        return x;
    }

    static String getFieldKey(Class<?> clazz, String name) {
        return clazz.getName() + "," + name;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static Method getMethod(Class<?> clazz, String name, Object[] args, Class<?>[] argTypes) {
        Method[] x = RefHelper.getMethods(clazz, name, args.length);
        if (2 <= x.length) {
            void var9_11;
            HashMap<Class<?>[], Method> map = new HashMap<Class<?>[], Method>();
            List<Class<?>[]> buf = new ArrayList<Class<?>[]>();
            Method[] methodArray = x;
            int n = methodArray.length;
            boolean bl = false;
            while (var9_11 < n) {
                Method m = methodArray[var9_11];
                Class<?>[] prm = m.getParameterTypes();
                if (RefHelper.isAssignable(args, argTypes, prm)) {
                    map.put(prm, m);
                    buf.add(prm);
                }
                ++var9_11;
            }
            if (1 < buf.size()) {
                ArrayList<Class[]> tmp = new ArrayList<Class[]>();
                for (Class[] classArray : buf) {
                    if (!RefHelper.isInstance(args, classArray)) continue;
                    tmp.add(classArray);
                }
                if (!tmp.isEmpty()) {
                    buf = tmp;
                }
                if (1 < buf.size()) {
                    buf = RefHelper.extract(args, argTypes, buf);
                }
            }
            if (1 != buf.size()) {
                RefHelper.info(RefHelper.mkString("WARNING: Invoke: " + String.valueOf(clazz) + "." + name, argTypes));
                RefHelper.info(RefHelper.mkString(buf.toArray()));
            }
            return buf.isEmpty() ? x[0] : (Method)map.get(buf.get(0));
        }
        return 1 == x.length ? x[0] : null;
    }

    static Method[] getMethods(Class<?> clazz, String name, int argslen) {
        String key = argslen + "," + clazz.getName() + "#" + name;
        Method[] x = (Method[])Cache.METHOD.get(key);
        if (null == x) {
            ArrayList buf;
            HashMap<CallSite, Method> map = new HashMap<CallSite, Method>();
            Method[][] methodArrayArray = new Method[][]{clazz.getDeclaredMethods(), clazz.getMethods()};
            int n = methodArrayArray.length;
            block0: for (int i = 0; i < n; ++i) {
                Method[] g;
                for (Method m : g = methodArrayArray[i]) {
                    boolean hasVarArgs;
                    if (!m.getName().equals(name)) continue;
                    Class<?>[] prm = m.getParameterTypes();
                    int prmlen = prm.length;
                    boolean bl = hasVarArgs = prmlen - 1 <= argslen && m.isVarArgs();
                    if (prmlen != argslen && !hasVarArgs) continue;
                    String ps = Arrays.toString(m.getParameterTypes());
                    map.put((CallSite)((Object)(name + "`" + ps)), m);
                    if (0 == prmlen) break block0;
                }
            }
            if (!(buf = new ArrayList(map.values())).isEmpty()) {
                x = buf.toArray(new Method[0]);
                Cache.METHOD.put(key, x);
            }
        }
        return null == x ? EMPTY_METHOD_ARRAY : x;
    }

    static void info(String msg) {
        System.err.println("INFO: " + msg);
    }

    private static boolean isAssignable(Object[] args, Class<?>[] argTypes, Class<?>[] prmTypes) {
        int prmlen = prmTypes.length;
        int len = args.length;
        for (int i = 0; len > i; ++i) {
            Class<?> prm;
            Class<?> arg = argTypes[i];
            Class<Object> clazz = prmlen > i ? prmTypes[i] : (prm = 1 <= prmlen ? prmTypes[prmlen - 1] : null);
            if (null != prm && (!prm.isPrimitive() || null != args[i] && (prm == arg || prm.isAssignableFrom(arg) || args[i] instanceof Number))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInstance(Object[] args, Class<?>[] prmTypes) {
        int prmlen = prmTypes.length;
        int len = args.length;
        for (int i = 0; len > i; ++i) {
            Class<?> prm;
            Class<Object> clazz = prmlen > i ? prmTypes[i] : (prm = 1 <= prmlen ? prmTypes[prmlen - 1] : null);
            if (null != prm && prm.isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    private static String mkString(Object[] args) {
        return RefHelper.mkString("\t", "\n\t", "", args);
    }

    static String mkString(String prefix, Object[] args) {
        return RefHelper.mkString(prefix + "[", ", ", "]", args);
    }

    private static String mkString(String start, String sep, String end, Object[] args) {
        StringBuilder sb = new StringBuilder(start);
        boolean is1st = true;
        for (Object x : args) {
            if (is1st) {
                is1st = false;
            } else {
                sb.append(sep);
            }
            if (x instanceof Object[]) {
                sb.append(Arrays.toString((Object[])x));
                continue;
            }
            sb.append(x);
        }
        sb.append(end);
        return sb.toString();
    }

    static {
        PRIM_TYPES.put(Boolean.TYPE, Boolean.class);
        PRIM_TYPES.put(Byte.TYPE, Byte.class);
        PRIM_TYPES.put(Character.TYPE, Character.class);
        PRIM_TYPES.put(Double.TYPE, Double.class);
        PRIM_TYPES.put(Float.TYPE, Float.class);
        PRIM_TYPES.put(Integer.TYPE, Integer.class);
        PRIM_TYPES.put(Long.TYPE, Long.class);
        PRIM_TYPES.put(Short.TYPE, Short.class);
        NUMBER_TYPES.put(Byte.TYPE, Byte.class);
        NUMBER_TYPES.put(Double.TYPE, Double.class);
        NUMBER_TYPES.put(Float.TYPE, Float.class);
        NUMBER_TYPES.put(Integer.TYPE, Integer.class);
        NUMBER_TYPES.put(Long.TYPE, Long.class);
        NUMBER_TYPES.put(Short.TYPE, Short.class);
        NUMBER_TYPES.put(Byte.class, Byte.TYPE);
        NUMBER_TYPES.put(Double.class, Double.TYPE);
        NUMBER_TYPES.put(Float.class, Float.TYPE);
        NUMBER_TYPES.put(Integer.class, Integer.TYPE);
        NUMBER_TYPES.put(Long.class, Long.TYPE);
        NUMBER_TYPES.put(Short.class, Short.TYPE);
        NUMBER_TYPES.put(Number.class, Number.class);
    }

    private static interface Comparable {
        public boolean exclude(Class<?> var1, Class<?> var2, Object var3);
    }
}

