## csv [-Fs] [-v OFS=s] [-v col=<c1...>] [-v fmt=<formats>] [-v del=<d1...>] file...
#
# F = " "       # Input Field Separator (FS) (" " means /[ \t]+/)
# OFS = " "     # Output Field Separator (OFS)
var col = "0"   # c1 [,c2...] Output Field selection
var fmt = ""    # Output format specification (ex."04d, 4d,-4s")
var del = ""    # d1 [,d2...] Delete column
var stdout = "/dev/stdout"  # Output file
BEGIN {
	len1 = split(del, DEL, ",")
	len2 = split(col, COL, ",")
	split(fmt, FMT, ",")
}
	{
	for (i = 1; i <= len1; i++) {
		$(DEL[i]) = ""  # Delete column
	}
	x = ""
	for (i = 1; i <= len2; i++) {
		k = $COL[i]
		if (FMT[i] != "") k = sprintf("%" FMT[i], k)
		x = x k OFS
	}
	gsub(OFS "+", OFS, x) # Cleanup OFS
	gsub("^" OFS "+|" OFS "+$", "", x) # Trim OFS
	print x > stdout    # GAWK extension
}