/*
 * Decompiled with CFR 0.152.
 */
package plus.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Range
implements Iterable<Integer>,
Iterator<Integer> {
    private final AtomicInteger atom;
    private final int endValue;
    private final Queue<Integer> queue = new ConcurrentLinkedQueue<Integer>();
    private final int stepValue;

    public Range(Number start, Number end, Number step) {
        this.atom = new AtomicInteger(start.intValue());
        this.endValue = end.intValue();
        this.stepValue = step.intValue();
    }

    @Nullable
    private Integer getNext() {
        int x = this.atom.addAndGet(this.stepValue) - this.stepValue;
        return 0 <= this.stepValue * (this.endValue - x) ? Integer.valueOf(x) : null;
    }

    @Override
    public boolean hasNext() {
        Integer x = this.getNext();
        return null != x && this.queue.add(x);
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        Range range = this;
        if (range == null) {
            Range.$$$reportNull$$$0(0);
        }
        return range;
    }

    @Override
    public Integer next() {
        Integer x = this.queue.poll();
        if (null == x && null == (x = this.getNext())) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    @Deprecated
    public void remove() {
        throw new IllegalStateException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "plus/concurrent/Range", "iterator"));
    }
}

